/**
 * ...
 * @author Henri Sarasvirta
 */

(function() {
	var Water = function(main, id){
		this.Id = id;
		this.main = main;
	}
	var p = Water.prototype = new wideload.BasePart();
	wideload.Water = Water;
	
	p.superInitialize = p.initialize;

	p.initialize = function(scene,container){
		this.superInitialize(scene,container);
		
		
		this.container.position.x = 0;
		this.container.position.y = 0
		this.container.position.z = -200;
		
		
		this.parameters = {
			width: 1000,
			height: 1000,
			widthSegments: 250,
			heightSegments: 250,
			depth: 1500,
			param: 4,
			filterparam: 1
		}
		
		var waterNormals;

				directionalLight = new THREE.DirectionalLight( 0xffff55, 1 );
				directionalLight.position.set( - 1, 0.4, - 1 );
				scene.add( directionalLight );
				
				waterNormals = new THREE.Texture(Asset.getAsset("waterNormals"));// new THREE.ImageUtils.loadTexture( 'assets/waternormals.jpg' );
				waterNormals.wrapS = waterNormals.wrapT = THREE.RepeatWrapping; 
				waterNormals.needsUpdate = true;
				this.water = new THREE.Water( this.main.renderer, this.main.camera, scene, {
					textureWidth: 512, 
					textureHeight: 512,
					waterNormals: waterNormals,
					alpha: 	1,
					sunDirection: directionalLight.position.normalize(),
					sunColor: 0xffffff,
					waterColor: 0x001e0f,
					distortionScale: 10.0,
				} );
				
				mirrorMesh = new THREE.Mesh(
					new THREE.PlaneGeometry( this.parameters.width*500 , this.parameters.height*500 , 50, 50 ), 
					this.water.material
				);
				
				
				mirrorMesh.add( this.water );
				mirrorMesh.rotation.x = - Math.PI * 0.5;
				this.container.add( mirrorMesh );
				
			//	this.container.position.z = -600;
				
				
				
	}
	
	p.internalUpdate = function(elapsedtime,renderTarget){
		if(this.startTime + 8000 > elapsedtime)
		{
			this.container.visible = false;
		}
		else
		{
			this.container.visible = true;
		}

		//this.animation.update(delta);
		this.water.material.uniforms.time.value += 1.0 / 90.0;
		this.water.render();
	}
	
	
	
})();
