#version 330
in vec2 vTexCoord;

layout( location = 0 ) out vec4 outColor;

uniform sampler2DMS uTexSampler;
uniform int uSampleCount;
uniform vec2 uResolution;

void main()
{
	vec4 color = vec4( 0.0 );
	for( int i = 0; i < uSampleCount; i++ )
	{
		color += texelFetch( uTexSampler, ivec2(vTexCoord * uResolution), i );
	}
	color /= float(uSampleCount);
	outColor = color;
}