/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;

public class Box {
    public static Texture texture;
    Vec3 dim;
    public int[] textureIDs;
    public static int demoSky;
    static int[] nullList;

    static {
        demoSky = Box.initTexture("demo_sky.png");
        nullList = new int[]{-1, -1, -1, -1, -1, -1};
    }

    public Box(int[] ti, Vec3 dim) {
        this.dim = dim;
        this.textureIDs = ti;
    }

    public static int initTexture(String name) {
        try {
            texture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream(name));
            System.out.println("Texture loaded: " + texture);
            System.out.println(">> Image width: " + texture.getImageWidth());
            System.out.println(">> Image height: " + texture.getImageHeight());
            System.out.println(">> Texture width: " + texture.getTextureWidth());
            System.out.println(">> Texture height: " + texture.getTextureHeight());
            System.out.println(">> Texture ID: " + texture.getTextureID());
        }
        catch (IOException e) {
            System.out.println("Texture " + name);
            e.printStackTrace();
        }
        return texture.getTextureID();
    }

    public void render(Vec3 pos) {
        Box.renderBox(pos, this.dim, new Vec3(0.0f, 1.0f, 0.0f), null);
    }

    public static void renderBoxCorner(Vec3 cornerPos, Vec3 dim, Vec3 color) {
        Box.renderBox(new Vec3(cornerPos.x + dim.x / 2.0f, cornerPos.y + dim.y / 2.0f, cornerPos.z + dim.z / 2.0f), dim, color);
    }

    public static void renderBoxCorner(Vec3 cornerPos, Vec3 dim, Vec3 color, int[] textureIDs) {
        Box.renderBox(new Vec3(cornerPos.x + dim.x / 2.0f, cornerPos.y + dim.y / 2.0f, cornerPos.z + dim.z / 2.0f), dim, color, textureIDs);
    }

    public static void renderBox(Vec3 pos, Vec3 dim, Vec3 color) {
        Box.renderBox(pos, dim, color, nullList);
    }

    public static void renderBox(Vec3 pos, Vec3 dim, int tex) {
        Box.renderBox(pos, dim, Vec3.CYAN, new int[]{tex, tex, tex, tex, tex, tex});
    }

    public static void renderBox(Vec3 pos, Vec3 dim, Vec3 color, int[] textureIDs) {
        GL11.glPushMatrix();
        GL11.glColor3f(1.0f, 0.0f, 0.0f);
        GL11.glTranslatef(pos.x, pos.y, pos.z);
        if (textureIDs[0] != -1) {
            Color.white.bind();
            GL11.glBindTexture(3553, textureIDs[0]);
        } else {
            GL11.glColor3f(color.x, color.y, color.z);
        }
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(dim.x / 2.0f, dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-dim.x / 2.0f, dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-dim.x / 2.0f, dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(dim.x / 2.0f, dim.y / 2.0f, dim.z / 2.0f);
        GL11.glEnd();
        GL11.glBindTexture(3553, 0);
        if (textureIDs[1] != -1) {
            Color.white.bind();
            GL11.glBindTexture(3553, textureIDs[1]);
        } else {
            GL11.glColor3f(color.x * 0.8f, color.y * 0.8f, color.z * 0.8f);
        }
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(dim.x / 2.0f, -dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-dim.x / 2.0f, -dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-dim.x / 2.0f, -dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(dim.x / 2.0f, -dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glEnd();
        GL11.glBindTexture(3553, 0);
        if (textureIDs[2] != -1) {
            Color.white.bind();
            GL11.glBindTexture(3553, textureIDs[2]);
        } else {
            GL11.glColor3f(color.x * 0.9f, color.y * 0.9f, color.z * 0.9f);
        }
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(dim.x / 2.0f, -dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-dim.x / 2.0f, -dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-dim.x / 2.0f, dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(dim.x / 2.0f, dim.y / 2.0f, dim.z / 2.0f);
        GL11.glEnd();
        GL11.glBindTexture(3553, 0);
        if (textureIDs[3] != -1) {
            Color.white.bind();
            GL11.glBindTexture(3553, textureIDs[3]);
        } else {
            GL11.glColor3f(color.x * 0.8f, color.y * 0.8f, color.z * 0.8f);
        }
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(dim.x / 2.0f, -dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-dim.x / 2.0f, -dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-dim.x / 2.0f, dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(dim.x / 2.0f, dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glEnd();
        GL11.glBindTexture(3553, 0);
        if (textureIDs[4] != -1) {
            Color.white.bind();
            GL11.glBindTexture(3553, textureIDs[4]);
        } else {
            GL11.glColor3f(color.x * 0.95f, color.y * 0.95f, color.z * 0.95f);
        }
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(-dim.x / 2.0f, -dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-dim.x / 2.0f, dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-dim.x / 2.0f, dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(-dim.x / 2.0f, -dim.y / 2.0f, dim.z / 2.0f);
        GL11.glEnd();
        GL11.glBindTexture(3553, 0);
        if (textureIDs[5] != -1) {
            Color.white.bind();
            GL11.glBindTexture(3553, textureIDs[5]);
        } else {
            GL11.glColor3f(color.x * 0.85f, color.y * 0.85f, color.z * 0.85f);
        }
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(dim.x / 2.0f, -dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(dim.x / 2.0f, dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(dim.x / 2.0f, dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(dim.x / 2.0f, -dim.y / 2.0f, dim.z / 2.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }
}

