/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.examples.spaceinvaders;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import org.lwjgl.BufferUtils;
import org.lwjgl.examples.spaceinvaders.Texture;
import org.lwjgl.opengl.GL11;

public class TextureLoader {
    private HashMap<String, Texture> table = new HashMap();
    private ColorModel glAlphaColorModel;
    private ColorModel glColorModel;
    private IntBuffer textureIDBuffer = BufferUtils.createIntBuffer(1);

    public TextureLoader() {
        this.glAlphaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
        this.glColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 0}, false, false, 1, 0);
    }

    private int createTextureID() {
        GL11.glGenTextures(this.textureIDBuffer);
        return this.textureIDBuffer.get(0);
    }

    public Texture getTexture(String resourceName) throws IOException {
        Texture tex = this.table.get(resourceName);
        if (tex != null) {
            return tex;
        }
        tex = this.getTexture(resourceName, 3553, 6408, 9729, 9729);
        this.table.put(resourceName, tex);
        return tex;
    }

    public Texture getTexture(String resourceName, int target, int dstPixelFormat, int minFilter, int magFilter) throws IOException {
        int textureID = this.createTextureID();
        Texture texture = new Texture(target, textureID);
        GL11.glBindTexture(target, textureID);
        BufferedImage bufferedImage = this.loadImage(resourceName);
        texture.setWidth(bufferedImage.getWidth());
        texture.setHeight(bufferedImage.getHeight());
        int srcPixelFormat = bufferedImage.getColorModel().hasAlpha() ? 6408 : 6407;
        ByteBuffer textureBuffer = this.convertImageData(bufferedImage, texture);
        if (target == 3553) {
            GL11.glTexParameteri(target, 10241, minFilter);
            GL11.glTexParameteri(target, 10240, magFilter);
        }
        GL11.glTexImage2D(target, 0, dstPixelFormat, TextureLoader.get2Fold(bufferedImage.getWidth()), TextureLoader.get2Fold(bufferedImage.getHeight()), 0, srcPixelFormat, 5121, textureBuffer);
        return texture;
    }

    private static int get2Fold(int fold) {
        int ret;
        for (ret = 2; ret < fold; ret *= 2) {
        }
        return ret;
    }

    private ByteBuffer convertImageData(BufferedImage bufferedImage, Texture texture) {
        BufferedImage texImage;
        int texWidth;
        int texHeight = 2;
        for (texWidth = 2; texWidth < bufferedImage.getWidth(); texWidth *= 2) {
        }
        while (texHeight < bufferedImage.getHeight()) {
            texHeight *= 2;
        }
        texture.setTextureHeight(texHeight);
        texture.setTextureWidth(texWidth);
        if (bufferedImage.getColorModel().hasAlpha()) {
            WritableRaster raster = Raster.createInterleavedRaster(0, texWidth, texHeight, 4, null);
            texImage = new BufferedImage(this.glAlphaColorModel, raster, false, new Hashtable());
        } else {
            WritableRaster raster = Raster.createInterleavedRaster(0, texWidth, texHeight, 3, null);
            texImage = new BufferedImage(this.glColorModel, raster, false, new Hashtable());
        }
        Graphics g = texImage.getGraphics();
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g.fillRect(0, 0, texWidth, texHeight);
        g.drawImage(bufferedImage, 0, 0, null);
        byte[] data = ((DataBufferByte)texImage.getRaster().getDataBuffer()).getData();
        ByteBuffer imageBuffer = ByteBuffer.allocateDirect(data.length);
        imageBuffer.order(ByteOrder.nativeOrder());
        imageBuffer.put(data, 0, data.length);
        imageBuffer.flip();
        return imageBuffer;
    }

    private BufferedImage loadImage(String ref) throws IOException {
        URL url = TextureLoader.class.getClassLoader().getResource(ref);
        if (url == null) {
            throw new IOException("Cannot find: " + ref);
        }
        Image img = new ImageIcon(url).getImage();
        BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        Graphics g = bufferedImage.getGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bufferedImage;
    }
}

