/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.openal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCdevice;
import org.lwjgl.openal.OpenALException;
import org.lwjgl.test.openal.BasicTest;

public class ALCCaptureTest
extends BasicTest {
    protected void execute(String[] args) {
        boolean lastError = false;
        IntBuffer sampleCount = BufferUtils.createIntBuffer(1);
        int state = 4114;
        int FMT = 4353;
        int FMTSIZE = 2;
        int FREQ = 44100;
        int TIME = 5;
        int SAMPS = FREQ * TIME;
        ByteBuffer buf = BufferUtils.createByteBuffer(SAMPS * FMTSIZE);
        if (!ALC10.alcIsExtensionPresent(AL.getDevice(), "ALC_EXT_CAPTURE")) {
            throw new OpenALException("ALC_EXT_CAPTURE extension not available");
        }
        String[] captureDevices = ALC10.alcGetString(null, 784).split("\u0000");
        System.out.println("Available Capture Devices: ");
        for (int i = 0; i < captureDevices.length; ++i) {
            System.out.println(i + ": " + captureDevices[i]);
        }
        String defaultRecorder = ALC10.alcGetString(AL.getDevice(), 785);
        System.out.println("Default capture device: " + defaultRecorder);
        ALCdevice device = ALC11.alcCaptureOpenDevice(null, FREQ, FMT, SAMPS);
        if (device != null) {
            System.out.print("Recording using " + ALC10.alcGetString(device, 784) + "...");
            ALC11.alcCaptureStart(device);
            while (sampleCount.get(0) < SAMPS) {
                this.pause(1000L);
                ALC10.alcGetInteger(device, 786, sampleCount);
            }
            System.out.println("done");
            ALC11.alcCaptureStop(device);
            ALC11.alcCaptureSamples(device, buf, SAMPS);
            ALC11.alcCaptureCloseDevice(device);
            IntBuffer buffers = BufferUtils.createIntBuffer(1);
            IntBuffer sources = BufferUtils.createIntBuffer(1);
            buffers.position(0).limit(1);
            AL10.alGenBuffers(buffers);
            sources.position(0).limit(1);
            AL10.alGenSources(sources);
            System.out.print("Playing...");
            AL10.alBufferData(buffers.get(0), FMT, buf, FREQ);
            AL10.alSourcei(sources.get(0), 4105, buffers.get(0));
            AL10.alSourcei(sources.get(0), 4103, 0);
            AL10.alSourcePlay(sources.get(0));
            while (state == 4114) {
                this.pause(100L);
                state = AL10.alGetSourcei(sources.get(0), 4112);
            }
            System.out.println("done");
            AL10.alDeleteSources(sources);
            AL10.alDeleteBuffers(buffers);
        }
        this.alExit();
    }

    public static void main(String[] args) {
        ALCCaptureTest alcTest = new ALCCaptureTest();
        alcTest.execute(args);
        System.exit(0);
    }
}

