/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.openal;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCcontext;
import org.lwjgl.openal.ALCdevice;
import org.lwjgl.openal.EFX10;
import org.lwjgl.openal.EFXUtil;
import org.lwjgl.util.WaveData;

public final class EFX10Test {
    public static void main(String[] args) throws Exception {
        EFX10Test.silentTests();
        EFX10Test.playbackTest();
        EFX10Test.efxUtilTest();
    }

    private static void setupEfx() throws Exception {
        if (!AL.isCreated()) {
            AL.create();
        }
        if (!ALC10.alcIsExtensionPresent(AL.getDevice(), "ALC_EXT_EFX")) {
            throw new Exception("No ALC_EXT_EFX supported by driver.");
        }
        System.out.println("ALC_EXT_EFX found.");
    }

    private static void silentTests() throws Exception {
        EFX10Test.setupEfx();
        ALCdevice device = AL.getDevice();
        IntBuffer contextAttribList = BufferUtils.createIntBuffer(8);
        contextAttribList.put(4103);
        contextAttribList.put(44100);
        contextAttribList.put(4104);
        contextAttribList.put(60);
        contextAttribList.put(4105);
        contextAttribList.put(0);
        contextAttribList.rewind();
        contextAttribList.put(131075);
        contextAttribList.put(2);
        ALCcontext newContext = ALC10.alcCreateContext(device, contextAttribList);
        if (newContext == null) {
            throw new Exception("Failed to create context.");
        }
        int contextCurResult = ALC10.alcMakeContextCurrent(newContext);
        if (contextCurResult == 0) {
            throw new Exception("Failed to make context current.");
        }
        System.out.println("AL_VERSION: " + AL10.alGetString(45058));
        IntBuffer buff = BufferUtils.createIntBuffer(1);
        ALC10.alcGetInteger(device, 131073, buff);
        System.out.println("ALC_EFX_MAJOR_VERSION: " + buff.get(0));
        ALC10.alcGetInteger(device, 131074, buff);
        System.out.println("ALC_EFX_MINOR_VERSION: " + buff.get(0));
        ALC10.alcGetInteger(device, 131075, buff);
        int maxAuxSends = buff.get(0);
        System.out.println("ALC_MAX_AUXILIARY_SENDS: " + maxAuxSends);
        int numAuxSlots = 0;
        int[] auxEffectSlots = new int[4];
        AL10.alGetError();
        for (numAuxSlots = 0; numAuxSlots < 4; ++numAuxSlots) {
            auxEffectSlots[numAuxSlots] = EFX10.alGenAuxiliaryEffectSlots();
            if (AL10.alGetError() != 0) break;
        }
        System.out.println("Created " + numAuxSlots + " aux effect slots.");
        int numEffects = 0;
        int[] effects = new int[2];
        for (numEffects = 0; numEffects < 2; ++numEffects) {
            effects[numEffects] = EFX10.alGenEffects();
            if (AL10.alGetError() != 0) break;
        }
        System.out.println("Created " + numEffects + " effects.");
        AL10.alGetError();
        if (EFX10.alIsEffect(effects[0])) {
            EFX10.alEffecti(effects[0], 32769, 1);
            if (AL10.alGetError() != 0) {
                System.out.println("Reverb effect not supported.");
            } else {
                EFX10.alEffectf(effects[0], 5, 5.0f);
                System.out.println("Reverb effect created.");
            }
        } else {
            throw new Exception("First effect not a valid effect.");
        }
        AL10.alGetError();
        if (EFX10.alIsEffect(effects[1])) {
            EFX10.alEffecti(effects[1], 32769, 5);
            if (AL10.alGetError() != 0) {
                System.out.println("Flanger effect not support.");
            } else {
                EFX10.alEffecti(effects[1], 2, 180);
                System.out.println("Flanger effect created.");
            }
        } else {
            throw new Exception("Second effect not a valid effect.");
        }
        AL10.alGetError();
        int filter = EFX10.alGenFilters();
        if (AL10.alGetError() != 0) {
            throw new Exception("Failed to create filter.");
        }
        System.out.println("Generated a filter.");
        if (EFX10.alIsFilter(filter)) {
            EFX10.alFilteri(filter, 32769, 1);
            if (AL10.alGetError() != 0) {
                System.out.println("Low pass filter not supported.");
            } else {
                EFX10.alFilterf(filter, 1, 0.5f);
                EFX10.alFilterf(filter, 2, 0.5f);
                System.out.println("Low pass filter created.");
            }
        }
        AL10.alGetError();
        EFX10.alAuxiliaryEffectSloti(auxEffectSlots[0], 1, effects[0]);
        if (AL10.alGetError() != 0) {
            throw new Exception("Failed to attach effect to aux effect slot.");
        }
        System.out.println("Successfully loaded effect into effect slot.");
        int source = AL10.alGenSources();
        AL11.alSource3i(source, 131078, auxEffectSlots[0], 0, 0);
        if (AL10.alGetError() != 0) {
            throw new Exception("Failed to configure Source Send 0");
        }
        System.out.println("Linked aux effect slot to soutce slot 0");
        AL11.alSource3i(source, 131078, auxEffectSlots[1], 1, filter);
        if (AL10.alGetError() != 0) {
            throw new Exception("Failed to configure Source Send 1");
        }
        System.out.println("Linked aux effect slot to soutce slot 1");
        AL11.alSource3i(source, 131078, 0, 0, 0);
        if (AL10.alGetError() != 0) {
            throw new Exception("Failed to disable Source Send 0");
        }
        System.out.println("Disabled source send 0");
        AL11.alSource3i(source, 131078, 0, 1, 0);
        if (AL10.alGetError() != 0) {
            throw new Exception("Failed to disable Source Send 1");
        }
        System.out.println("Disabled source send 1");
        AL10.alSourcei(source, 131077, filter);
        if (AL10.alGetError() == 0) {
            System.out.println("Successfully applied a direct path filter");
            AL10.alSourcei(source, 131077, 0);
            if (AL10.alGetError() == 0) {
                System.out.println("Successfully removed direct filter");
            }
            AL11.alSource3i(source, 131078, auxEffectSlots[0], 0, filter);
            if (AL10.alGetError() == 0) {
                System.out.println("Successfully applied aux send filter");
                AL11.alSource3i(source, 131078, auxEffectSlots[0], 0, 0);
                if (AL10.alGetError() == 0) {
                    System.out.println("Successfully removed filter");
                }
            }
        }
        AL10.alSourcef(source, 131081, 0.5f);
        if (AL10.alGetError() == 0) {
            System.out.println("Successfully set cone outside gain filter");
        }
        AL10.alListenerf(131076, 0.3f);
        if (AL10.alGetError() == 0) {
            System.out.println("Successfully set distance units");
        }
        IntBuffer auxEffectSlotsBuf = (IntBuffer)BufferUtils.createIntBuffer(auxEffectSlots.length).put(auxEffectSlots).rewind();
        EFX10.alDeleteAuxiliaryEffectSlots(auxEffectSlotsBuf);
        IntBuffer effectsBuf = (IntBuffer)BufferUtils.createIntBuffer(effects.length).put(effects).rewind();
        EFX10.alDeleteEffects(effectsBuf);
        EFX10.alDeleteFilters(filter);
        AL.destroy();
    }

    private static void playbackTest() throws Exception {
        EFX10Test.setupEfx();
        int source = AL10.alGenSources();
        int buffer = AL10.alGenBuffers();
        WaveData waveFile = WaveData.create("Footsteps.wav");
        if (waveFile == null) {
            System.out.println("Failed to load Footsteps.wav! Skipping playback test.");
            AL.destroy();
            return;
        }
        AL10.alBufferData(buffer, waveFile.format, waveFile.data, waveFile.samplerate);
        waveFile.dispose();
        AL10.alSourcei(source, 4105, buffer);
        AL10.alSourcei(source, 4103, 1);
        System.out.println("Playing sound unaffected by EFX ...");
        AL10.alSourcePlay(source);
        Thread.sleep(7500L);
        int effectSlot = EFX10.alGenAuxiliaryEffectSlots();
        int reverbEffect = EFX10.alGenEffects();
        EFX10.alEffecti(reverbEffect, 32769, 1);
        EFX10.alEffectf(reverbEffect, 5, 5.0f);
        EFX10.alAuxiliaryEffectSloti(effectSlot, 1, reverbEffect);
        AL11.alSource3i(source, 131078, effectSlot, 0, 0);
        System.out.println("Playing sound with reverb ...");
        AL10.alSourcePlay(source);
        Thread.sleep(7500L);
        int filter = EFX10.alGenFilters();
        EFX10.alFilteri(filter, 32769, 1);
        EFX10.alFilterf(filter, 1, 0.5f);
        EFX10.alFilterf(filter, 2, 0.5f);
        AL10.alSourcei(source, 131077, filter);
        System.out.println("Playing sound with reverb and direct low pass filter ...");
        AL10.alSourcePlay(source);
        Thread.sleep(7500L);
        AL10.alSourcei(source, 131077, 0);
        AL11.alSource3i(source, 131078, 0, 0, 0);
        EFX10.alAuxiliaryEffectSloti(effectSlot, 1, 0);
        EFX10.alDeleteEffects(reverbEffect);
        EFX10.alDeleteFilters(filter);
        int echoEffect = EFX10.alGenEffects();
        EFX10.alEffecti(echoEffect, 32769, 4);
        EFX10.alAuxiliaryEffectSloti(effectSlot, 1, echoEffect);
        AL11.alSource3i(source, 131078, effectSlot, 0, 0);
        System.out.println("Playing sound with echo effect ...");
        AL10.alSourcePlay(source);
        Thread.sleep(7500L);
        AL.destroy();
    }

    private static void efxUtilTest() throws Exception {
        EFX10Test.setupEfx();
        System.out.println();
        System.out.println("Checking supported effects ...");
        if (EFXUtil.isEffectSupported(0)) {
            System.out.println("AL_EFFECT_NULL is supported.");
        } else {
            System.out.println("AL_EFFECT_NULL is NOT supported.");
        }
        if (EFXUtil.isEffectSupported(32768)) {
            System.out.println("AL_EFFECT_EAXREVERB is supported.");
        } else {
            System.out.println("AL_EFFECT_EAXREVERB is NOT supported.");
        }
        if (EFXUtil.isEffectSupported(1)) {
            System.out.println("AL_EFFECT_REVERB is supported.");
        } else {
            System.out.println("AL_EFFECT_REVERB is NOT supported.");
        }
        if (EFXUtil.isEffectSupported(2)) {
            System.out.println("AL_EFFECT_CHORUS is supported.");
        } else {
            System.out.println("AL_EFFECT_CHORUS is NOT supported.");
        }
        if (EFXUtil.isEffectSupported(3)) {
            System.out.println("AL_EFFECT_DISTORTION is supported.");
        } else {
            System.out.println("AL_EFFECT_DISTORTION is NOT supported.");
        }
        if (EFXUtil.isEffectSupported(4)) {
            System.out.println("AL_EFFECT_ECHO is supported.");
        } else {
            System.out.println("AL_EFFECT_ECHO is NOT supported.");
        }
        if (EFXUtil.isEffectSupported(5)) {
            System.out.println("AL_EFFECT_FLANGER is supported.");
        } else {
            System.out.println("AL_EFFECT_FLANGER is NOT supported.");
        }
        if (EFXUtil.isEffectSupported(6)) {
            System.out.println("AL_EFFECT_FREQUENCY_SHIFTER is supported.");
        } else {
            System.out.println("AL_EFFECT_FREQUENCY_SHIFTER is NOT supported.");
        }
        if (EFXUtil.isEffectSupported(7)) {
            System.out.println("AL_EFFECT_VOCAL_MORPHER is supported.");
        } else {
            System.out.println("AL_EFFECT_VOCAL_MORPHER is NOT supported.");
        }
        if (EFXUtil.isEffectSupported(8)) {
            System.out.println("AL_EFFECT_PITCH_SHIFTER is supported.");
        } else {
            System.out.println("AL_EFFECT_PITCH_SHIFTER is NOT supported.");
        }
        if (EFXUtil.isEffectSupported(9)) {
            System.out.println("AL_EFFECT_RING_MODULATOR is supported.");
        } else {
            System.out.println("AL_EFFECT_RING_MODULATOR is NOT supported.");
        }
        if (EFXUtil.isEffectSupported(10)) {
            System.out.println("AL_EFFECT_AUTOWAH is supported.");
        } else {
            System.out.println("AL_EFFECT_AUTOWAH is NOT supported.");
        }
        if (EFXUtil.isEffectSupported(11)) {
            System.out.println("AL_EFFECT_COMPRESSOR is supported.");
        } else {
            System.out.println("AL_EFFECT_COMPRESSOR is NOT supported.");
        }
        if (EFXUtil.isEffectSupported(12)) {
            System.out.println("AL_EFFECT_EQUALIZER is supported.");
        } else {
            System.out.println("AL_EFFECT_EQUALIZER is NOT supported.");
        }
        System.out.println();
        System.out.println("Checking supported filters ...");
        if (EFXUtil.isFilterSupported(0)) {
            System.out.println("AL_FILTER_NULL is supported.");
        } else {
            System.out.println("AL_FILTER_NULL is NOT supported.");
        }
        if (EFXUtil.isFilterSupported(1)) {
            System.out.println("AL_FILTER_LOWPASS is supported.");
        } else {
            System.out.println("AL_FILTER_LOWPASS is NOT supported.");
        }
        if (EFXUtil.isFilterSupported(2)) {
            System.out.println("AL_FILTER_HIGHPASS is supported.");
        } else {
            System.out.println("AL_FILTER_HIGHPASS is NOT supported.");
        }
        if (EFXUtil.isFilterSupported(3)) {
            System.out.println("AL_FILTER_BANDPASS is supported.");
        } else {
            System.out.println("AL_FILTER_BANDPASS is NOT supported.");
        }
    }
}

