/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengl.ARBTransposeMatrix;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class Gears {
    private float view_rotx = 20.0f;
    private float view_roty = 30.0f;
    private float view_rotz;
    private int gear1;
    private int gear2;
    private int gear3;
    private float angle;

    public static void main(String[] args) {
        new Gears().execute();
        System.exit(0);
    }

    private void execute() {
        try {
            this.init();
        }
        catch (LWJGLException le) {
            le.printStackTrace();
            System.out.println("Failed to initialize Gears.");
            return;
        }
        this.loop();
        this.destroy();
    }

    private void destroy() {
        Display.destroy();
    }

    private void loop() {
        long startTime = System.currentTimeMillis() + 5000L;
        long fps = 0L;
        while (!Display.isCloseRequested()) {
            this.angle += 2.0f;
            GL11.glClear(16640);
            GL11.glPushMatrix();
            GL11.glRotatef(this.view_rotx, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(this.view_roty, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(this.view_rotz, 0.0f, 0.0f, 1.0f);
            GL11.glPushMatrix();
            GL11.glTranslatef(-3.0f, -2.0f, 0.0f);
            GL11.glRotatef(this.angle, 0.0f, 0.0f, 1.0f);
            GL11.glCallList(this.gear1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef(3.1f, -2.0f, 0.0f);
            GL11.glRotatef(-2.0f * this.angle - 9.0f, 0.0f, 0.0f, 1.0f);
            GL11.glCallList(this.gear2);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef(-3.1f, 4.2f, 0.0f);
            GL11.glRotatef(-2.0f * this.angle - 25.0f, 0.0f, 0.0f, 1.0f);
            GL11.glCallList(this.gear3);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            Display.update();
            if (startTime > System.currentTimeMillis()) {
                ++fps;
                continue;
            }
            long timeUsed = 5000L + (startTime - System.currentTimeMillis());
            startTime = System.currentTimeMillis() + 5000L;
            System.out.println(fps + " frames in " + (float)timeUsed / 1000.0f + " seconds = " + (float)fps / ((float)timeUsed / 1000.0f));
            fps = 0L;
        }
    }

    private void init() throws LWJGLException {
        Display.setLocation((Display.getDisplayMode().getWidth() - 300) / 2, (Display.getDisplayMode().getHeight() - 300) / 2);
        Display.setDisplayMode(new DisplayMode(300, 300));
        Display.setTitle("Gears");
        Display.create();
        FloatBuffer pos = BufferUtils.createFloatBuffer(4).put(new float[]{5.0f, 5.0f, 10.0f, 0.0f});
        FloatBuffer red = BufferUtils.createFloatBuffer(4).put(new float[]{0.8f, 0.1f, 0.0f, 1.0f});
        FloatBuffer green = BufferUtils.createFloatBuffer(4).put(new float[]{0.0f, 0.8f, 0.2f, 1.0f});
        FloatBuffer blue = BufferUtils.createFloatBuffer(4).put(new float[]{0.2f, 0.2f, 1.0f, 1.0f});
        pos.flip();
        red.flip();
        green.flip();
        blue.flip();
        GL11.glLight(16384, 4611, pos);
        GL11.glEnable(2884);
        GL11.glEnable(2896);
        GL11.glEnable(16384);
        GL11.glEnable(2929);
        this.gear1 = GL11.glGenLists(1);
        GL11.glNewList(this.gear1, 4864);
        GL11.glMaterial(1028, 5634, red);
        this.gear(1.0f, 4.0f, 1.0f, 20, 0.7f);
        GL11.glEndList();
        this.gear2 = GL11.glGenLists(1);
        GL11.glNewList(this.gear2, 4864);
        GL11.glMaterial(1028, 5634, green);
        this.gear(0.5f, 2.0f, 2.0f, 10, 0.7f);
        GL11.glEndList();
        this.gear3 = GL11.glGenLists(1);
        GL11.glNewList(this.gear3, 4864);
        GL11.glMaterial(1028, 5634, blue);
        this.gear(1.3f, 2.0f, 0.5f, 10, 0.7f);
        GL11.glEndList();
        GL11.glEnable(2977);
        GL11.glMatrixMode(5889);
        System.err.println("LWJGL: " + Sys.getVersion() + " / " + LWJGLUtil.getPlatformName());
        System.err.println("GL_VENDOR: " + GL11.glGetString(7936));
        System.err.println("GL_RENDERER: " + GL11.glGetString(7937));
        System.err.println("GL_VERSION: " + GL11.glGetString(7938));
        System.err.println();
        System.err.println("glLoadTransposeMatrixfARB() supported: " + GLContext.getCapabilities().GL_ARB_transpose_matrix);
        if (!GLContext.getCapabilities().GL_ARB_transpose_matrix) {
            GL11.glLoadIdentity();
        } else {
            FloatBuffer identityTranspose = BufferUtils.createFloatBuffer(16).put(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
            identityTranspose.flip();
            ARBTransposeMatrix.glLoadTransposeMatrixARB(identityTranspose);
        }
        float h = 1.0f;
        GL11.glFrustum(-1.0, 1.0, -h, h, 5.0, 60.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -40.0f);
    }

    private void gear(float inner_radius, float outer_radius, float width, int teeth, float tooth_depth) {
        float angle;
        int i;
        float r0 = inner_radius;
        float r1 = outer_radius - tooth_depth / 2.0f;
        float r2 = outer_radius + tooth_depth / 2.0f;
        float da = (float)Math.PI * 2 / (float)teeth / 4.0f;
        GL11.glShadeModel(7424);
        GL11.glNormal3f(0.0f, 0.0f, 1.0f);
        GL11.glBegin(8);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), width * 0.5f);
            if (i >= teeth) continue;
            GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), width * 0.5f);
        }
        GL11.glEnd();
        GL11.glBegin(7);
        for (i = 0; i < teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), width * 0.5f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + da), r2 * (float)Math.sin(angle + da), width * 0.5f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + 2.0f * da), r2 * (float)Math.sin(angle + 2.0f * da), width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), width * 0.5f);
        }
        GL11.glEnd();
        GL11.glBegin(8);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), -width * 0.5f);
            GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), -width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), -width * 0.5f);
            GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), -width * 0.5f);
        }
        GL11.glEnd();
        GL11.glBegin(7);
        for (i = 0; i < teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), -width * 0.5f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + 2.0f * da), r2 * (float)Math.sin(angle + 2.0f * da), -width * 0.5f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + da), r2 * (float)Math.sin(angle + da), -width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), -width * 0.5f);
        }
        GL11.glEnd();
        GL11.glBegin(8);
        for (i = 0; i < teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), -width * 0.5f);
            float u = r2 * (float)Math.cos(angle + da) - r1 * (float)Math.cos(angle);
            float v = r2 * (float)Math.sin(angle + da) - r1 * (float)Math.sin(angle);
            float len = (float)Math.sqrt(u * u + v * v);
            GL11.glNormal3f(v /= len, -(u /= len), 0.0f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + da), r2 * (float)Math.sin(angle + da), width * 0.5f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + da), r2 * (float)Math.sin(angle + da), -width * 0.5f);
            GL11.glNormal3f((float)Math.cos(angle), (float)Math.sin(angle), 0.0f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + 2.0f * da), r2 * (float)Math.sin(angle + 2.0f * da), width * 0.5f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + 2.0f * da), r2 * (float)Math.sin(angle + 2.0f * da), -width * 0.5f);
            u = r1 * (float)Math.cos(angle + 3.0f * da) - r2 * (float)Math.cos(angle + 2.0f * da);
            v = r1 * (float)Math.sin(angle + 3.0f * da) - r2 * (float)Math.sin(angle + 2.0f * da);
            GL11.glNormal3f(v, -u, 0.0f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), -width * 0.5f);
            GL11.glNormal3f((float)Math.cos(angle), (float)Math.sin(angle), 0.0f);
        }
        GL11.glVertex3f(r1 * (float)Math.cos(0.0), r1 * (float)Math.sin(0.0), width * 0.5f);
        GL11.glVertex3f(r1 * (float)Math.cos(0.0), r1 * (float)Math.sin(0.0), -width * 0.5f);
        GL11.glEnd();
        GL11.glShadeModel(7425);
        GL11.glBegin(8);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glNormal3f(-((float)Math.cos(angle)), -((float)Math.sin(angle)), 0.0f);
            GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), -width * 0.5f);
            GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), width * 0.5f);
        }
        GL11.glEnd();
    }
}

