/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.awt;

import java.awt.Canvas;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class DisplayParentTest
extends Frame {
    boolean killswitch;

    public DisplayParentTest() throws LWJGLException {
        this.setTitle("LWJGL Display Parent Test");
        this.setSize(640, 320);
        this.setLayout(new GridLayout(1, 2));
        Canvas display_parent = new Canvas();
        display_parent.setFocusable(true);
        display_parent.setIgnoreRepaint(true);
        this.add(display_parent);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DisplayParentTest.this.killswitch = true;
            }
        });
        this.setResizable(true);
        this.setVisible(true);
        Display.setParent(display_parent);
        Display.setVSyncEnabled(true);
        Display.create();
        float angle = 0.0f;
        block0: while (this.isVisible() && !this.killswitch) {
            int height;
            int width;
            angle += 1.0f;
            if (!Display.isFullscreen()) {
                width = display_parent.getWidth();
                height = display_parent.getHeight();
            } else {
                width = Display.getDisplayMode().getWidth();
                height = Display.getDisplayMode().getHeight();
            }
            if (width < 1 || height < 1) continue;
            GL11.glViewport(0, 0, width, height);
            GL11.glClearColor(0.0f, 1.0f, 0.0f, 1.0f);
            GL11.glClear(16384);
            GL11.glMatrixMode(5889);
            GL11.glLoadIdentity();
            GLU.gluOrtho2D(0.0f, width, 0.0f, height);
            GL11.glMatrixMode(5888);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)width / 2.0f, (float)height / 2.0f, 0.0f);
            GL11.glRotatef(2.0f * angle, 0.0f, 0.0f, -1.0f);
            GL11.glRectf(-50.0f, -50.0f, 50.0f, 50.0f);
            GL11.glPopMatrix();
            Display.update();
            while (Keyboard.next()) {
                if (Keyboard.getEventKey() == 1 && Keyboard.getEventKeyState()) {
                    Display.destroy();
                    this.dispose();
                    continue block0;
                }
                if (Keyboard.getEventKey() == 57 && Keyboard.getEventKeyState()) {
                    Mouse.setGrabbed(!Mouse.isGrabbed());
                }
                if (Keyboard.getEventKey() != 33 || !Keyboard.getEventKeyState()) continue;
                Display.setFullscreen(!Display.isFullscreen());
            }
        }
        Display.destroy();
        this.dispose();
    }

    public static void main(String[] args) throws LWJGLException {
        new DisplayParentTest();
    }
}

