/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.shaders;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBUniformBufferObject;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.Util;
import org.lwjgl.test.opengl.shaders.Shader;
import org.lwjgl.test.opengl.shaders.ShadersTest;

final class ShaderUNI
extends Shader {
    final String file;
    final String source;
    final int shaderID;
    final int programID;
    final int bufferID;
    final FloatBuffer buffer;
    final int uniformA_index;
    final int uniformA_offset;
    final int uniformB_index;
    final int uniformB_offset;

    ShaderUNI(String shaderFile) {
        this.file = shaderFile;
        this.source = ShaderUNI.getShaderText(shaderFile);
        this.shaderID = GL20.glCreateShader(35633);
        GL20.glShaderSource(this.shaderID, this.source);
        GL20.glCompileShader(this.shaderID);
        ShaderUNI.printShaderObjectInfoLog(this.file, this.shaderID);
        if (GL20.glGetShaderi(this.shaderID, 35713) == 0) {
            ShadersTest.kill("A compilation error occured in a vertex shader.");
        }
        this.programID = GL20.glCreateProgram();
        GL20.glAttachShader(this.programID, this.shaderID);
        GL20.glLinkProgram(this.programID);
        ShaderUNI.printShaderProgramInfoLog(this.programID);
        if (GL20.glGetProgrami(this.programID, 35714) == 0) {
            ShadersTest.kill("A linking error occured in a shader program.");
        }
        CharSequence[] uniformNames = new String[]{"uniformA", "uniformB"};
        int blockIndex = ARBUniformBufferObject.glGetUniformBlockIndex(this.programID, "test");
        int blockSize = ARBUniformBufferObject.glGetActiveUniformBlocki(this.programID, blockIndex, 35392);
        System.out.println("blockSize = " + blockSize);
        this.bufferID = GL15.glGenBuffers();
        GL15.glBindBuffer(35345, this.bufferID);
        GL15.glBufferData(35345, blockSize, 35048);
        this.buffer = BufferUtils.createFloatBuffer(blockSize);
        ARBUniformBufferObject.glBindBufferBase(35345, 0, this.bufferID);
        ARBUniformBufferObject.glUniformBlockBinding(this.programID, blockIndex, 0);
        IntBuffer indexes = BufferUtils.createIntBuffer(uniformNames.length);
        IntBuffer params = BufferUtils.createIntBuffer(uniformNames.length);
        ARBUniformBufferObject.glGetUniformIndices(this.programID, uniformNames, indexes);
        this.uniformA_index = indexes.get(0);
        this.uniformB_index = indexes.get(1);
        ARBUniformBufferObject.glGetActiveUniforms(this.programID, indexes, 35387, params);
        this.uniformA_offset = params.get(0);
        this.uniformB_offset = params.get(1);
        System.out.println("\nuniformA index = " + this.uniformA_index);
        System.out.println("uniformB index = " + this.uniformB_index);
        System.out.println("\nuniformA offset = " + this.uniformA_offset + " - should be 0 for std140");
        System.out.println("uniformB offset = " + this.uniformB_offset + " - should be 16 for std140");
        Util.checkGLError();
    }

    void render() {
        GL20.glUseProgram(this.programID);
        this.buffer.put(0, ShadersTest.getSin()).put(1, (float)ShadersTest.getSpecularity() * 8.0f);
        this.buffer.put(4, 0.0f).put(5, 0.7f).put(6, 0.0f);
        GL15.glBindBuffer(35345, this.bufferID);
        GL15.glBufferData(35345, this.buffer, 35048);
        ShadersTest.renderObject();
        GL20.glUseProgram(0);
    }

    void cleanup() {
        GL15.glDeleteBuffers(this.bufferID);
        GL20.glDetachShader(this.programID, this.shaderID);
        GL20.glDeleteShader(this.shaderID);
        GL20.glDeleteProgram(this.programID);
    }
}

