/*
 * Decompiled with CFR 0.152.
 */
package animationEditor;

import game.figureRender.Box;
import game.main.Camera;
import game.main.Render;
import game.model.GabenModel;
import game.model.Model;
import game.util.Input;
import game.util.Vec3;
import java.util.ArrayList;
import org.lwjgl.opengl.Display;

public class AnimationMain {
    private Camera camera = new Camera();
    private Render RENDER = new Render("Animation Test", this.camera, 800, 600, false);
    private Input input = new Input();
    private ArrayList<Model> animations = new ArrayList();
    public static boolean DRAW_MODEL = true;
    public static boolean PAUSE_ANIMATION = false;
    int c;

    public static void main(String[] args) {
        new AnimationMain();
    }

    public AnimationMain() {
        this.animations.add(new GabenModel());
        this.RENDER.init();
        while (!Display.isCloseRequested()) {
            this.update();
            this.input.poll();
            this.RENDER.beginRender();
            Box.renderBox(new Vec3(0.0f, 15.0f, 0.0f), new Vec3(40.0f, 40.0f, 40.0f), new Vec3(0.0f, 0.6f, 0.75f));
            for (Model a : this.animations) {
                a.render(null, null, false);
            }
            int i = 0;
            while (i < 50) {
                int j = 0;
                while (j < 50) {
                    ++j;
                }
                ++i;
            }
            this.RENDER.endRender();
            if (this.input.isKeyDown(1)) break;
        }
    }

    public void update() {
        this.input();
        for (Model a : this.animations) {
            a.update();
        }
    }

    public void input() {
        double speed = 0.1;
        if (this.input.isKeyDown(208)) {
            this.camera.pos.x = (float)((double)this.camera.pos.x + speed * Math.sin(Math.toRadians(this.camera.rot.y)));
            this.camera.pos.z = (float)((double)this.camera.pos.z + speed * Math.sin(Math.toRadians(this.camera.rot.y + 90.0f)));
        }
        if (this.input.isKeyDown(200)) {
            this.camera.pos.x = (float)((double)this.camera.pos.x - speed * Math.sin(Math.toRadians(this.camera.rot.y)));
            this.camera.pos.z = (float)((double)this.camera.pos.z - speed * Math.sin(Math.toRadians(this.camera.rot.y + 90.0f)));
        }
        if (this.input.isKeyDown(205)) {
            this.camera.pos.z = (float)((double)this.camera.pos.z - speed * Math.sin(Math.toRadians(this.camera.rot.y)));
            this.camera.pos.x = (float)((double)this.camera.pos.x + speed * Math.sin(Math.toRadians(this.camera.rot.y + 90.0f)));
        }
        if (this.input.isKeyDown(203)) {
            this.camera.pos.z = (float)((double)this.camera.pos.z + speed * Math.sin(Math.toRadians(this.camera.rot.y)));
            this.camera.pos.x = (float)((double)this.camera.pos.x - speed * Math.sin(Math.toRadians(this.camera.rot.y + 90.0f)));
        }
        if (this.input.isKeyDown(17)) {
            this.camera.rot.x += 1.0f;
        }
        if (this.input.isKeyDown(31)) {
            this.camera.rot.x -= 1.0f;
        }
        if (this.input.isKeyDown(30)) {
            this.camera.rot.y += 1.0f;
        }
        if (this.input.isKeyDown(32)) {
            this.camera.rot.y -= 1.0f;
        }
        if (this.input.isKeyDown(57)) {
            this.camera.pos.y = (float)((double)this.camera.pos.y + speed);
        }
        if (this.input.isKeyDown(42)) {
            this.camera.pos.y = (float)((double)this.camera.pos.y - speed);
        }
        if (this.input.isKeyPressed(50)) {
            boolean bl = DRAW_MODEL = !DRAW_MODEL;
        }
        if (this.input.isKeyPressed(25)) {
            PAUSE_ANIMATION = !PAUSE_ANIMATION;
        }
    }

    public Vec3 getGroundPosition() {
        float xcy = this.camera.getDirectionVectorX().y;
        float ycy = this.camera.getDirectionVectorY().y;
        float zcy = this.camera.getDirectionVectorZ().y;
        float fx = this.input.getNormalX();
        float fy = this.input.getNormalY();
        float t = -this.camera.pos.y / (-zcy + fx * xcy * 0.552f + fy * ycy * 0.4188f);
        Vec3 zc = this.camera.getDirectionVectorZ().multiply(-1.0f);
        Vec3 xc = this.camera.getDirectionVectorX().multiply(fx * 0.552f);
        Vec3 yc = this.camera.getDirectionVectorY().multiply(fy * 0.414f);
        Vec3 q = zc.add(xc).add(yc).multiply(t);
        Vec3 result = this.camera.pos.add(q);
        return result;
    }
}

