/*
 * Decompiled with CFR 0.152.
 */
package game.attacks;

import game.attacks.Attack;
import game.figureRender.Quad;
import game.main.Main;
import game.main.Player;
import game.sound.Sound;
import game.util.Rect;
import game.util.Vec3;

public class DrillAttack
extends Attack {
    private float size = 1.0f;
    private boolean soundPlayed = false;
    private int tick = 0;
    private static Vec3[] COLORS = new Vec3[]{Vec3.RED, Vec3.GREEN, Vec3.BLUE};

    public DrillAttack(Player player) {
        super(player);
        this.setHitRect();
        this.damage = 1.0;
        Main.SOUND.play(Sound.DRILL);
    }

    private void setHitRect() {
        this.hitRect = new Rect(this.player.getPos().x + this.player.getCollisionRect().w / 2.0f - this.size / 2.0f, this.player.getPos().y, this.size, this.size);
    }

    @Override
    public void render() {
        int i = 0;
        double aBase = 0.0;
        double da = 0.13962634015954636;
        while (aBase <= Math.PI * 2) {
            double a = aBase + (double)((float)this.tick * 0.1f);
            Vec3 col = COLORS[i % COLORS.length];
            Vec3 bot = new Vec3(this.hitRect.x + this.size / 2.0f, this.hitRect.y - 0.5f, 0.0f);
            Vec3 top1 = new Vec3((float)(Math.cos(a) * (double)this.size), this.hitRect.y + this.size, (float)(Math.sin(a) * (double)this.size)).add(new Vec3(this.hitRect.x + this.size / 2.0f, 0.0f, 0.0f));
            Vec3 top2 = new Vec3((float)(Math.cos(a + da) * (double)this.size), this.hitRect.y + this.size, (float)(Math.sin(a + da) * (double)this.size)).add(new Vec3(this.hitRect.x + this.size / 2.0f, 0.0f, 0.0f));
            Vec3 center = new Vec3(this.hitRect.x + this.size / 2.0f, this.hitRect.y + this.size, 0.0f);
            Quad.renderQuad(bot, bot, top1, top2, col);
            Quad.renderQuad(center, center, top1, top2, col);
            aBase += da;
            ++i;
        }
    }

    @Override
    public void update(Player[] players) {
        ++this.tick;
        this.setHitRect();
        Player[] playerArray = players;
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (p.isEnemyTo(this.player) && p.getCollisionRect().intersects(this.hitRect)) {
                p.takeDamage(this.damage, this.player);
                break;
            }
            ++n2;
        }
    }
}

