/*
 * Decompiled with CFR 0.152.
 */
package game.attacks;

import game.attacks.Attack;
import game.figureRender.Quad;
import game.main.Main;
import game.main.Player;
import game.sound.Sound;
import game.util.Rect;
import game.util.Vec3;

public class HeadAttack
extends Attack {
    private int tick = 0;
    private float size = 1.0f;

    public HeadAttack(Player player) {
        super(player);
        this.setHitRect();
        this.damage = 1.0;
        Main.SOUND.play(Sound.EL);
    }

    private void setHitRect() {
        this.hitRect = new Rect(this.player.getPos().x + this.player.getCollisionRect().w / 2.0f - this.size / 2.0f, this.player.getPos().y + this.getHeight() + this.player.getCollisionRect().h, this.size, this.size);
    }

    public float getHeight() {
        return (float)this.tick * 0.1f;
    }

    @Override
    public void render() {
        float parts = 10.0f;
        int i = 0;
        while ((float)i < parts) {
            float ylow = this.player.getPos().y + this.getHeight() * (float)i / parts + this.player.getCollisionRect().h;
            float yhigh = this.player.getPos().y + this.getHeight() * (float)(i + 1) / parts + this.player.getCollisionRect().h;
            float colorR = (float)Math.random();
            float drawSize = this.size * 0.4f;
            Quad.renderQuad(new Vec3((float)((double)this.hitRect.x + (double)this.size * 0.3 + Math.random() * (double)drawSize), yhigh, this.size * 0.3f + (float)(Math.random() * (double)drawSize)), new Vec3((float)((double)this.hitRect.x + (double)this.size * 0.3 + Math.random() * (double)drawSize), yhigh, this.size * 0.3f + (float)(Math.random() * (double)drawSize)), new Vec3((float)((double)this.hitRect.x + (double)this.size * 0.3 + Math.random() * (double)drawSize), ylow, this.size * 0.3f + (float)(Math.random() * (double)drawSize)), new Vec3((float)((double)this.hitRect.x + (double)this.size * 0.3 + Math.random() * (double)drawSize), ylow, this.size * 0.3f + (float)(Math.random() * (double)drawSize)), new Vec3(colorR * 0.5f + 0.5f, colorR * 0.5f + 0.5f, 0.0f));
            ++i;
        }
    }

    @Override
    public void update(Player[] players) {
        ++this.tick;
        this.setHitRect();
        Player[] playerArray = players;
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (p.isEnemyTo(this.player) && p.getCollisionRect().intersects(this.hitRect)) {
                p.takeDamage(this.damage, this.player);
                break;
            }
            ++n2;
        }
    }
}

