/*
 * Decompiled with CFR 0.152.
 */
package game.attacks;

import game.attacks.Attack;
import game.main.Main;
import game.main.Player;
import game.sound.Sound;
import game.util.Rect;
import game.util.Vec2;

public class MeleeAttack
extends Attack {
    double headingDeg;
    float r = 0.5f;
    float size = 1.0f;
    private boolean soundPlayed = false;

    public MeleeAttack(Player player, double headingDeg) {
        super(player);
        this.headingDeg = headingDeg;
        this.setHitRect();
        this.damage = 10.0;
        Main.SOUND.play(Sound.PUNCH_MISS);
    }

    private void setHitRect() {
        Vec2 center = this.player.getCenter();
        Vec2 hitRectPos = new Vec2((float)Math.cos(Math.toRadians(this.headingDeg)) * this.r, (float)Math.sin(Math.toRadians(this.headingDeg)) * this.r);
        hitRectPos = center.add(hitRectPos);
        this.hitRect = new Rect(hitRectPos.x - this.size / 2.0f, hitRectPos.y, this.size, this.size);
    }

    @Override
    public void update(Player[] players) {
        this.setHitRect();
        Player[] playerArray = players;
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (p.isEnemyTo(this.player) && p.getCollisionRect().intersects(this.hitRect)) {
                this.shallBeRemoved = true;
                p.takeDamage(this.damage, this.player);
                if (this.soundPlayed) break;
                this.soundPlayed = true;
                Main.SOUND.play(Sound.PUNCH);
                break;
            }
            ++n2;
        }
    }
}

