/*
 * Decompiled with CFR 0.152.
 */
package game.effects;

import game.effects.Effect;
import game.figureRender.Quad;
import game.main.Main;
import game.util.Vec2;
import game.util.Vec3;
import java.util.ArrayList;

public class FusRoDah
extends Effect {
    private float size = 1.0f;
    private int timer = Main.MILLIS_TO_TICKS(400);
    private double headingDeg;
    private ArrayList<Particle> particles = new ArrayList();

    public FusRoDah(Vec2 pos, double headingDeg, double spreadDeg) {
        this.pos = pos;
        int num = 10;
        float speed = 0.3f;
        int i = 0;
        while (i < num) {
            double hDeg = headingDeg - spreadDeg + 2.0 * spreadDeg * ((double)i / (double)num);
            double hr = Math.toRadians(hDeg);
            this.particles.add(new Particle(pos.clone(), new Vec2((float)Math.cos(hr) * speed, (float)Math.sin(hr) * speed)));
            ++i;
        }
    }

    @Override
    public void simulate() {
        --this.timer;
        for (Particle p : this.particles) {
            p.update();
        }
    }

    @Override
    public boolean shallBeRemoved() {
        return this.timer < 0;
    }

    @Override
    public void render() {
        for (Particle p : this.particles) {
            Vec3 center = new Vec3(p.pos.x, p.pos.y, 0.0f);
            int i = 0;
            while (i < 20) {
                double a1 = Math.random() * Math.PI * 2.0;
                double a2 = Math.random() * Math.PI * 2.0;
                double r = Math.random() * (double)this.size / 2.0;
                Vec3 col = new Vec3((float)Math.random());
                Vec3 out = new Vec3((float)(Math.sin(a1) * Math.sin(a2)), (float)(Math.cos(a1) * Math.sin(a2)), (float)Math.cos(a2));
                out = out.multiply(this.size);
                out = center.add(out);
                Quad.renderQuad(center, center.add(new Vec3((float)(Math.random() * r), (float)(Math.random() * r * 0.1), (float)(Math.random() * r * 0.1))), out, out, col);
                ++i;
            }
        }
    }

    private class Particle {
        Vec2 pos;
        Vec2 speed;

        public Particle(Vec2 p, Vec2 s) {
            this.pos = p;
            this.speed = s;
        }

        public void update() {
            this.pos.x += this.speed.x;
            this.pos.y += this.speed.y;
        }
    }
}

