/*
 * Decompiled with CFR 0.152.
 */
package game.effects;

import game.effects.Effect;
import game.figureRender.Box;
import game.main.Main;
import game.sound.Sound;
import game.util.Vec3;
import java.util.ArrayList;

public class RespawnEffect
extends Effect {
    private ArrayList<Vec3> cubePos = new ArrayList();
    private ArrayList<Float> cubeSize = new ArrayList();
    private int timer = Main.MILLIS_TO_TICKS(1500);
    private Vec3[] colors = new Vec3[]{Vec3.RED, Vec3.BLUE, Vec3.YELLOW, Vec3.GREEN, Vec3.CYAN};

    public RespawnEffect(Vec3 pos) {
        Main.SOUND.play(Sound.RESPAWN);
        int i = 0;
        while (i < 40) {
            this.cubePos.add(pos.add((float)(2.0 * (Math.random() - 0.5)), (float)(2.0 * (Math.random() - 0.5)), (float)(2.0 * (Math.random() - 0.5))));
            this.cubeSize.add(Float.valueOf((float)(Math.random() * 0.25 + 0.25)));
            ++i;
        }
    }

    @Override
    public void simulate() {
        --this.timer;
        int i = 0;
        while (i < this.cubePos.size()) {
            this.cubePos.get((int)i).y = (float)((double)this.cubePos.get((int)i).y + 0.02);
            this.cubeSize.set(i, Float.valueOf(this.cubeSize.get(i).floatValue() * 0.97f));
            ++i;
        }
    }

    @Override
    public boolean shallBeRemoved() {
        return this.timer < 0;
    }

    @Override
    public void render() {
        int i = 0;
        while (i < this.cubePos.size()) {
            Box.renderBox(this.cubePos.get(i), new Vec3(this.cubeSize.get(i).floatValue()), this.colors[i % this.colors.length]);
            ++i;
        }
    }
}

