/*
 * Decompiled with CFR 0.152.
 */
package game.figureRender;

import game.util.Vec3;
import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;

public class Box {
    public static Texture texture;
    Vec3 dim;
    public int[] textureIDs;
    public static int gabenFace;
    public static int sky;
    public static int billys;
    public static int jolt;
    public static int smoke;
    public static int joltLava;
    public static int debug;
    public static int helm;
    public static int horns;
    public static int crt;
    public static int troll;
    public static int platformMetal;
    public static int joltItem;
    public static int pacBoot;
    public static int speakerMid;
    public static int speakerMain;
    public static int arcadeMain;
    public static int arcadeTop;
    public static int arcadeBot;
    public static int arcadeGame;
    public static int arcadeGame2;
    public static int datortrashScreen;
    public static int joltScreen;
    public static int skyFract;
    public static int demoSky;
    public static int birdieEye;
    public static int grass;
    public static int skyClouds;
    public static int shield;
    public static int tunnel;
    public static int prisPall;
    public static int steveHeadFront;
    public static int steveHeadSide1;
    public static int steveHeadSide2;
    public static int steveHeadHair;
    public static int steveHeadUnder;
    public static int kontroller;
    public static int white;
    static int[] nullList;

    static {
        gabenFace = Box.initTexture("gabenFace_NR.png");
        sky = Box.initTexture("space2.png");
        billys = Box.initTexture("billys2.png");
        jolt = Box.initTexture("jolt.png");
        smoke = Box.initTexture("smoke.png");
        joltLava = Box.initTexture("joltLava.png");
        debug = Box.initTexture("debug.png");
        helm = Box.initTexture("helm.png");
        horns = Box.initTexture("horns.png");
        crt = Box.initTexture("crt.png");
        troll = Box.initTexture("troll.png");
        platformMetal = Box.initTexture("platform_metal.png");
        joltItem = Box.initTexture("joltItem.png");
        pacBoot = Box.initTexture("pac_boot.png");
        speakerMid = Box.initTexture("speaker_mid.png");
        speakerMain = Box.initTexture("speaker_main.png");
        arcadeMain = Box.initTexture("arcade_main.png");
        arcadeTop = Box.initTexture("arcade_top.png");
        arcadeBot = Box.initTexture("arcade_bot.png");
        arcadeGame = Box.initTexture("arcade_game.png");
        arcadeGame2 = Box.initTexture("arcade_game2.png");
        datortrashScreen = Box.initTexture("datortrash_screen.png");
        joltScreen = Box.initTexture("jolt_screen.png");
        skyFract = Box.initTexture("sky_fract.png");
        demoSky = Box.initTexture("demo_sky.png");
        birdieEye = Box.initTexture("birdie_eye.png");
        grass = Box.initTexture("grass.png");
        skyClouds = Box.initTexture("sky.png");
        shield = Box.initTexture("shield.png");
        tunnel = Box.initTexture("tunnel.png");
        prisPall = Box.initTexture("prispall.png");
        steveHeadFront = Box.initTexture("steve_head_front.png");
        steveHeadSide1 = Box.initTexture("steave_head_side1.png");
        steveHeadSide2 = Box.initTexture("steave_head_side2.png");
        steveHeadHair = Box.initTexture("steave_head_hair.png");
        steveHeadUnder = Box.initTexture("steave_head_under.png");
        kontroller = Box.initTexture("kontroller.png");
        white = Box.initTexture("white.png");
        nullList = new int[]{-1, -1, -1, -1, -1, -1};
    }

    public Box(int[] ti, Vec3 dim) {
        this.dim = dim;
        this.textureIDs = ti;
    }

    public static int initTexture(String name) {
        try {
            texture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("game/textures/" + name));
            System.out.println("Texture loaded: " + texture);
            System.out.println(">> Image width: " + texture.getImageWidth());
            System.out.println(">> Image height: " + texture.getImageHeight());
            System.out.println(">> Texture width: " + texture.getTextureWidth());
            System.out.println(">> Texture height: " + texture.getTextureHeight());
            System.out.println(">> Texture ID: " + texture.getTextureID());
        }
        catch (IOException e) {
            System.out.println("Texture " + name);
            e.printStackTrace();
        }
        return texture.getTextureID();
    }

    public void render(Vec3 pos) {
        Box.renderBox(pos, this.dim, new Vec3(0.0f, 1.0f, 0.0f), null);
    }

    public static void renderBoxCorner(Vec3 cornerPos, Vec3 dim, Vec3 color) {
        Box.renderBox(new Vec3(cornerPos.x + dim.x / 2.0f, cornerPos.y + dim.y / 2.0f, cornerPos.z + dim.z / 2.0f), dim, color);
    }

    public static void renderBoxCorner(Vec3 cornerPos, Vec3 dim, Vec3 color, int[] textureIDs) {
        Box.renderBox(new Vec3(cornerPos.x + dim.x / 2.0f, cornerPos.y + dim.y / 2.0f, cornerPos.z + dim.z / 2.0f), dim, color, textureIDs);
    }

    public static void renderBox(Vec3 pos, Vec3 dim, Vec3 color) {
        Box.renderBox(pos, dim, color, nullList);
    }

    public static void renderBox(Vec3 pos, Vec3 dim, int tex) {
        Box.renderBox(pos, dim, Vec3.CYAN, new int[]{tex, tex, tex, tex, tex, tex});
    }

    public static void renderBox(Vec3 pos, Vec3 dim, Vec3 color, int[] textureIDs) {
        GL11.glPushMatrix();
        GL11.glColor3f(1.0f, 0.0f, 0.0f);
        GL11.glTranslatef(pos.x, pos.y, pos.z);
        if (textureIDs[0] != -1) {
            Color.white.bind();
            GL11.glBindTexture(3553, textureIDs[0]);
        } else {
            GL11.glColor3f(color.x, color.y, color.z);
        }
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(dim.x / 2.0f, dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-dim.x / 2.0f, dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-dim.x / 2.0f, dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(dim.x / 2.0f, dim.y / 2.0f, dim.z / 2.0f);
        GL11.glEnd();
        GL11.glBindTexture(3553, 0);
        if (textureIDs[1] != -1) {
            Color.white.bind();
            GL11.glBindTexture(3553, textureIDs[1]);
        } else {
            GL11.glColor3f(color.x * 0.8f, color.y * 0.8f, color.z * 0.8f);
        }
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(dim.x / 2.0f, -dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-dim.x / 2.0f, -dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-dim.x / 2.0f, -dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(dim.x / 2.0f, -dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glEnd();
        GL11.glBindTexture(3553, 0);
        if (textureIDs[2] != -1) {
            Color.white.bind();
            GL11.glBindTexture(3553, textureIDs[2]);
        } else {
            GL11.glColor3f(color.x * 0.9f, color.y * 0.9f, color.z * 0.9f);
        }
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(dim.x / 2.0f, -dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-dim.x / 2.0f, -dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-dim.x / 2.0f, dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(dim.x / 2.0f, dim.y / 2.0f, dim.z / 2.0f);
        GL11.glEnd();
        GL11.glBindTexture(3553, 0);
        if (textureIDs[3] != -1) {
            Color.white.bind();
            GL11.glBindTexture(3553, textureIDs[3]);
        } else {
            GL11.glColor3f(color.x * 0.8f, color.y * 0.8f, color.z * 0.8f);
        }
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(dim.x / 2.0f, -dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-dim.x / 2.0f, -dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-dim.x / 2.0f, dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(dim.x / 2.0f, dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glEnd();
        GL11.glBindTexture(3553, 0);
        if (textureIDs[4] != -1) {
            Color.white.bind();
            GL11.glBindTexture(3553, textureIDs[4]);
        } else {
            GL11.glColor3f(color.x * 0.95f, color.y * 0.95f, color.z * 0.95f);
        }
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(-dim.x / 2.0f, -dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(-dim.x / 2.0f, dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(-dim.x / 2.0f, dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(-dim.x / 2.0f, -dim.y / 2.0f, dim.z / 2.0f);
        GL11.glEnd();
        GL11.glBindTexture(3553, 0);
        if (textureIDs[5] != -1) {
            Color.white.bind();
            GL11.glBindTexture(3553, textureIDs[5]);
        } else {
            GL11.glColor3f(color.x * 0.85f, color.y * 0.85f, color.z * 0.85f);
        }
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(dim.x / 2.0f, -dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(dim.x / 2.0f, dim.y / 2.0f, -dim.z / 2.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(dim.x / 2.0f, dim.y / 2.0f, dim.z / 2.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(dim.x / 2.0f, -dim.y / 2.0f, dim.z / 2.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }
}

