/*
 * Decompiled with CFR 0.152.
 */
package game.items;

import game.figureRender.Box;
import game.figureRender.Quad;
import game.items.Item;
import game.main.Game;
import game.main.Player;
import game.map.GameMap;
import game.map.MapBlock;
import game.obj.OBJExtractor;
import game.util.Vec2;
import game.util.Vec3;
import org.lwjgl.opengl.GL11;

public class ComputerPart
extends Item {
    private Vec3 rot = new Vec3((float)Math.random() * 360.0f, (float)Math.random() * 360.0f, (float)Math.random() * 360.0f);
    private static OBJExtractor.OBJ crt;

    static {
        OBJExtractor obje = new OBJExtractor();
        crt = obje.loadModel("crt.obj");
    }

    public ComputerPart(Vec2 pos, Game game, GameMap map) {
        super(pos, game, map);
        this.thrown = true;
    }

    @Override
    public boolean isThrown() {
        return true;
    }

    @Override
    public boolean isUpPickable() {
        return false;
    }

    @Override
    public boolean canActivateVemKasta() {
        return false;
    }

    @Override
    public void simulate() {
        this.rot.x += 1.0f;
        this.rot.y += 1.0f;
        this.rot.z += 1.0f;
        ++this.ticksIdle;
        if (this.pos.y < -100.0f) {
            this.shallBeRemoved = true;
        }
        if (this.mapBlock != null) {
            this.pos.x += this.mapBlock.getDx();
            this.pos.y += this.mapBlock.getDy();
        }
        Player[] playerArray = this.game.getNonEliminatedPlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (this.getCollisionRect().intersects(p.getCollisionRect())) {
                p.takeDamage(this.throwDamage, this);
                this.shallBeRemoved = true;
            }
            ++n2;
        }
        int moveParts = 100;
        int i = 0;
        while (i < moveParts) {
            float oldX = this.pos.x;
            float oldY = this.pos.y;
            this.pos.x += this.vel.x / (float)moveParts;
            this.pos.y += this.vel.y / (float)moveParts;
            MapBlock collides = this.map.collides(this);
            if (collides != null) {
                if (this.vel.y < 0.0f) {
                    this.mapBlock = collides;
                }
                this.vel.y = 0.0f;
                this.vel.x = 0.0f;
                this.pos.x = oldX;
                this.pos.y = oldY;
                if (this.thrown) {
                    this.shallBeRemoved = true;
                }
            }
            ++i;
        }
        this.vel.y -= this.game.getGravity() * 0.1f;
    }

    @Override
    public void render() {
        GL11.glPushMatrix();
        GL11.glTranslatef(this.pos.x + this.size / 2.0f, this.pos.y + this.size / 2.0f, 0.0f);
        GL11.glRotatef(this.rot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.rot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.rot.z, 0.0f, 0.0f, 1.0f);
        float scale = 30.0f;
        int i = 0;
        while (i < ComputerPart.crt.faces.size()) {
            Vec3 topLeft = ComputerPart.crt.vecs.get(ComputerPart.crt.faces.get(i).get(0) - 1);
            Vec3 topRight = ComputerPart.crt.vecs.get(ComputerPart.crt.faces.get(i).get(1) - 1);
            Vec3 botRight = ComputerPart.crt.vecs.get(ComputerPart.crt.faces.get(i).get(2) - 1);
            topLeft = topLeft.multiply(scale);
            topRight = topRight.multiply(scale);
            botRight = botRight.multiply(scale);
            if (ComputerPart.crt.faces.get(i).size() == 4) {
                Vec3 botLeft;
                if (i == 38) {
                    botLeft = ComputerPart.crt.vecs.get(ComputerPart.crt.faces.get(i).get(3) - 1);
                    botLeft = botLeft.multiply(scale);
                    Quad.renderQuad(topLeft, topRight, botRight, botLeft, Vec3.BLACK);
                } else {
                    botLeft = ComputerPart.crt.vecs.get(ComputerPart.crt.faces.get(i).get(3) - 1);
                    botLeft = botLeft.multiply(scale);
                    Quad.renderQuad(topLeft, topRight, botRight, botLeft, Box.crt);
                }
            } else {
                Quad.renderQuad(topLeft, topRight, botRight, botRight, Box.crt);
            }
            ++i;
        }
        GL11.glPopMatrix();
    }
}

