/*
 * Decompiled with CFR 0.152.
 */
package game.items;

import game.effects.FusRoDah;
import game.figureRender.Box;
import game.figureRender.Quad;
import game.items.Item;
import game.main.Game;
import game.main.Main;
import game.main.Player;
import game.map.GameMap;
import game.model.Model;
import game.obj.OBJExtractor;
import game.sound.Sound;
import game.util.Vec2;
import game.util.Vec3;
import org.lwjgl.opengl.GL11;

public class Helm
extends Item {
    private static OBJExtractor.OBJ helm;
    private static OBJExtractor.OBJ horns;
    private double spreadDeg = 45.0;

    static {
        OBJExtractor obje = new OBJExtractor();
        helm = obje.loadModel("helm_helm.obj");
        horns = obje.loadModel("helm_horns.obj");
    }

    public Helm(Vec2 pos, Game game, GameMap map) {
        super(pos, game, map);
        this.canBeThrown = false;
        this.size = 0.5f;
    }

    @Override
    public void render() {
        Vec3 botLeft;
        Vec3 botRight;
        Vec3 topRight;
        Vec3 topLeft;
        if (this.isBlinking()) {
            return;
        }
        if (this.owner == null) {
            this.renderWhiteArrow();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(this.pos.x + this.size / 2.0f, this.pos.y + this.size, 0.0f);
        if (this.player != null) {
            GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        }
        float scale = 30.0f;
        int i = 0;
        while (i < Helm.helm.faces.size()) {
            topLeft = Helm.helm.vecs.get(Helm.helm.faces.get(i).get(0) - 1);
            topRight = Helm.helm.vecs.get(Helm.helm.faces.get(i).get(1) - 1);
            botRight = Helm.helm.vecs.get(Helm.helm.faces.get(i).get(2) - 1);
            topLeft = topLeft.multiply(scale);
            topRight = topRight.multiply(scale);
            botRight = botRight.multiply(scale);
            if (Helm.helm.faces.get(i).size() == 4) {
                botLeft = Helm.helm.vecs.get(Helm.helm.faces.get(i).get(3) - 1);
                botLeft = botLeft.multiply(scale);
                Quad.renderQuad(topLeft, topRight, botRight, botLeft, Box.sky);
            } else {
                Quad.renderQuad(topLeft, topRight, botRight, botRight, Box.helm);
            }
            ++i;
        }
        i = 0;
        while (i < Helm.horns.faces.size()) {
            topLeft = Helm.horns.vecs.get(Helm.horns.faces.get(i).get(0) - 1);
            topRight = Helm.horns.vecs.get(Helm.horns.faces.get(i).get(1) - 1);
            botRight = Helm.horns.vecs.get(Helm.horns.faces.get(i).get(2) - 1);
            topLeft = topLeft.multiply(scale);
            topRight = topRight.multiply(scale);
            botRight = botRight.multiply(scale);
            if (Helm.horns.faces.get(i).size() == 4) {
                botLeft = Helm.horns.vecs.get(Helm.horns.faces.get(i).get(3) - 1);
                botLeft = botLeft.multiply(scale);
                Quad.renderQuad(topLeft, topRight, botRight, botLeft, Box.sky);
            } else {
                Quad.renderQuad(topLeft, topRight, botRight, botRight, Box.horns);
            }
            ++i;
        }
        GL11.glPopMatrix();
    }

    @Override
    public void renderOnModel() {
        Vec2 realpos = this.pos.clone();
        this.pos = new Vec2(0.0f);
        GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        GL11.glTranslatef(-this.size / 2.0f, -this.size / 2.0f, 0.0f);
        this.render();
        this.pos = realpos;
    }

    @Override
    public Model.Limb getLimb() {
        return Model.Limb.HEAD;
    }

    @Override
    public void playerUse() {
        Main.SOUND.play(Sound.FUS_RO_DAH);
        double hd = this.player.getHeadingDeg();
        Player[] playerArray = this.game.getNonEliminatedPlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (p.isEnemyTo(this.player)) {
                double dx = p.getPos().x - this.player.getPos().x;
                double dy = p.getPos().y - this.player.getPos().y;
                double a = Math.toDegrees(Math.atan2(dy, dx));
                double da = (hd - a + 180.0) % 360.0 - 180.0;
                double d = Math.min(30.0 * Math.abs(1.0 / Math.sqrt(dx * dx + dy * dy)), 20.0);
                if (d >= 1.0 && Math.abs(da) <= this.spreadDeg) {
                    p.takeDamage(d, this.player);
                }
            }
            ++n2;
        }
        this.game.addEffect(new FusRoDah(this.pos.clone(), hd, this.spreadDeg));
        this.shallBeRemoved = true;
    }
}

