/*
 * Decompiled with CFR 0.152.
 */
package game.items;

import game.figureRender.Box;
import game.figureRender.Quad;
import game.main.Entity;
import game.main.Game;
import game.main.Main;
import game.main.Player;
import game.map.GameMap;
import game.map.MapBlock;
import game.model.Model;
import game.util.Rect;
import game.util.Vec2;
import game.util.Vec3;

public abstract class Item
extends Entity {
    protected boolean shallBeRemoved;
    protected Player player;
    protected Player owner;
    protected int playerTeam;
    protected Game game;
    protected GameMap map;
    protected float size = 1.0f;
    protected boolean canBeThrown = true;
    protected boolean canBeUsed = true;
    protected int ticksIdle = 0;
    public static final int MAX_IDLE_TICKS = Main.MILLIS_TO_TICKS(10000);
    protected boolean thrown = false;
    protected double throwDamage = 10.0;
    protected boolean swingable = false;
    private int swings = 7;

    public Item(Vec2 pos, Game game, GameMap map) {
        super(pos);
        this.game = game;
        this.map = map;
    }

    public void render() {
    }

    public void renderWhiteArrow() {
        if (System.currentTimeMillis() % 1000L > 500L) {
            Quad.renderQuad(new Vec3(this.pos.x + 0.3f, this.pos.y + 0.9f, 0.0f), new Vec3(this.pos.x + 0.1f, this.pos.y + 1.2f, 0.0f), new Vec3(this.pos.x + 0.5f, this.pos.y + 1.2f, 0.0f), new Vec3(this.pos.x + 0.5f, this.pos.y + 1.2f, 0.0f), Box.white);
        }
    }

    public void renderOnModel() {
    }

    public void playerUse() {
    }

    public void playerThrow(double heading) {
        double throwSpeed = 0.35;
        this.vel.x = (float)(Math.cos(Math.toRadians(heading)) * throwSpeed);
        this.vel.y = (float)(Math.sin(Math.toRadians(heading)) * throwSpeed);
        this.thrown = true;
    }

    public boolean isThrown() {
        return this.thrown;
    }

    public void simulate() {
        ++this.ticksIdle;
        if (this.ticksIdle >= MAX_IDLE_TICKS) {
            this.shallBeRemoved = true;
        }
        if (this.mapBlock != null) {
            this.pos.x += this.mapBlock.getDx();
            this.pos.y += this.mapBlock.getDy();
        }
        if (this.thrown) {
            Player[] playerArray = this.game.getNonEliminatedPlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                if (this.owner.isEnemyTo(p) && this.getCollisionRect().intersects(p.getCollisionRect())) {
                    p.takeDamage(this.throwDamage, this);
                    this.shallBeRemoved = true;
                }
                ++n2;
            }
        }
        if (this.player == null) {
            int moveParts = 100;
            int i = 0;
            while (i < moveParts) {
                float oldX = this.pos.x;
                float oldY = this.pos.y;
                this.pos.x += this.vel.x / (float)moveParts;
                this.pos.y += this.vel.y / (float)moveParts;
                MapBlock collides = this.map.collides(this);
                if (collides != null) {
                    if (this.vel.y < 0.0f) {
                        this.mapBlock = collides;
                    }
                    this.vel.y = 0.0f;
                    this.vel.x = 0.0f;
                    this.pos.x = oldX;
                    this.pos.y = oldY;
                    if (this.thrown) {
                        this.shallBeRemoved = true;
                    }
                }
                ++i;
            }
            this.vel.y -= this.game.getGravity() * 0.5f;
        } else {
            this.ticksIdle = 0;
            this.pos.x = this.player.getPosition().x;
            this.pos.y = this.player.getPosition().y + this.player.getCollisionRect().h / 2.0f;
        }
    }

    public boolean shallBeRemoved() {
        return this.shallBeRemoved;
    }

    @Override
    public Rect getCollisionRect() {
        return new Rect(this.pos.x, this.pos.y, this.size, this.size);
    }

    public void setPlayer(Player player) {
        this.player = player;
        if (player != null) {
            this.owner = player;
        }
    }

    public boolean isUpPickable() {
        return !this.thrown;
    }

    public Player getPlayer() {
        return this.player;
    }

    protected boolean isBlinking() {
        int ticksLeft = MAX_IDLE_TICKS - this.ticksIdle;
        if (ticksLeft > 100) {
            return false;
        }
        if (ticksLeft > 50) {
            int t = 16;
            return this.ticksIdle % t > t / 2;
        }
        int t = 8;
        return this.ticksIdle % t > t / 2;
    }

    public Model.Limb getLimb() {
        return Model.Limb.HAND_RIGHT;
    }

    public boolean canBeThrown() {
        return this.canBeThrown;
    }

    public boolean canBeUsed() {
        return this.canBeUsed;
    }

    public boolean canActivateVemKasta() {
        return true;
    }

    public boolean isSwingable() {
        return this.swingable;
    }

    public void swing() {
        --this.swings;
        if (this.swings <= 0) {
            this.shallBeRemoved = true;
        }
    }
}

