/*
 * Decompiled with CFR 0.152.
 */
package game.items;

import game.buffs.JoltBuff;
import game.figureRender.Box;
import game.items.Item;
import game.main.Game;
import game.main.Main;
import game.map.GameMap;
import game.sound.Sound;
import game.util.Vec2;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;

public class Jolt
extends Item {
    private float rot = 0.0f;

    public Jolt(Vec2 pos, Game game, GameMap map) {
        super(pos, game, map);
        this.size = 0.5f;
    }

    @Override
    public void playerUse() {
        Main.SOUND.play(Sound.DRINK);
        this.player.addBuff(new JoltBuff());
        this.shallBeRemoved = true;
    }

    @Override
    public void render() {
        if (this.isBlinking()) {
            return;
        }
        if (this.owner == null) {
            this.renderWhiteArrow();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(this.pos.x + this.size / 2.0f, this.pos.y + this.size / 2.0f, 0.0f);
        if (this.isThrown()) {
            this.rot += 4.0f;
            GL11.glRotatef(this.rot, 0.0f, 0.0f, 1.0f);
        }
        GL11.glTranslatef(-this.size / 2.0f, -this.size / 2.0f, 0.0f);
        Color.white.bind();
        GL11.glBindTexture(3553, Box.joltItem);
        GL11.glBegin(7);
        float y = 0.734375f;
        float x = 0.4609375f;
        GL11.glTexCoord2f(x, y);
        GL11.glVertex3f(this.size, 0.0f, 0.0f);
        GL11.glTexCoord2f(0.0f, y);
        GL11.glVertex3f(0.0f, 0.0f, 0.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(0.0f, 0.0f + this.size, 0.0f);
        GL11.glTexCoord2f(x, 0.0f);
        GL11.glVertex3f(0.0f + this.size, 0.0f + this.size, 0.0f);
        GL11.glEnd();
        GL11.glBindTexture(3553, 0);
        GL11.glPopMatrix();
    }

    @Override
    public void renderOnModel() {
        GL11.glPushMatrix();
        Vec2 realpos = this.pos.clone();
        this.pos = new Vec2(0.0f);
        GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        GL11.glTranslatef(-this.size / 2.0f, -this.size / 2.0f, 0.0f);
        this.render();
        this.pos = realpos;
        GL11.glPopMatrix();
    }
}

