/*
 * Decompiled with CFR 0.152.
 */
package game.items;

import game.attacks.MeleeAttack;
import game.figureRender.Quad;
import game.items.Item;
import game.main.Game;
import game.map.GameMap;
import game.obj.OBJExtractor;
import game.util.Vec2;
import game.util.Vec3;
import org.lwjgl.opengl.GL11;

public class Keyboard
extends Item {
    private static OBJExtractor.OBJ keyboard;
    private MeleeAttack attack;

    static {
        OBJExtractor obje = new OBJExtractor();
        keyboard = obje.loadModel("keyboard.obj");
    }

    public Keyboard(Vec2 pos, Game game, GameMap map) {
        super(pos, game, map);
        this.canBeThrown = true;
        this.size = 0.2f;
        this.swingable = true;
        this.canBeUsed = false;
    }

    @Override
    public void render() {
        GL11.glPushMatrix();
        if (this.owner == null) {
            GL11.glTranslatef(-0.1f, 0.0f, 0.0f);
            this.renderWhiteArrow();
        }
        GL11.glPopMatrix();
        if (this.isBlinking()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(this.pos.x + this.size / 2.0f, this.pos.y + this.size, 0.0f);
        if (this.player != null) {
            GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        }
        float scale = 30.0f;
        int i = 0;
        while (i < Keyboard.keyboard.faces.size()) {
            Vec3 topLeft = Keyboard.keyboard.vecs.get(Keyboard.keyboard.faces.get(i).get(0) - 1);
            Vec3 topRight = Keyboard.keyboard.vecs.get(Keyboard.keyboard.faces.get(i).get(1) - 1);
            Vec3 botRight = Keyboard.keyboard.vecs.get(Keyboard.keyboard.faces.get(i).get(2) - 1);
            topLeft = topLeft.multiply(scale);
            topRight = topRight.multiply(scale);
            botRight = botRight.multiply(scale);
            Vec3 color = new Vec3();
            color = i <= Keyboard.keyboard.faces.size() - 6 ? new Vec3(0.6f, 0.6f, 0.6f) : new Vec3(0.7f, 0.7f, 0.7f);
            if (Keyboard.keyboard.faces.get(i).size() == 4) {
                Vec3 botLeft = Keyboard.keyboard.vecs.get(Keyboard.keyboard.faces.get(i).get(3) - 1);
                botLeft = botLeft.multiply(scale);
                Quad.renderQuad(topLeft, topRight, botRight, botLeft, color);
            }
            ++i;
        }
        GL11.glPopMatrix();
    }

    @Override
    public void renderOnModel() {
        GL11.glPushMatrix();
        Vec2 realpos = this.pos.clone();
        this.pos = new Vec2(0.0f);
        GL11.glTranslatef(-this.size / 2.0f + 0.1f, -this.size / 2.0f - 0.4f, 0.4f);
        this.render();
        this.pos = realpos;
        GL11.glPopMatrix();
    }

    @Override
    public void playerUse() {
    }
}

