/*
 * Decompiled with CFR 0.152.
 */
package game.items;

import game.figureRender.Box;
import game.figureRender.Quad;
import game.items.Item;
import game.main.Game;
import game.main.Main;
import game.map.GameMap;
import game.obj.OBJExtractor;
import game.projectiles.Bullet;
import game.sound.Sound;
import game.util.Vec2;
import game.util.Vec3;
import org.lwjgl.opengl.GL11;

public class Rifle
extends Item {
    private static OBJExtractor.OBJ rifle;
    private int roundsLeft = 10;

    static {
        OBJExtractor obje = new OBJExtractor();
        rifle = obje.loadModel("laser.obj");
    }

    public Rifle(Vec2 pos, Game game, GameMap map) {
        super(pos, game, map);
    }

    @Override
    public void playerUse() {
        --this.roundsLeft;
        if (this.roundsLeft <= 0) {
            this.shallBeRemoved = true;
        }
        Main.SOUND.play(Sound.LASER);
        this.game.addProjectile(new Bullet(this.owner, this.game, (float)this.player.getHeadingDeg()));
    }

    @Override
    public void render() {
        if (this.isBlinking()) {
            return;
        }
        if (this.owner == null) {
            this.renderWhiteArrow();
        }
        GL11.glPushMatrix();
        if (this.player != null) {
            GL11.glTranslatef(this.pos.x + this.size / 2.0f, this.pos.y + this.size, 0.0f);
            GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
        } else {
            GL11.glTranslatef(this.pos.x + this.size / 2.0f, this.pos.y, 0.0f);
        }
        float scale = 30.0f;
        int i = 0;
        while (i < Rifle.rifle.faces.size()) {
            Vec3 topLeft = Rifle.rifle.vecs.get(Rifle.rifle.faces.get(i).get(0) - 1);
            Vec3 topRight = Rifle.rifle.vecs.get(Rifle.rifle.faces.get(i).get(1) - 1);
            Vec3 botRight = Rifle.rifle.vecs.get(Rifle.rifle.faces.get(i).get(2) - 1);
            topLeft = topLeft.multiply(scale);
            topRight = topRight.multiply(scale);
            botRight = botRight.multiply(scale);
            Vec3 color = new Vec3();
            if (Rifle.rifle.faces.get(i).size() == 4) {
                Vec3 botLeft = Rifle.rifle.vecs.get(Rifle.rifle.faces.get(i).get(3) - 1);
                botLeft = botLeft.multiply(scale);
                Quad.renderQuad(topLeft, topRight, botRight, botLeft, Box.helm);
            } else {
                Quad.renderQuad(topLeft, topRight, botRight, botRight, Box.helm);
            }
            ++i;
        }
        GL11.glPopMatrix();
    }

    @Override
    public void renderOnModel() {
        GL11.glPushMatrix();
        Vec2 realpos = this.pos.clone();
        this.pos = new Vec2(0.0f);
        GL11.glTranslatef(-0.5f, -1.25f, 0.0f);
        this.render();
        this.pos = realpos;
        GL11.glPopMatrix();
    }
}

