/*
 * Decompiled with CFR 0.152.
 */
package game.main;

import game.main.Player;
import game.map.events.Datortrash;
import game.map.events.Event;
import game.map.events.JoltEvent;
import game.util.Vec3;

public class Camera {
    public Vec3 pos = new Vec3(0.0f, 0.0f, 0.0f);
    public Vec3 rot = new Vec3(0.0f, 0.0f, 0.0f);

    public void update(Vec3 p, Vec3 r) {
        this.pos = p;
        this.rot = r;
    }

    private Vec3 getDirectionVector(Vec3 v) {
        Vec3 dv = v.clone();
        Vec3 dv2 = dv.clone();
        dv2.y = (float)((double)dv.y * Math.cos(Math.toRadians(this.rot.x)) - (double)dv.z * Math.sin(Math.toRadians(this.rot.x)));
        dv2.z = (float)((double)dv.y * Math.sin(Math.toRadians(this.rot.x)) + (double)dv.z * Math.cos(Math.toRadians(this.rot.x)));
        dv2.x = dv.x;
        dv = dv2.clone();
        dv2.z = (float)((double)dv.z * Math.cos(Math.toRadians(this.rot.y)) - (double)dv.x * Math.sin(Math.toRadians(this.rot.y)));
        dv2.x = (float)((double)dv.z * Math.sin(Math.toRadians(this.rot.y)) + (double)dv.x * Math.cos(Math.toRadians(this.rot.y)));
        dv2.y = dv.y;
        return dv2;
    }

    public Vec3 getDirectionVectorX() {
        return this.getDirectionVector(new Vec3(1.0f, 0.0f, 0.0f));
    }

    public Vec3 getDirectionVectorY() {
        return this.getDirectionVector(new Vec3(0.0f, 1.0f, 0.0f));
    }

    public Vec3 getDirectionVectorZ() {
        return this.getDirectionVector(new Vec3(0.0f, 0.0f, 1.0f));
    }

    public void update(Player[] players, Player myPlayer, Player winner, Event currentEvent) {
        float xyzDistance;
        if (winner != null) {
            Vec3 target = new Vec3();
            Vec3 tr = new Vec3();
            target.x = winner.getPos().x + (float)(winner.getHeadingDeg() == 0.0 ? 3 : -3);
            target.y = winner.getPos().y + 4.0f;
            target.z = 5.0f;
            float xyzDistance2 = (float)Math.sqrt((target.x - this.pos.x) * (target.x - this.pos.x) + (target.y - this.pos.y) * (target.y - this.pos.y) + (target.z - this.pos.z) * (target.z - this.pos.z));
            if (xyzDistance2 > 0.1f) {
                Vec3 dir = target.subtract(this.pos);
                dir = dir.multiply(1.0f / xyzDistance2);
                this.pos = this.pos.add(dir.multiply(0.1f * xyzDistance2));
            }
            tr.x = -30.0f;
            tr.y = winner.getHeadingDeg() == 0.0 ? 30 : -30;
            if (this.rot.x > tr.x + 1.0f) {
                this.rot.x -= 0.5f;
            }
            if (this.rot.x < tr.x - 1.0f) {
                this.rot.x += 0.5f;
            }
            if (this.rot.y > tr.y + 1.0f) {
                this.rot.y -= 0.5f;
            }
            if (this.rot.y < tr.y - 1.0f) {
                this.rot.y += 0.5f;
            }
            return;
        }
        float minz = 15.0f;
        float minx = Float.MAX_VALUE;
        float miny = Float.MAX_VALUE;
        float maxy = -3.4028235E38f;
        float maxx = -3.4028235E38f;
        int i = 0;
        while (i < players.length) {
            minx = Math.min(minx, players[i].getPosition().x);
            miny = Math.min(miny, players[i].getPosition().y);
            maxx = Math.max(maxx, players[i].getPosition().x);
            maxy = Math.max(maxy, players[i].getPosition().y + 1.2f);
            ++i;
        }
        minx = Math.max(minx, -20.0f);
        miny = Math.max(miny, -20.0f);
        maxx = Math.min(maxx, 20.0f);
        maxy = Math.min(maxy, 20.0f);
        Vec3 target = new Vec3((minx + maxx) / 2.0f, (miny + maxy) / 2.0f, Math.max(maxx - minx, maxy - miny) * 1.4f);
        if (currentEvent != null) {
            if (!(currentEvent instanceof JoltEvent) && currentEvent instanceof Datortrash) {
                target = new Vec3(0.0f, 0.0f, 28.0f);
            }
        } else {
            this.rot = new Vec3();
        }
        if ((xyzDistance = (float)Math.sqrt((target.x - this.pos.x) * (target.x - this.pos.x) + (target.y - this.pos.y) * (target.y - this.pos.y) + (target.z - this.pos.z) * (target.z - this.pos.z))) <= 1.0f) {
            return;
        }
        Vec3 dir = target.subtract(this.pos);
        dir = dir.multiply(1.0f / xyzDistance);
        this.pos = this.pos.add(dir.multiply(0.05f * xyzDistance));
        this.pos.z = Math.max(this.pos.z, minz);
    }
}

