/*
 * Decompiled with CFR 0.152.
 */
package game.main;

import game.map.MapBlock;
import game.util.Rect;
import game.util.Vec2;

public abstract class Entity {
    protected Vec2 pos;
    protected Rect hitBox;
    protected Vec2 vel = new Vec2();
    protected MapBlock mapBlock;
    protected MapBlock mapBlockDown;

    public Entity(Vec2 pos) {
        this.pos = pos;
    }

    public Entity() {
        this.pos = new Vec2();
    }

    public double disTo(Entity e) {
        double dx = this.pos.x - e.getPos().x;
        double dy = this.pos.y - e.getPos().y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public Vec2 getPos() {
        return this.pos;
    }

    public Rect getCollisionRect() {
        return this.hitBox;
    }

    public Vec2 getVel() {
        return this.vel;
    }

    public MapBlock getMapBlock() {
        return this.mapBlock;
    }

    public MapBlock getMapBlockDown() {
        return this.mapBlockDown;
    }
}

