/*
 * Decompiled with CFR 0.152.
 */
package game.main;

import game.bots.Bot;
import game.effects.Effect;
import game.items.Billys;
import game.items.Helm;
import game.items.Item;
import game.items.Jolt;
import game.items.Keyboard;
import game.items.PickAxe;
import game.items.Rifle;
import game.main.Camera;
import game.main.Main;
import game.main.Player;
import game.main.Render;
import game.main.WinnerScreen;
import game.map.GameMap;
import game.model.BirdieModel;
import game.model.GabenModel;
import game.model.PacModel;
import game.model.SteveModel;
import game.model.StickModel;
import game.network.Network;
import game.projectiles.Projectile;
import game.util.Settings;
import game.util.Vec2;
import game.util.Vec3;
import java.util.ArrayList;
import java.util.Random;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;

public class Game {
    private Player[] players;
    private Bot[] bots = Settings.DEBUG_BOTS;
    private boolean initDone = false;
    private int simulationTick;
    private GameMap map;
    private Camera camera;
    private ArrayList<Item> items;
    private Random simulationRandom;
    private int myPlayerID;
    private ArrayList<Effect> effects;
    private boolean timeOn;
    private int timeTicks;
    private int stocks;
    private boolean eventsOn;
    private boolean itemsOn;
    private int vemKastaCounter;
    private int vemKastaMax;
    private int winnerCamTimer;
    private int winnerCamTime = Main.MILLIS_TO_TICKS(4000);
    private boolean winnerCamStarted;
    private Player winnerPlayer;
    private boolean gameFinished;
    private ArrayList<Projectile> projectiles;
    private WinnerScreen winnerScreen;
    private long millis = -1L;
    private boolean fboInitDone = false;
    private int[] colorTextureID;
    private int[] framebufferID;
    private int[] depthRenderBufferID;

    public Game(Camera camera) {
        this.camera = camera;
    }

    public void init(Network.ServerKeys skeys, Network.ServerLobbyState sls) {
        this.timeOn = sls.timeON;
        if (this.timeOn) {
            this.timeTicks = Main.MILLIS_TO_TICKS(sls.maxTime * 60 * 1000);
        } else {
            this.stocks = sls.maxLives;
        }
        this.eventsOn = sls.eventsON;
        this.itemsOn = sls.itemsON;
        this.vemKastaMax = 5;
        this.vemKastaCounter = 0;
        this.simulationTick = 0;
        this.map = new GameMap(this, this.eventsOn);
        this.items = new ArrayList();
        this.effects = new ArrayList();
        this.simulationRandom = new Random(sls.seed);
        this.players = new Player[skeys.IDs.length + this.bots.length];
        int i = 0;
        while (i < skeys.IDs.length) {
            this.players[i] = new Player(this, this.stocks, sls.currentLobbyPlayers[i].character, this.timeOn);
            this.players[i].ID = skeys.IDs[i];
            this.players[i].setName(sls.currentLobbyPlayers[i].name);
            ++i;
        }
        i = skeys.IDs.length;
        while (i < this.players.length) {
            this.players[i] = new Player(this, this.stocks, 0, this.timeOn);
            this.players[i].ID = 1000000 + i;
            this.players[i].setName("Bot");
            ++i;
        }
        this.winnerCamTimer = -1;
        this.winnerCamStarted = false;
        this.winnerPlayer = null;
        this.gameFinished = false;
        this.projectiles = new ArrayList();
        this.initDone = true;
    }

    public void setMyPlayerID(int myPlayerID) {
        this.myPlayerID = myPlayerID;
    }

    private Player getPlayer(int ID) {
        int j = 0;
        while (j < this.players.length) {
            if (this.players[j].ID == ID) {
                return this.players[j];
            }
            ++j;
        }
        return null;
    }

    public void simulate(Network.ServerKeys skeys) {
        int i;
        if (Settings.DEBUG_PRINT_MILLIS_BETWEEN_SIMULATION) {
            System.out.println(System.currentTimeMillis() - this.millis);
            this.millis = System.currentTimeMillis();
        }
        --this.winnerCamTimer;
        ++this.simulationTick;
        if (this.timeOn) {
            --this.timeTicks;
        }
        this.camera.update(this.getNonEliminatedPlayers(), this.getPlayer(this.myPlayerID), this.winnerPlayer, this.map.getCurrentEvent());
        int[] ids = skeys.IDs;
        Network.ClientInformation[] keys = skeys.keys;
        if (!this.winnerCamStarted) {
            i = 0;
            while (i < ids.length) {
                Player p = this.getPlayer(ids[i]);
                if (!p.isEliminated()) {
                    p.simulate(this.simulationTick, keys[i]);
                }
                ++i;
            }
            i = 0;
            while (i < this.bots.length) {
                int pid = this.players.length - this.bots.length + i;
                if (!this.players[pid].isEliminated()) {
                    this.players[pid].simulate(this.simulationTick, this.bots[i].getClientInformation());
                }
                ++i;
            }
        }
        int[] nArray = skeys.disconnectedIDs;
        int n = skeys.disconnectedIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            Player p = this.getPlayer(id);
            if (p != null) {
                p.disconnect();
            }
            ++n2;
        }
        if (!this.winnerCamStarted) {
            this.map.simulate(this.simulationTick);
            if (this.simulationRandom.nextDouble() > 0.995 && this.itemsOn) {
                this.items.add(this.newItem());
            }
            i = 0;
            while (i < this.items.size()) {
                this.items.get(i).simulate();
                ++i;
            }
            i = 0;
            while (i < this.items.size()) {
                if (this.items.get(i).shallBeRemoved()) {
                    this.items.remove(i);
                    --i;
                }
                ++i;
            }
            i = 0;
            while (i < this.effects.size()) {
                this.effects.get(i).simulate();
                ++i;
            }
            i = 0;
            while (i < this.effects.size()) {
                if (this.effects.get(i).shallBeRemoved()) {
                    this.effects.remove(i);
                    --i;
                }
                ++i;
            }
            i = 0;
            while (i < this.projectiles.size()) {
                this.projectiles.get(i).simulate();
                ++i;
            }
            i = 0;
            while (i < this.projectiles.size()) {
                if (this.projectiles.get(i).shallBeRemoved()) {
                    this.projectiles.remove(i);
                    --i;
                }
                ++i;
            }
        }
        this.updateGameFinished();
    }

    private Item newItem() {
        double itemRandom = this.simulationRandom.nextDouble();
        double posRandom = this.simulationRandom.nextDouble();
        double xmin = this.map.getBlockMinX();
        double xmax = this.map.getBlockMaxX();
        double dx = xmax - xmin;
        Vec2 p = new Vec2((float)(xmin + dx * posRandom), 20.0f);
        if (itemRandom > 0.85) {
            return new Helm(p, this, this.map);
        }
        if (itemRandom > 0.68) {
            return new Jolt(p, this, this.map);
        }
        if (itemRandom > 0.51) {
            return new Keyboard(p, this, this.map);
        }
        if (itemRandom > 0.34) {
            return new Rifle(p, this, this.map);
        }
        if (itemRandom > 0.17) {
            return new Billys(p, this, this.map);
        }
        return new PickAxe(p, this, this.map);
    }

    public void render(Render render, int width, int height) {
        int i;
        if (!this.initDone) {
            return;
        }
        this.map.render();
        if (this.players != null) {
            Player[] playerArray = this.players;
            int n = this.players.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                if (p != null && !p.isEliminated()) {
                    p.render();
                }
                ++n2;
            }
            i = 0;
            while (i < this.players.length) {
                Player player = this.players[i];
                String name = player.getName().toUpperCase();
                name = name == "" ? "Inget namn" : name;
                int l = name.length();
                render.drawString(width / (2 * this.players.length) * (2 * i + 1) - 30, height - 140, name, Vec3.WHITE, Vec3.BLACK, "INGAME_FONT");
                if (!this.fboInitDone) {
                    this.colorTextureID = new int[4];
                    this.framebufferID = new int[4];
                    this.depthRenderBufferID = new int[4];
                    int j = 0;
                    while (j < 4) {
                        this.framebufferID[j] = EXTFramebufferObject.glGenFramebuffersEXT();
                        this.colorTextureID[j] = GL11.glGenTextures();
                        this.depthRenderBufferID[j] = EXTFramebufferObject.glGenRenderbuffersEXT();
                        EXTFramebufferObject.glBindFramebufferEXT(36160, this.framebufferID[j]);
                        GL11.glBindTexture(3553, this.colorTextureID[j]);
                        GL11.glTexParameterf(3553, 10241, 9729.0f);
                        GL11.glTexImage2D(3553, 0, 32856, 512, 512, 0, 6408, 5124, null);
                        EXTFramebufferObject.glFramebufferTexture2DEXT(36160, 36064, 3553, this.colorTextureID[j], 0);
                        EXTFramebufferObject.glBindRenderbufferEXT(36161, this.depthRenderBufferID[j]);
                        EXTFramebufferObject.glRenderbufferStorageEXT(36161, 33190, 512, 512);
                        EXTFramebufferObject.glFramebufferRenderbufferEXT(36160, 36096, 36161, this.depthRenderBufferID[j]);
                        EXTFramebufferObject.glBindFramebufferEXT(36160, 0);
                        ++j;
                    }
                    this.fboInitDone = true;
                }
                GL11.glPushMatrix();
                float ar = (float)Main.width / (float)Main.height;
                GL11.glViewport((int)(-(ar - 1.0f) * 256.0f), 0, (int)(512.0f * ar), 512);
                GL11.glBindTexture(3553, 0);
                EXTFramebufferObject.glBindFramebufferEXT(36160, this.framebufferID[i]);
                GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                GL11.glClear(16640);
                GL11.glLoadIdentity();
                if (player.model instanceof BirdieModel) {
                    GL11.glTranslatef(0.0f, 0.5f, -2.0f);
                    GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
                    GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
                } else if (player.model instanceof StickModel) {
                    GL11.glTranslatef(0.0f, 0.0f, -3.0f);
                    GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
                    GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
                } else if (player.model instanceof GabenModel) {
                    GL11.glTranslatef(0.0f, 0.0f, -2.25f);
                    GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
                    GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
                } else if (player.model instanceof PacModel) {
                    GL11.glTranslatef(0.0f, -0.5f, -3.0f);
                    GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
                    GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
                } else if (player.model instanceof SteveModel) {
                    GL11.glTranslatef(0.0f, 0.0f, -1.75f);
                    GL11.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
                    GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
                }
                player.model.renderHead(null, false);
                GL11.glPopMatrix();
                GL11.glEnable(3553);
                EXTFramebufferObject.glBindFramebufferEXT(36160, 0);
                GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                GL11.glEnable(3042);
                GL11.glBlendFunc(770, 771);
                GL11.glViewport(0, 0, Main.width, Main.height);
                GL11.glEnable(3553);
                render.drawString(width / (2 * this.players.length) * (2 * i + 1) + 70 + 2, height - 60 - 60 + 2, String.valueOf((int)player.getDamageTaken()) + "%", Vec3.BLACK, "INGAME_FONT_LARGE");
                double p = this.players[i].getTakingDamagePercent();
                render.drawString(width / (2 * this.players.length) * (2 * i + 1) + 70, height - 60 - 60, String.valueOf((int)player.getDamageTaken()) + "%", new Vec3((float)(1.0 - p), p == 0.0 ? 1 : 0, p == 0.0 ? 1 : 0), "INGAME_FONT_LARGE");
                render.drawImage(width / (2 * this.players.length) * (2 * i + 1) - 70, height - 150, 200, 200, this.colorTextureID[i]);
                if (this.timeOn) {
                    render.drawString(width / (2 * this.players.length) * (2 * i + 1) - 30, height - 45, String.valueOf("Antal d\u00f6dsfall: ".toUpperCase()) + -player.getLives(), Vec3.WHITE, Vec3.BLACK, "INGAME_FONT");
                } else {
                    render.drawString(width / (2 * this.players.length) * (2 * i + 1) - 30, height - 45, String.valueOf("Antal liv: ".toUpperCase()) + player.getLives(), Vec3.WHITE, Vec3.BLACK, "INGAME_FONT");
                }
                ++i;
            }
            if (this.timeOn) {
                int millis = Main.TICKS_TO_MILLIS(this.timeTicks);
                int m = millis / 60000;
                int s = millis / 1000 % 60;
                render.drawString(52, 52, (m < 10 ? "0" + m : Integer.valueOf(m)) + ":" + (s < 10 ? "0" + s : Integer.valueOf(s)), Vec3.BLACK, "INGAME_FONT_LARGE");
                render.drawString(50, 50, (m < 10 ? "0" + m : Integer.valueOf(m)) + ":" + (s < 10 ? "0" + s : Integer.valueOf(s)), Vec3.WHITE, "INGAME_FONT_LARGE");
            }
            if (this.winnerPlayer != null) {
                render.drawString(width / 2 + 2 - 200, height / 2 + 2 - 200, "VINNARE", Vec3.BLACK, "INGAME_FONT_LARGER");
                render.drawString(width / 2 - 200, height / 2 - 200, "VINNARE", Vec3.WHITE, "INGAME_FONT_LARGER");
            }
        }
        i = 0;
        while (i < this.items.size()) {
            Item item = this.items.get(i);
            if (item.getPlayer() == null) {
                item.render();
            }
            ++i;
        }
        i = 0;
        while (i < this.effects.size()) {
            this.effects.get(i).render();
            ++i;
        }
        i = 0;
        while (i < this.projectiles.size()) {
            this.projectiles.get(i).render();
            ++i;
        }
    }

    public float getGravity() {
        return 0.0075f;
    }

    public GameMap getMap() {
        return this.map;
    }

    public Item tryPickUpItem(Player player) {
        float d = 3.0f;
        for (Item item : this.items) {
            if (!item.isUpPickable() || item.getPlayer() != null || !(player.disTo(item) < (double)d)) continue;
            return item;
        }
        return null;
    }

    public Player[] getAllPlayers() {
        return this.players;
    }

    public Player[] getNonEliminatedPlayers() {
        int c = 0;
        Player[] playerArray = this.players;
        int n = this.players.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (!p.isEliminated()) {
                ++c;
            }
            ++n2;
        }
        Player[] non = new Player[c];
        int i = 0;
        int noni = 0;
        while (i < this.players.length) {
            if (!this.players[i].isEliminated()) {
                non[noni] = this.players[i];
                ++noni;
            }
            ++i;
        }
        return non;
    }

    public void addEffect(Effect e) {
        this.effects.add(e);
    }

    public Random getSimulationRandom() {
        return this.simulationRandom;
    }

    public void addItem(Item i) {
        this.items.add(i);
    }

    private void updateGameFinished() {
        Player p;
        if (!this.initDone) {
            this.gameFinished = false;
            return;
        }
        int nonDisconnectedPlayers = 0;
        Player[] playerArray = this.players;
        int n = this.players.length;
        int n2 = 0;
        while (n2 < n) {
            p = playerArray[n2];
            if (!p.hasDisconnected()) {
                ++nonDisconnectedPlayers;
            }
            ++n2;
        }
        if (nonDisconnectedPlayers <= 1) {
            if (!this.winnerCamStarted) {
                this.winnerCamTimer = this.winnerCamTime;
                this.winnerCamStarted = true;
                playerArray = this.players;
                n = this.players.length;
                n2 = 0;
                while (n2 < n) {
                    p = playerArray[n2];
                    if (!p.hasDisconnected()) {
                        this.winnerPlayer = p;
                    }
                    ++n2;
                }
            }
            this.gameFinished = this.winnerCamStarted && this.winnerCamTimer < 0;
            return;
        }
        if (this.timeOn) {
            this.gameFinished = this.timeTicks < 0;
            return;
        }
        int playersLeft = 0;
        Player[] playerArray2 = this.players;
        int n3 = this.players.length;
        n = 0;
        while (n < n3) {
            Player p2 = playerArray2[n];
            if (p2.getLives() > 0 && !p2.hasDisconnected()) {
                ++playersLeft;
            }
            ++n;
        }
        if (playersLeft == 1 && !this.winnerCamStarted) {
            this.winnerCamTimer = this.winnerCamTime;
            this.winnerCamStarted = true;
            playerArray2 = this.players;
            n3 = this.players.length;
            n = 0;
            while (n < n3) {
                Player p3 = playerArray2[n];
                if (p3.getLives() > 0 && !p3.hasDisconnected()) {
                    this.winnerPlayer = p3;
                }
                ++n;
            }
        }
        this.gameFinished = playersLeft == 1 && this.winnerCamStarted && this.winnerCamTimer < 0;
    }

    public boolean isGameFinished() {
        return this.gameFinished;
    }

    public void updateWinnerScreen() {
        this.winnerScreen.update();
    }

    public void renderWinnerScreen(Render render) {
        ArrayList<Player> winners = new ArrayList<Player>();
        ArrayList<Player> losers = new ArrayList<Player>();
        if (this.timeOn) {
            Player p;
            Player winner = null;
            int maxLives = -9999999;
            double minDamageTaken = 9.9999999E7;
            Player[] playerArray = this.players;
            int n = this.players.length;
            int n2 = 0;
            while (n2 < n) {
                p = playerArray[n2];
                int pLives = p.getLives();
                double pDamageTaken = p.getDamageTaken();
                if ((pLives > maxLives || pLives == maxLives && pDamageTaken < minDamageTaken) && !p.hasDisconnected()) {
                    winner = p;
                    maxLives = pLives;
                    minDamageTaken = pDamageTaken;
                }
                ++n2;
            }
            playerArray = this.players;
            n = this.players.length;
            n2 = 0;
            while (n2 < n) {
                p = playerArray[n2];
                if (p == winner) {
                    winners.add(p);
                } else {
                    losers.add(p);
                }
                ++n2;
            }
        } else {
            Player[] playerArray = this.players;
            int n = this.players.length;
            int n3 = 0;
            while (n3 < n) {
                Player p = playerArray[n3];
                if (p.getLives() > 0 && !p.hasDisconnected()) {
                    winners.add(p);
                } else {
                    losers.add(p);
                }
                ++n3;
            }
        }
        render.drawString(100, 50, "Vinnare: ", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
        int i = 0;
        while (i < winners.size()) {
            render.drawString(100, 100 + i * 50, ((Player)winners.get(i)).getName(), Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
            ++i;
        }
        render.drawString(600, 50, "F\u00f6rlorare: ", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
        i = 0;
        while (i < losers.size()) {
            render.drawString(600, 100 + i * 50, losers.get(i).getName(), Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
            ++i;
        }
        this.winnerScreen.render(winners, losers);
    }

    public boolean tryPlayVemKasta() {
        --this.vemKastaCounter;
        if (this.vemKastaCounter <= 0) {
            this.vemKastaCounter = this.vemKastaMax;
            return true;
        }
        return false;
    }

    public void addProjectile(Projectile projectile) {
        this.projectiles.add(projectile);
    }

    public void resetWinnerScreen() {
        this.winnerScreen = new WinnerScreen(this.camera, this);
    }
}

