/*
 * Decompiled with CFR 0.152.
 */
package game.main;

import com.esotericsoftware.kryonet.Client;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Listener;
import game.figureRender.Box;
import game.main.Camera;
import game.main.Fonts;
import game.main.Game;
import game.main.Intro;
import game.main.Launcher;
import game.main.Render;
import game.network.GameClient;
import game.network.Network;
import game.sound.Sound;
import game.util.Input;
import game.util.Vec3;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class Main {
    private Camera camera = new Camera();
    private static Launcher LAUNCHER = new Launcher();
    public static final int width = Main.LAUNCHER.getResolution().width;
    public static final int height = Main.LAUNCHER.getResolution().height;
    private boolean fullscreen = LAUNCHER.getFullScreen();
    private Render render = new Render("Birdiefighter II - Slaget om Allianshallen", this.camera, width, height, this.fullscreen);
    private Input input = new Input();
    private Game game = new Game(this.camera);
    private GameClient gameClient = new GameClient(this.input, this.game, width, height);
    private State state = State.INTRO;
    private String joinIP = "";
    private Intro intro;
    private final String name = LAUNCHER.getName();
    private String serverName = "";
    private int maxPlayers = 4;
    private boolean nameReset;
    private int selectedChoice = 0;
    private String couldNotConnectMessage = "";
    private boolean gameClientReset = false;
    public static final Sound SOUND = new Sound(LAUNCHER.getSoundVolume(), LAUNCHER.getMusicVolume());
    private ArrayList<Network.ServerInfo> serverInfos = new ArrayList();
    private volatile boolean scanning;
    private volatile long scanningStart;
    private long lastCharTime = 0L;

    public static void main(String[] args) {
        new Main();
    }

    public Main() {
        SOUND.setMusic(Sound.MENU_MUSIC);
        this.render.init();
        Fonts.initFonts(this.render);
        while (!Display.isCloseRequested()) {
            this.input.poll();
            this.update();
            this.render.beginRender();
            try {
                this.render();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.render.endRender();
            if (this.input.isKeyDown(1)) break;
        }
        System.exit(0);
    }

    public Camera getCamera() {
        return this.camera;
    }

    private void render() {
        int x = width / 2 - 205;
        int y = height / 2 - 100;
        if (this.state != State.GAME && this.state != State.WINNER_SCREEN && this.state != State.LOBBY && this.state != State.INTRO) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)((double)System.currentTimeMillis() * 0.001 % 360.0), 0.0f, 0.0f, 1.0f);
            Box.renderBox(new Vec3(0.0f, 0.0f, 0.0f), new Vec3(25.0f), Box.skyFract);
            GL11.glPopMatrix();
            GL11.glTranslatef(0.0f, 0.0f, -15.0f);
        }
        switch (this.state) {
            case INTRO: {
                this.intro.render();
                break;
            }
            case LOBBY: {
                this.gameClient.render(this.render, width, height, this.camera);
                break;
            }
            case WINNER_SCREEN: {
                this.game.renderWinnerScreen(this.render);
                break;
            }
            case GAME: {
                this.game.render(this.render, width, height);
                break;
            }
            case MAIN_MENU: {
                this.render.drawString(x, y, "Joina IP", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x, y + 50, "S\u00f6k servrar", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x, y + 100, "Hosta", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x, y + 150, "Visa kontroller", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x, y + 200, "Avsluta", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x - 30, y + 50 * (this.selectedChoice % 5), ">", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                break;
            }
            case SEARCH_SERVERS: {
                int choises = 2 + this.serverInfos.size();
                this.render.drawString(x - 30 - 100, y + 50 * (this.selectedChoice % choises) + (this.selectedChoice > 1 ? 50 : 0), ">", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x - 100, y, "Skanna LAN", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x - 100, y + 50, "Tillbaka", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                int i = 0;
                while (i < this.serverInfos.size()) {
                    this.render.drawString(x - 100, y + 150 + i * 50, this.serverInfos.get(i).toString(), Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                    ++i;
                }
                if (!this.scanning) break;
                String c = (new String[]{"", ".", "..", "..."})[(int)((double)System.currentTimeMillis() * 0.003 % 4.0)];
                this.render.drawString(x, y + 100, "Skannar" + c, Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                break;
            }
            case JOIN_IP: {
                String ipString = this.joinIP;
                this.render.drawString(x - 200, y + 0, "Joina via IP: " + ipString + this.getBlinkingLine(this.selectedChoice, 0), Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x - 400, y + -50, this.couldNotConnectMessage, Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x - 200, y + 50, "Tillbaka", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x - 30 - 200, y + 50 * (this.selectedChoice % 2), ">", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                break;
            }
            case HOST: {
                this.render.drawString(x - 200, y + 0, "Server namn: " + this.serverName + this.getBlinkingLine(this.selectedChoice, 0), Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x - 200, y + 50, "Max antal spelare: " + this.maxPlayers, Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x - 200, y + 100, "Hosta gamet ", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x - 200, y + 150, "Tillbaka ", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                this.render.drawString(x - 30 - 200, y + 50 * (this.selectedChoice % 4), ">", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
                break;
            }
            case SHOW_CONTROLS: {
                this.render.drawString((x -= 200) - 40, y - 40, "                             G\u00e5 \u00e5t v\u00e4nster - Pil v\u00e4nster", Vec3.WHITE, Vec3.BLACK, "INGAME_FONT");
                this.render.drawString(x - 40, y - 20, "                               G\u00e5 \u00e5t h\u00f6ger - Pil h\u00f6ger", Vec3.WHITE, Vec3.BLACK, "INGAME_FONT");
                this.render.drawString(x - 40, y - 0, "                                     Hoppa - Pil upp", Vec3.WHITE, Vec3.BLACK, "INGAME_FONT");
                this.render.drawString(x - 40, y + 20, "                       Sl\u00e5 och anv\u00e4nd item - Z", Vec3.WHITE, Vec3.BLACK, "INGAME_FONT");
                this.render.drawString(x - 40, y + 40, " Specialattack, kasta item och ta upp item - X", Vec3.WHITE, Vec3.BLACK, "INGAME_FONT");
                this.render.drawString(x - 40, y + 60, "                                     Sk\u00f6ld - C", Vec3.WHITE, Vec3.BLACK, "INGAME_FONT");
                this.render.drawString(x + 70, y + 100, "Tryck enter f\u00f6r att g\u00e5 tillbaka", Vec3.WHITE, Vec3.BLACK, "INGAME_FONT");
                break;
            }
        }
    }

    private String getBlinkingLine(int selectedChoice, int correctChoice) {
        return selectedChoice == correctChoice && System.currentTimeMillis() % 1000L > 500L ? "|" : "";
    }

    private void update() {
        State previousState = this.state;
        int previousSelectedChoice = this.selectedChoice;
        switch (this.state) {
            case INTRO: {
                if (this.intro == null) {
                    this.intro = new Intro(this.render);
                }
                if (this.input.isAnyKeyDown()) {
                    this.state = State.MAIN_MENU;
                    this.intro = null;
                    break;
                }
                this.intro.update();
                break;
            }
            case GAME: {
                this.gameClient.update();
                if (!this.gameClient.isGameFinished()) break;
                this.game.resetWinnerScreen();
                this.state = State.WINNER_SCREEN;
                break;
            }
            case WINNER_SCREEN: {
                this.game.updateWinnerScreen();
                SOUND.setMusic(Sound.MENU_MUSIC);
                if (!this.input.isKeyPressed(28)) break;
                this.gameClientReset = false;
                this.state = State.LOBBY;
                break;
            }
            case LOBBY: {
                if (!this.gameClientReset) {
                    this.gameClient.reset();
                    this.gameClientReset = true;
                }
                this.gameClient.update();
                if (!this.gameClient.isInGame()) break;
                this.camera.pos = new Vec3(0.0f, 0.0f, 20.0f);
                this.state = State.GAME;
                SOUND.setMusic(Sound.GAME_MUSIC);
                break;
            }
            case MAIN_MENU: {
                boolean enter = this.input.isKeyPressed(28);
                if (this.input.isKeyPressed(36) || enter && this.selectedChoice == 0) {
                    this.state = State.JOIN_IP;
                }
                if (enter && this.selectedChoice == 1) {
                    this.serverInfos.clear();
                    this.state = State.SEARCH_SERVERS;
                }
                if (this.input.isKeyPressed(35) || enter && this.selectedChoice == 2) {
                    this.nameReset = false;
                    this.state = State.HOST;
                }
                if (this.input.isKeyPressed(46) || enter && this.selectedChoice == 3) {
                    this.state = State.SHOW_CONTROLS;
                }
                if (this.input.isKeyPressed(18) || enter && this.selectedChoice == 4) {
                    System.exit(0);
                }
                this.selectChoice(5);
                break;
            }
            case HOST: {
                this.selectChoice(4);
                boolean enter = this.input.isKeyPressed(28);
                if (enter && this.selectedChoice == 2) {
                    this.gameClient.setName(this.name);
                    this.gameClient.host(this.maxPlayers, this.serverName);
                    this.state = State.LOBBY;
                }
                if (enter && this.selectedChoice == 3) {
                    this.state = State.MAIN_MENU;
                }
                if (this.selectedChoice == 0) {
                    this.serverName = this.typeInputName(this.serverName);
                }
                if (this.selectedChoice != 1) break;
                if (this.input.isKeyPressed(203)) {
                    this.maxPlayers = Math.max(this.maxPlayers - 1, 2);
                }
                if (!this.input.isKeyPressed(205)) break;
                this.maxPlayers = Math.min(this.maxPlayers + 1, 4);
                break;
            }
            case SEARCH_SERVERS: {
                boolean enter = this.input.isKeyPressed(28) && !this.scanning;
                int choises = 2 + this.serverInfos.size();
                if (!this.scanning) {
                    this.selectChoice(choises);
                }
                if (enter && this.selectedChoice == 0) {
                    this.searchServers();
                }
                if (enter && this.selectedChoice == 1) {
                    this.state = State.MAIN_MENU;
                }
                if (!enter || this.selectedChoice <= 1) break;
                this.couldNotConnectMessage = "";
                String error = this.gameClient.join(this.serverInfos.get((int)(this.selectedChoice - 2)).ip);
                if (error == null) {
                    this.gameClient.setName(this.name);
                    this.state = State.LOBBY;
                    break;
                }
                this.couldNotConnectMessage = "[Kunde inte ansluta till: " + this.joinIP + " | " + error + "]";
                break;
            }
            case JOIN_IP: {
                boolean enter = this.input.isKeyPressed(28);
                if (enter && this.selectedChoice == 0) {
                    this.couldNotConnectMessage = "";
                    String error = this.gameClient.join(this.joinIP);
                    if (error == null) {
                        this.gameClient.setName(this.name);
                        this.state = State.LOBBY;
                    } else {
                        this.couldNotConnectMessage = "[Kunde inte ansluta till: " + this.joinIP + " | " + error + "]";
                    }
                }
                if (enter && this.selectedChoice == 1 || this.input.isKeyPressed(48)) {
                    this.state = State.MAIN_MENU;
                }
                this.selectChoice(2);
                if (this.selectedChoice != 0) break;
                this.joinIP = this.typeInputIP(this.joinIP);
                break;
            }
            case SHOW_CONTROLS: {
                if (!this.input.isKeyPressed(28)) break;
                this.state = State.MAIN_MENU;
                break;
            }
        }
        if (previousState != this.state) {
            this.selectedChoice = 0;
            this.couldNotConnectMessage = "";
        }
        if (this.selectedChoice != previousSelectedChoice) {
            SOUND.play(Sound.CLICK);
        }
    }

    private void searchServers() {
        this.scanning = true;
        this.scanningStart = System.currentTimeMillis();
        new Thread(){

            @Override
            public void run() {
                final List<InetAddress> addresses = new Client().discoverHosts(Network.UDPport, Network.TCPport);
                Main.this.serverInfos.clear();
                int i = 0;
                while (i < addresses.size()) {
                    final int finalI = i;
                    if (!addresses.get(i).getHostAddress().equals("127.0.0.1")) {
                        new Thread(){

                            @Override
                            public void run() {
                                final Network.ServerInfo si = new Network.ServerInfo();
                                Client client = new Client();
                                client.start();
                                Network.register(client);
                                client.addListener(new Listener.ThreadedListener(new Listener(){

                                    @Override
                                    public void connected(Connection connection) {
                                    }

                                    @Override
                                    public void received(Connection connection, Object object) {
                                        if (object instanceof Network.ServerInfo) {
                                            si.serverName = ((Network.ServerInfo)object).serverName;
                                            si.timeON = ((Network.ServerInfo)object).timeON;
                                            si.players = ((Network.ServerInfo)object).players;
                                            si.maxPlayers = ((Network.ServerInfo)object).maxPlayers;
                                            si.inLobby = ((Network.ServerInfo)object).inLobby;
                                            si.ip = ((InetAddress)addresses.get(finalI)).getHostAddress();
                                        }
                                    }

                                    @Override
                                    public void disconnected(Connection connection) {
                                    }
                                }));
                                try {
                                    client.connect(5000, ((InetAddress)addresses.get(finalI)).getHostAddress(), Network.TCPport, Network.UDPport);
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                                Main.this.serverInfos.add(si);
                                try {
                                    try {
                                        Thread.sleep(5000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                        client.close();
                                    }
                                }
                                finally {
                                    client.close();
                                }
                            }
                        }.start();
                    }
                    ++i;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                Main.this.scanning = false;
            }
        }.start();
    }

    private void selectChoice(int choises) {
        if (this.input.isKeyPressed(200)) {
            --this.selectedChoice;
            if (this.selectedChoice <= -1) {
                this.selectedChoice = choises - 1;
            }
        }
        if (this.input.isKeyPressed(208)) {
            ++this.selectedChoice;
            if (this.selectedChoice >= choises) {
                this.selectedChoice = 0;
            }
        }
    }

    private String typeInputName(String s) {
        if (this.input.isKeyDown(42)) {
            if (this.input.isKeyPressed(30)) {
                s = String.valueOf(s) + "A";
            }
            if (this.input.isKeyPressed(48)) {
                s = String.valueOf(s) + "B";
            }
            if (this.input.isKeyPressed(46)) {
                s = String.valueOf(s) + "C";
            }
            if (this.input.isKeyPressed(32)) {
                s = String.valueOf(s) + "D";
            }
            if (this.input.isKeyPressed(18)) {
                s = String.valueOf(s) + "E";
            }
            if (this.input.isKeyPressed(33)) {
                s = String.valueOf(s) + "F";
            }
            if (this.input.isKeyPressed(34)) {
                s = String.valueOf(s) + "G";
            }
            if (this.input.isKeyPressed(35)) {
                s = String.valueOf(s) + "H";
            }
            if (this.input.isKeyPressed(23)) {
                s = String.valueOf(s) + "I";
            }
            if (this.input.isKeyPressed(36)) {
                s = String.valueOf(s) + "J";
            }
            if (this.input.isKeyPressed(37)) {
                s = String.valueOf(s) + "K";
            }
            if (this.input.isKeyPressed(38)) {
                s = String.valueOf(s) + "L";
            }
            if (this.input.isKeyPressed(50)) {
                s = String.valueOf(s) + "M";
            }
            if (this.input.isKeyPressed(49)) {
                s = String.valueOf(s) + "N";
            }
            if (this.input.isKeyPressed(24)) {
                s = String.valueOf(s) + "O";
            }
            if (this.input.isKeyPressed(25)) {
                s = String.valueOf(s) + "P";
            }
            if (this.input.isKeyPressed(16)) {
                s = String.valueOf(s) + "Q";
            }
            if (this.input.isKeyPressed(19)) {
                s = String.valueOf(s) + "R";
            }
            if (this.input.isKeyPressed(31)) {
                s = String.valueOf(s) + "S";
            }
            if (this.input.isKeyPressed(20)) {
                s = String.valueOf(s) + "T";
            }
            if (this.input.isKeyPressed(22)) {
                s = String.valueOf(s) + "U";
            }
            if (this.input.isKeyPressed(47)) {
                s = String.valueOf(s) + "V";
            }
            if (this.input.isKeyPressed(17)) {
                s = String.valueOf(s) + "W";
            }
            if (this.input.isKeyPressed(45)) {
                s = String.valueOf(s) + "X";
            }
            if (this.input.isKeyPressed(21)) {
                s = String.valueOf(s) + "Y";
            }
            if (this.input.isKeyPressed(44)) {
                s = String.valueOf(s) + "Z";
            }
        } else {
            if (this.input.isKeyPressed(30)) {
                s = String.valueOf(s) + "a";
            }
            if (this.input.isKeyPressed(48)) {
                s = String.valueOf(s) + "b";
            }
            if (this.input.isKeyPressed(46)) {
                s = String.valueOf(s) + "c";
            }
            if (this.input.isKeyPressed(32)) {
                s = String.valueOf(s) + "d";
            }
            if (this.input.isKeyPressed(18)) {
                s = String.valueOf(s) + "e";
            }
            if (this.input.isKeyPressed(33)) {
                s = String.valueOf(s) + "f";
            }
            if (this.input.isKeyPressed(34)) {
                s = String.valueOf(s) + "g";
            }
            if (this.input.isKeyPressed(35)) {
                s = String.valueOf(s) + "h";
            }
            if (this.input.isKeyPressed(23)) {
                s = String.valueOf(s) + "i";
            }
            if (this.input.isKeyPressed(36)) {
                s = String.valueOf(s) + "j";
            }
            if (this.input.isKeyPressed(37)) {
                s = String.valueOf(s) + "k";
            }
            if (this.input.isKeyPressed(38)) {
                s = String.valueOf(s) + "l";
            }
            if (this.input.isKeyPressed(50)) {
                s = String.valueOf(s) + "m";
            }
            if (this.input.isKeyPressed(49)) {
                s = String.valueOf(s) + "n";
            }
            if (this.input.isKeyPressed(24)) {
                s = String.valueOf(s) + "o";
            }
            if (this.input.isKeyPressed(25)) {
                s = String.valueOf(s) + "p";
            }
            if (this.input.isKeyPressed(16)) {
                s = String.valueOf(s) + "q";
            }
            if (this.input.isKeyPressed(19)) {
                s = String.valueOf(s) + "r";
            }
            if (this.input.isKeyPressed(31)) {
                s = String.valueOf(s) + "s";
            }
            if (this.input.isKeyPressed(20)) {
                s = String.valueOf(s) + "t";
            }
            if (this.input.isKeyPressed(22)) {
                s = String.valueOf(s) + "u";
            }
            if (this.input.isKeyPressed(47)) {
                s = String.valueOf(s) + "v";
            }
            if (this.input.isKeyPressed(17)) {
                s = String.valueOf(s) + "w";
            }
            if (this.input.isKeyPressed(45)) {
                s = String.valueOf(s) + "x";
            }
            if (this.input.isKeyPressed(21)) {
                s = String.valueOf(s) + "y";
            }
            if (this.input.isKeyPressed(44)) {
                s = String.valueOf(s) + "z";
            }
        }
        if (this.input.isKeyPressed(57)) {
            s = String.valueOf(s) + " ";
        }
        if (this.input.isKeyPressed(52)) {
            s = String.valueOf(s) + ".";
        }
        int i = 1;
        while (i < 10) {
            if (this.input.isKeyPressed(1 + i)) {
                s = String.valueOf(s) + String.valueOf(i);
            }
            ++i;
        }
        if (this.input.isKeyPressed(11)) {
            s = String.valueOf(s) + "0";
        }
        if (this.input.isKeyPressed(14) && s.length() != 0) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private String typeInputIP(String s) {
        if (this.input.isKeyPressed(14) && s.length() != 0) {
            s = s.substring(0, s.length() - 1);
        }
        if (this.input.isKeyPressed(52)) {
            s = String.valueOf(s) + ".";
        }
        int i = 1;
        while (i < 10) {
            if (this.input.isKeyPressed(1 + i)) {
                s = String.valueOf(s) + String.valueOf(i);
            }
            ++i;
        }
        if (this.input.isKeyPressed(11)) {
            s = String.valueOf(s) + "0";
        }
        return s;
    }

    private String typeInputInteger(String s) {
        if (this.input.isKeyPressed(14) && s.length() != 0) {
            s = s.substring(0, s.length() - 1);
        }
        int i = 1;
        while (i < 10) {
            if (this.input.isKeyPressed(1 + i)) {
                s = String.valueOf(s) + String.valueOf(i);
            }
            ++i;
        }
        if (this.input.isKeyPressed(11)) {
            s = String.valueOf(s) + "0";
        }
        return s;
    }

    public static int MILLIS_TO_TICKS(int millis) {
        return millis / GameClient.LOCAL_SLEEP_TIME;
    }

    public static int TICKS_TO_MILLIS(int ticks) {
        return ticks * GameClient.LOCAL_SLEEP_TIME;
    }

    private static enum State {
        INTRO,
        MAIN_MENU,
        LOBBY,
        GAME,
        JOIN_IP,
        HOST,
        WINNER_SCREEN,
        SHOW_CONTROLS,
        SEARCH_SERVERS;

    }
}

