/*
 * Decompiled with CFR 0.152.
 */
package game.main;

import game.attacks.Attack;
import game.attacks.DrillAttack;
import game.attacks.HeadAttack;
import game.attacks.MeleeAttack;
import game.buffs.Buff;
import game.effects.PlayerSmoke;
import game.effects.RespawnEffect;
import game.figureRender.Box;
import game.figureRender.Quad;
import game.items.Item;
import game.items.Rifle;
import game.main.Entity;
import game.main.Game;
import game.main.Main;
import game.map.MapBlock;
import game.model.BirdieModel;
import game.model.GabenModel;
import game.model.Model;
import game.model.PacModel;
import game.model.SteveModel;
import game.model.StickModel;
import game.network.Network;
import game.projectiles.Fireball;
import game.sound.Sound;
import game.util.Rect;
import game.util.Settings;
import game.util.Vec2;
import game.util.Vec3;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public class Player
extends Entity {
    int ID;
    public Model model;
    private float w;
    private float h;
    private Game game;
    private int maxJumps;
    private int jumpsLeft;
    private float headingDeg;
    private float drawHeadingDeg;
    public Item item;
    private double damageTaken;
    private int lives;
    private int team;
    private ArrayList<Buff> buffs;
    private int timeBetweenAttacks;
    private int attackDuration;
    private int attackCounter;
    private Attack attack;
    private int damageTakenTime;
    private int damageTakenCounter;
    private double shieldMax;
    private double shieldReg;
    private double shieldCurrent;
    private boolean usingShield;
    private String name;
    private boolean timeOn;
    private boolean disconnected;
    private int spinCounter;
    private float jumpSpeed;
    private boolean hasSpecialJump;
    private boolean actionPerformed;
    private int stunTimer;
    private int fireBallAnimationCounter;
    private animationState currentAnimation;

    public Player(Game game, int stocks, int character, boolean timeOn) {
        this.jumpsLeft = this.maxJumps = 2;
        this.headingDeg = 0.0f;
        this.drawHeadingDeg = 0.0f;
        this.lives = 1;
        this.team = 0;
        this.buffs = new ArrayList();
        this.timeBetweenAttacks = Main.MILLIS_TO_TICKS(500);
        this.attackDuration = Main.MILLIS_TO_TICKS(250);
        this.damageTakenTime = Main.MILLIS_TO_TICKS(100);
        this.damageTakenCounter = -1;
        this.shieldMax = 20.0;
        this.shieldReg = this.shieldMax / (double)Main.MILLIS_TO_TICKS(10000);
        this.shieldCurrent = this.shieldMax;
        this.usingShield = false;
        this.disconnected = false;
        this.spinCounter = 0;
        this.jumpSpeed = 0.2f;
        this.hasSpecialJump = true;
        this.stunTimer = 0;
        this.currentAnimation = animationState.STANDING;
        this.game = game;
        this.timeOn = timeOn;
        this.lives = stocks;
        this.respawn();
        ++this.lives;
        if (character == 3) {
            this.model = new GabenModel();
        } else if (character == 4) {
            this.model = new PacModel();
        } else if (character == 2) {
            this.model = new BirdieModel();
        } else if (character == 1) {
            this.model = new StickModel();
        } else if (character == 0) {
            this.model = new SteveModel();
        }
        this.w = this.model.getWidth();
        this.h = this.model.getHeight();
        this.hitBox = new Rect(0.0f, 0.0f, this.w, this.h);
    }

    public void render() {
        float tx = this.pos.x + this.w / 2.0f;
        float ty = this.pos.y + this.h - this.model.getTopHalfHeigth() + 0.1f;
        this.drawHeadingDeg = Math.abs(this.drawHeadingDeg) < 90.0f ? 0 : 180;
        GL11.glPushMatrix();
        GL11.glTranslatef(tx, ty, 0.0f);
        GL11.glRotatef(this.drawHeadingDeg, 0.0f, 1.0f, 0.0f);
        if (this.stunTimer > 0) {
            GL11.glRotatef((float)Math.toDegrees(Math.atan2(this.vel.y, this.vel.x)), 0.0f, 0.0f, 1.0f);
            float size = 0.2f;
            double a = 0.0;
            while (a <= 360.0) {
                double da = (double)System.currentTimeMillis() * 0.2 % 360.0;
                Vec3 center = new Vec3((float)(0.5 * Math.sin(Math.toRadians(a + da))), 1.0f, (float)(0.5 * Math.cos(Math.toRadians(a + da))));
                int i = 0;
                while (i < 20) {
                    double a1 = Math.random() * Math.PI * 2.0;
                    double a2 = Math.random() * Math.PI * 2.0;
                    double r = Math.random() * (double)size / 2.0;
                    float cr = (float)Math.random();
                    Vec3 col = new Vec3(cr, cr, 0.0f);
                    Vec3 out = new Vec3((float)(Math.sin(a1) * Math.sin(a2)), (float)(Math.cos(a1) * Math.sin(a2)), (float)Math.cos(a2));
                    out = out.multiply(size);
                    out = center.add(out);
                    Quad.renderQuad(center, center.add(new Vec3((float)(Math.random() * r), (float)(Math.random() * r * 0.1), (float)(Math.random() * r * 0.1))), out, out, col);
                    ++i;
                }
                a += 120.0;
            }
        }
        if (this.spinCounter > 0 && this.jumpsLeft == 0) {
            GL11.glRotatef(System.currentTimeMillis() % 360L, 0.0f, 1.0f, 0.0f);
        }
        this.model.render(this.item, this.item == null ? null : this.item.getLimb(), this.damageTakenCounter > 0);
        GL11.glPopMatrix();
        if (Settings.DEBUG_DRAW_PLAYER_HITBOX) {
            Box.renderBoxCorner(new Vec3(this.hitBox.x, this.hitBox.y, 0.0f), new Vec3(this.hitBox.w, this.hitBox.h, 0.1f), Vec3.RED);
        }
        if (Settings.DEBUG_DRAW_ATTACK_HITBOX && this.attack != null) {
            this.attack.drawHitbox();
        }
        if (this.attack != null) {
            this.attack.render();
        }
        if (this.usingShield) {
            float w = (float)(1.5 * (double)this.hitBox.w * this.shieldCurrent / this.shieldMax);
            float h = (float)(1.5 * (double)this.hitBox.h * this.shieldCurrent / this.shieldMax);
            Box.renderBox(new Vec3(this.hitBox.x + this.hitBox.w / 2.0f, this.hitBox.y + this.hitBox.h / 2.0f, 0.0f), new Vec3(w, h, w), Box.shield);
        }
    }

    public void simulate(int simulationTick, Network.ClientInformation ci) {
        --this.spinCounter;
        --this.stunTimer;
        --this.fireBallAnimationCounter;
        this.actionPerformed = false;
        this.calculateHeading(ci);
        boolean bl = this.usingShield = ci.SHIELD_DOWN && this.item == null && this.mapBlock != null;
        if (!this.usingShield) {
            this.shieldCurrent += this.shieldReg;
            this.shieldCurrent = Math.min(this.shieldMax, this.shieldCurrent);
        }
        this.simulateAnimation(simulationTick, ci);
        this.simulateMovement(simulationTick, ci);
        this.simulateItem(ci);
        this.simulateAttack(ci);
        int i = 0;
        while (i < this.buffs.size()) {
            this.buffs.get(i).update();
            if (this.buffs.get(i).shallBeRemoved()) {
                this.buffs.remove(i);
                --i;
            }
            ++i;
        }
        --this.damageTakenCounter;
        if (this.stunTimer > 0 && this.stunTimer % 10 == 0) {
            this.game.addEffect(new PlayerSmoke(this.pos.clone()));
        }
        if (Math.abs(Math.sqrt(this.pos.x * this.pos.x + this.pos.y * this.pos.y)) > 100.0) {
            this.respawn();
        }
    }

    private void calculateHeading(Network.ClientInformation ci) {
        int x = 0;
        boolean y = false;
        if (ci.LEFT_DOWN) {
            --x;
        }
        if (ci.RIGHT_DOWN) {
            ++x;
        }
        boolean cfr_ignored_0 = ci.UP_DOWN;
        boolean cfr_ignored_1 = ci.DOWN_DOWN;
        if (x == 0 && !y) {
            if (this.mapBlock != null) {
                this.headingDeg = this.drawHeadingDeg;
            }
        } else {
            this.headingDeg = (float)Math.toDegrees(Math.atan2((double)y, x));
        }
    }

    private void respawn() {
        --this.lives;
        this.pos = this.game.getMap().playerSpawn();
        this.vel = new Vec2();
        this.damageTaken = 0.0;
        this.item = null;
        this.usingShield = false;
        this.shieldCurrent = this.shieldMax;
        this.stunTimer = 0;
        this.fireBallAnimationCounter = 0;
        this.game.addEffect(new RespawnEffect(new Vec3(this.pos.x, this.pos.y, 0.0f)));
    }

    private void simulateAttack(Network.ClientInformation ci) {
        boolean swingableItem;
        if (this.mapBlock != null) {
            this.hasSpecialJump = true;
        }
        boolean bl = swingableItem = this.item == null || this.item.isSwingable();
        if (ci.PRIMARY_PRESSED && this.attackCounter < 0 && swingableItem && !this.usingShield && !this.actionPerformed) {
            this.attackCounter = this.timeBetweenAttacks;
            double attackHeadingDeg = this.headingDeg;
            double a = 30.0;
            if (Math.abs(attackHeadingDeg) < 90.0 && Math.abs(attackHeadingDeg) > a) {
                attackHeadingDeg = Math.signum(attackHeadingDeg) * a;
            } else if (Math.abs(attackHeadingDeg) <= 180.0 - a && Math.abs(attackHeadingDeg) >= 90.0) {
                attackHeadingDeg = Math.signum(attackHeadingDeg) * (180.0 - a);
            }
            this.attack = new MeleeAttack(this, attackHeadingDeg);
            if (this.item != null) {
                this.attack.damage = 20.0;
                this.item.swing();
            }
            this.actionPerformed = true;
        } else if (ci.SECONDARY_PRESSED && this.item == null && this.attack == null && !this.actionPerformed && this.attackCounter < 0) {
            if (ci.DOWN_DOWN) {
                if (!this.usingShield) {
                    this.attack = new DrillAttack(this);
                    this.attackCounter = this.timeBetweenAttacks;
                }
            } else if (ci.UP_DOWN && this.hasSpecialJump) {
                this.vel.y = this.jumpSpeed;
                this.attack = new HeadAttack(this);
                this.hasSpecialJump = false;
                this.attackCounter = this.timeBetweenAttacks;
            } else {
                this.game.addProjectile(new Fireball(this, this.game, this.headingDeg));
                this.fireBallAnimationCounter = Main.MILLIS_TO_TICKS(400);
                this.attackCounter = this.timeBetweenAttacks;
            }
            this.actionPerformed = true;
        }
        if (this.attack != null && this.attack.shallBeRemoved() || this.attackCounter < this.timeBetweenAttacks - this.attackDuration) {
            this.attack = null;
        }
        if (this.attack != null) {
            this.attack.update(this.game.getNonEliminatedPlayers());
            this.drawHeadingDeg = this.headingDeg;
        }
        --this.attackCounter;
    }

    private void simulateItem(Network.ClientInformation ci) {
        Item pickup;
        boolean itemPickedUp = false;
        if (ci.SECONDARY_PRESSED && this.item == null && !this.actionPerformed && (pickup = this.game.tryPickUpItem(this)) != null) {
            this.item = pickup;
            this.item.setPlayer(this);
            itemPickedUp = true;
            this.actionPerformed = true;
        }
        if (ci.SECONDARY_PRESSED && this.item != null && !itemPickedUp && this.item.canBeThrown() && !this.actionPerformed) {
            this.item.playerThrow(this.headingDeg);
            this.item.setPlayer(null);
            this.item = null;
            this.actionPerformed = true;
        }
        if (ci.PRIMARY_PRESSED && this.item != null && this.item.canBeUsed() && !this.actionPerformed) {
            this.item.playerUse();
            this.actionPerformed = true;
        }
        if (this.item != null && this.item.shallBeRemoved()) {
            this.item = null;
        }
    }

    private void simulateMovement(int simulationTick, Network.ClientInformation ci) {
        MapBlock mb;
        boolean canMove;
        boolean bl = canMove = this.stunTimer < 0;
        if (this.mapBlock != null) {
            this.pos.x += this.mapBlock.getDx();
            this.pos.y += this.mapBlock.getDy();
        }
        double speed = 0.075 * this.getBuffsSpeedMultiplier();
        int moveParts = 100;
        int i = 0;
        while (i < moveParts) {
            float oldX = this.pos.x;
            if (ci.LEFT_DOWN && !this.usingShield && canMove) {
                if ((double)this.vel.x > speed / (double)moveParts) {
                    this.vel.x = (float)((double)this.vel.x - speed / (double)moveParts);
                } else if ((double)this.vel.x > -speed / (double)moveParts) {
                    this.vel.x = 0.0f;
                    this.pos.x = (float)((double)this.pos.x - speed / (double)moveParts);
                }
                this.drawHeadingDeg = 180.0f;
            }
            if (ci.RIGHT_DOWN && !this.usingShield && canMove) {
                if ((double)this.vel.x < -speed / (double)moveParts) {
                    this.vel.x = (float)((double)this.vel.x + speed / (double)moveParts);
                } else if ((double)this.vel.x < speed / (double)moveParts) {
                    this.vel.x = 0.0f;
                    this.pos.x = (float)((double)this.pos.x + speed / (double)moveParts);
                }
                this.drawHeadingDeg = 0.0f;
            }
            this.pos.x += this.vel.x / (float)moveParts;
            this.hitBox.x = this.pos.x;
            this.hitBox.y = this.pos.y;
            MapBlock collision = this.game.getMap().collides(this);
            if (collision != null) {
                this.pos.x = oldX;
                this.vel.x = -this.vel.x;
                this.pos.x += collision.getDx() * 2.0f;
            }
            ++i;
        }
        if (ci.JUMP_PRESSED && this.jumpsLeft > 0 && !this.usingShield && canMove) {
            this.vel.y = this.jumpSpeed;
            --this.jumpsLeft;
            if (this.jumpsLeft <= 1) {
                this.spinCounter = Main.MILLIS_TO_TICKS(250);
            }
        }
        this.vel.y -= this.game.getGravity();
        boolean isOnAnyBlock = false;
        int i2 = 0;
        while (i2 < moveParts) {
            float oldY = this.pos.y;
            if (ci.DOWN_DOWN && (double)Math.abs(this.vel.y) < 0.1 && canMove) {
                this.pos.y = (float)((double)this.pos.y - speed / (double)moveParts);
            }
            this.pos.y += this.vel.y / (float)moveParts;
            this.hitBox.x = this.pos.x;
            this.hitBox.y = this.pos.y;
            MapBlock collision = this.game.getMap().collides(this);
            if (collision != null) {
                isOnAnyBlock = true;
                this.pos.y = oldY;
                if (this.vel.y < 0.0f) {
                    this.jumpsLeft = this.maxJumps;
                    this.mapBlock = collision;
                } else {
                    float dy = collision.getDy();
                    if (dy < 0.0f) {
                        this.pos.y -= -dy * 3.0f;
                    }
                }
                this.vel.y = 0.0f;
            }
            ++i2;
        }
        if (this.mapBlock != null) {
            this.vel.x *= 0.9f;
        }
        if (this.mapBlock != null && this.mapBlock.isPlatform() && ci.DOWN_PRESSED && !this.usingShield) {
            this.mapBlockDown = this.mapBlock;
        }
        if ((mb = this.game.getMap().collides(this)) != null && this.pos.y >= mb.getHitRect().y && this.mapBlock != null) {
            this.pos.y = this.mapBlock.getHitRect().y + this.mapBlock.getHitRect().h + 0.01f;
        }
        if (!isOnAnyBlock) {
            this.mapBlock = null;
        }
        if (this.mapBlockDown != null && !this.mapBlockDown.getHitRect().intersects(this.getCollisionRect())) {
            this.mapBlockDown = null;
        }
    }

    private double getBuffsSpeedMultiplier() {
        double m = 1.0;
        for (Buff b : this.buffs) {
            m *= b.getSpeedMultiplier();
        }
        return m;
    }

    private void simulateAnimation(int simulationTick, Network.ClientInformation ci) {
        boolean anyAnimation = false;
        if ((ci.LEFT_DOWN || ci.RIGHT_DOWN) && this.jumpsLeft == this.maxJumps && !this.usingShield) {
            this.model.walkAnimation(simulationTick);
            anyAnimation = true;
        }
        if (this.attackCounter >= 0 && this.attack != null && this.attack instanceof MeleeAttack) {
            this.model.punchAnimation(simulationTick, this);
            anyAnimation = true;
            if (this.attackCounter == this.timeBetweenAttacks - 1) {
                this.model.setAnimationStartTick(simulationTick);
            }
            this.currentAnimation = animationState.PUNCHING;
        } else if (!this.isOnGround()) {
            this.model.jumpAnimation(simulationTick);
            anyAnimation = true;
        }
        if (this.usingShield) {
            this.model.reset();
            this.model.shieldAnimation(simulationTick);
            anyAnimation = true;
        }
        if (this.item != null && this.item instanceof Rifle) {
            this.model.rifleAnimation(simulationTick);
            anyAnimation = true;
        }
        if (this.fireBallAnimationCounter > 0) {
            this.model.fireBallAnimation(simulationTick);
            anyAnimation = true;
        }
        if (!anyAnimation) {
            this.model.reset();
        }
    }

    @Override
    public Rect getCollisionRect() {
        return this.hitBox;
    }

    public Vec2 getPosition() {
        return this.pos;
    }

    public double getDamageTaken() {
        return this.damageTaken;
    }

    public void heal(int heal) {
        this.damageTaken -= (double)heal;
        if (this.damageTaken < 0.0) {
            this.damageTaken = 0.0;
        }
    }

    public void takeDamage(double damage, Entity damageSource) {
        this.takeDamage(damage, damageSource.getPos());
        if (damageSource instanceof Item && ((Item)damageSource).canActivateVemKasta()) {
            this.game.tryPlayVemKasta();
        }
    }

    public void takeDamage(double damage, Vec2 damageSource) {
        if (this.usingShield) {
            if (this.shieldCurrent > damage) {
                this.shieldCurrent -= damage;
            } else {
                this.shieldCurrent = 0.0;
                this.usingShield = false;
                this.takeDamageEffect(damage - this.shieldCurrent + 20.0, damageSource);
            }
        } else {
            this.takeDamageEffect(damage, damageSource);
        }
    }

    private void takeDamageEffect(double damage, Vec2 damageSource) {
        this.damageTaken += damage;
        double dx = this.pos.x - damageSource.x;
        double dy = this.pos.y - damageSource.y;
        double a = Math.atan2(dy, dx);
        double s = this.damageTaken * damage * (double)2.5E-4f;
        if (this.damageTaken * damage > 1000.0) {
            this.stunTimer = Main.MILLIS_TO_TICKS((int)(this.damageTaken * damage));
        }
        this.vel.x = (float)((double)this.vel.x + Math.cos(a) * s);
        this.vel.y = (float)((double)this.vel.y + Math.sin(a) * s);
        if ((double)this.vel.y < 0.1) {
            this.vel.y = (float)((double)this.vel.y + s);
        }
        this.damageTakenCounter = this.damageTakenTime;
        Main.SOUND.play(Sound.OUCH);
    }

    public int getLives() {
        return this.lives;
    }

    public void addVel(float x, float y) {
        this.vel.x += x;
        this.vel.y += y;
    }

    public boolean isEnemyTo(Player player) {
        if (player == this) {
            return false;
        }
        if (this.team == 0 || player.getTeam() == 0) {
            return true;
        }
        return this.team != player.getTeam();
    }

    private int getTeam() {
        return this.team;
    }

    public void addBuff(Buff buff) {
        this.buffs.add(buff);
    }

    public double getHeadingDeg() {
        return this.headingDeg;
    }

    public boolean isOnGround() {
        return this.mapBlock != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEliminated() {
        if (this.disconnected) {
            return true;
        }
        if (this.timeOn) {
            return false;
        }
        return this.lives <= 0;
    }

    public void disconnect() {
        this.disconnected = true;
    }

    public boolean hasDisconnected() {
        return this.disconnected;
    }

    public Vec2 getCenter() {
        return new Vec2(this.pos.x + this.hitBox.w / 2.0f, this.pos.y + this.hitBox.h / 2.0f);
    }

    public double getTakingDamagePercent() {
        if (this.damageTakenCounter < 0) {
            return 0.0;
        }
        return (double)this.damageTakenCounter / (double)(10 + this.damageTakenTime);
    }

    public Model getModel() {
        return this.model;
    }

    private static enum animationState {
        STANDING,
        WALKING,
        PUNCHING,
        FALLING;

    }
}

