/*
 * Decompiled with CFR 0.152.
 */
package game.main;

import game.figureRender.Box;
import game.figureRender.Quad;
import game.main.Camera;
import game.main.Game;
import game.main.Main;
import game.main.Player;
import game.sound.Sound;
import game.util.Vec3;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public class WinnerScreen {
    private ArrayList<Firework> fireworks = new ArrayList();
    private ArrayList<Particle> particles = new ArrayList();
    private int tick = -1;
    private Camera camera;
    private Game game;
    private Vec3[] COLORS = new Vec3[]{new Vec3(0.8f, 0.4f, 0.9f), new Vec3(0.8f, 0.9f, 0.3f)};

    public WinnerScreen(Camera camera, Game game) {
        this.game = game;
        this.camera = camera;
    }

    public void update() {
        int i;
        this.camera.pos = new Vec3(0.0f, 2.0f, 0.0f);
        this.camera.rot = new Vec3();
        ++this.tick;
        if (this.tick == 60) {
            i = 0;
            while (i < 4) {
                this.fireworks.add(new Firework(new Vec3(i * 10 - 20, 0.0f, -100.0f), new Vec3(0.0f, 0.3f, 0.0f), 1, i == 0));
                ++i;
            }
        } else if (this.tick == 0) {
            i = 0;
            while (i < 3) {
                this.fireworks.add(new Firework(new Vec3(i * 10 - 15, 0.0f, -100.0f), new Vec3(0.0f, 0.25f, 0.0f), 0, i == 0));
                ++i;
            }
        } else if (this.tick == 120) {
            i = 0;
            while (i < 5) {
                this.fireworks.add(new Firework(new Vec3(i * 10 - 25, 0.0f, -100.0f), new Vec3(0.0f, 0.4f, 0.0f), 2, i == 0));
                ++i;
            }
        }
        for (Firework f : this.fireworks) {
            f.update();
        }
        for (Particle p : this.particles) {
            p.update();
        }
        int i2 = 0;
        while (i2 < this.fireworks.size()) {
            if (this.fireworks.get((int)i2).shallBeRemoved) {
                this.fireworks.remove(i2);
                --i2;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.particles.size()) {
            if (this.particles.get((int)i2).shallBeRemoved) {
                this.particles.remove(i2);
                --i2;
            }
            ++i2;
        }
    }

    public void render(ArrayList<Player> winners, ArrayList<Player> losers) {
        for (Firework f : this.fireworks) {
            f.render();
        }
        for (Particle p : this.particles) {
            p.render();
        }
        int r = 100;
        int s = 3;
        int x = -r;
        while (x < r) {
            int z = -r;
            while (z < r) {
                Quad.renderQuad(new Vec3(x, 0.1f, z), new Vec3(x + s, 0.1f, z), new Vec3(x + s, 0.1f, z + s), new Vec3(x, 0.1f, z + s), this.COLORS[(x + z + 9999999) % this.COLORS.length]);
                z += s;
            }
            x += s;
        }
        Quad.renderQuad(new Vec3(-300.0f, 300.0f, -100.0f), new Vec3(300.0f, 300.0f, -100.0f), new Vec3(300.0f, -100.0f, -200.0f), new Vec3(-300.0f, -100.0f, -100.0f), Box.sky);
        Player[] players = this.game.getAllPlayers();
        int i = 0;
        while (i < players.length) {
            Player p2;
            boolean winner = false;
            for (Player p2 : winners) {
                if (p2 != players[i]) continue;
                winner = true;
            }
            p2 = players[i];
            GL11.glPushMatrix();
            float dx = 2.0f;
            float y = 2.0f + (winner ? Math.min(2.0f, (float)this.tick * 0.02f) : 0.0f);
            float x2 = (float)i * dx - (float)(players.length - 1) * 0.5f * dx;
            if (winner) {
                Box.renderBoxCorner(new Vec3(x2 - 0.5f, 0.0f, -10.0f), new Vec3(1.0f, y - 2.0f + 0.1f, 1.0f), Vec3.GRAY, new int[]{Box.prisPall, Box.prisPall, Box.prisPall, Box.prisPall, Box.prisPall, Box.prisPall});
            }
            GL11.glTranslatef(x2, y, -10.0f);
            GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
            p2.getModel().reset();
            p2.getModel().render(null, null, false);
            GL11.glPopMatrix();
            ++i;
        }
    }

    class Firework {
        Vec3 pos;
        Vec3 vel;
        int tick;
        boolean shallBeRemoved = false;
        int type;
        boolean playSound;

        public Firework(Vec3 p, Vec3 v, int t, boolean playSound) {
            this.pos = p;
            this.vel = v;
            this.type = t;
            this.playSound = playSound;
        }

        public void update() {
            this.pos = this.pos.add(this.vel);
            ++this.tick;
            int cfr_ignored_0 = this.tick % 5;
            if (this.tick >= 50) {
                Vec3 vel;
                double a2;
                double a1;
                float speed2;
                float speed1;
                Vec3 col2;
                Vec3 col1;
                if (this.playSound) {
                    Main.SOUND.play(Sound.FIREWORKS);
                }
                if (this.type == 0) {
                    col1 = Vec3.GREEN;
                    col2 = Vec3.YELLOW;
                    speed1 = 0.2f;
                    speed2 = 0.15f;
                } else if (this.type == 1) {
                    col1 = new Vec3(1.0f, 0.5f, 0.0f);
                    col2 = Vec3.RED;
                    speed1 = 0.3f;
                    speed2 = 0.2f;
                } else {
                    col1 = new Vec3(1.0f, 0.5f, 1.0f);
                    col2 = new Vec3(0.9f, 0.7f, 0.9f);
                    speed1 = 0.3f;
                    speed2 = 0.2f;
                }
                int i = 0;
                while (i < 500) {
                    a1 = Math.random() * Math.PI * 2.0;
                    a2 = Math.random() * Math.PI * 2.0;
                    vel = new Vec3((float)(Math.sin(a1) * Math.sin(a2)), (float)(Math.cos(a1) * Math.sin(a2)), (float)Math.cos(a2));
                    vel = vel.multiply(speed1);
                    WinnerScreen.this.particles.add(new Particle(this.pos.clone(), vel, col1));
                    ++i;
                }
                i = 0;
                while (i < 500) {
                    a1 = Math.random() * Math.PI * 2.0;
                    a2 = Math.random() * Math.PI * 2.0;
                    vel = new Vec3((float)(Math.sin(a1) * Math.sin(a2)), (float)(Math.cos(a1) * Math.sin(a2)), (float)Math.cos(a2));
                    vel = vel.multiply(speed2);
                    WinnerScreen.this.particles.add(new Particle(this.pos.clone(), vel, col2));
                    ++i;
                }
                this.shallBeRemoved = true;
            }
        }

        public void render() {
        }
    }

    class Particle {
        Vec3 pos;
        Vec3 vel;
        Vec3 col;
        boolean shallBeRemoved = false;
        int tick = 0;

        public Particle(Vec3 p, Vec3 v, Vec3 c) {
            this.pos = p;
            this.vel = v;
            this.col = c;
        }

        public void update() {
            this.pos = this.pos.add(this.vel);
            ++this.tick;
            if (this.tick >= 20 && Math.random() > 0.9 || this.tick >= 60) {
                this.shallBeRemoved = true;
            }
        }

        public void render() {
            Box.renderBox(this.pos, new Vec3(0.2f), this.col);
        }
    }
}

