/*
 * Decompiled with CFR 0.152.
 */
package game.map;

import game.figureRender.Box;
import game.figureRender.Quad;
import game.main.Main;
import game.map.Cube;
import game.util.Vec3;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public class Demo {
    ArrayList<Cube> cubes = new ArrayList();
    int state = 0;
    Vec3 cpos = new Vec3();
    Vec3 crot = new Vec3();
    int prevState;
    double a = 0.0;
    double da = 0.0075;
    double r = 5.0;
    int s = 30;
    float[][] h = new float[this.s][this.s];
    boolean[][] gol = new boolean[this.s][this.s];

    public Demo() {
        int i = 0;
        while (i < 300) {
            Vec3 pos = new Vec3((float)i * 0.01f, 0.0f, (float)Math.random());
            this.cubes.add(new Cube(pos));
            ++i;
        }
    }

    public void simulate(int simulationTick) {
        this.state = simulationTick % Main.MILLIS_TO_TICKS(20000) < Main.MILLIS_TO_TICKS(10000) ? 0 : 1;
        if (this.state != this.prevState) {
            this.cpos = new Vec3();
            this.crot = new Vec3();
            if (this.state == 1) {
                int x = 0;
                while (x < this.gol.length) {
                    int z = 0;
                    while (z < this.gol[x].length) {
                        this.gol[x][z] = Math.random() > 0.7;
                        ++z;
                    }
                    ++x;
                }
            }
        }
        this.prevState = this.state;
        if (this.state == 0) {
            this.crot.z = (float)((double)this.crot.z + 0.25);
            this.cpos.x = (float)(0.0 + Math.sin((double)simulationTick * 0.005) * 4.0);
            this.cpos.y = (float)(0.0 + Math.sin((double)simulationTick * 0.0025) * 2.0);
            this.cpos.z = (float)(12.0 + Math.sin((double)simulationTick * 0.01) * 5.0);
            this.a += (double)0.01f;
            int i = 0;
            while (i < this.cubes.size()) {
                this.cubes.get((int)i).pos.x = (float)(Math.sin(this.a + this.da * (double)i) * this.r);
                this.cubes.get((int)i).pos.z = (float)(Math.cos(this.a + this.da * (double)i) * this.r);
                this.cubes.get((int)i).pos.y = (float)Math.sin(this.cubes.get((int)i).pos.x);
                ++i;
            }
        } else if (this.state == 1) {
            this.crot.x = -40.0f;
            this.cpos.y = -15.0f;
            double a = (float)simulationTick * 0.01f;
            this.crot.y = -((float)Math.toDegrees(a));
            this.cpos.x = (float)(Math.sin(a) * 30.0);
            this.cpos.z = (float)(Math.cos(a) * 30.0);
            int x = 0;
            while (x < this.h.length) {
                int z = 0;
                while (z < this.h[x].length) {
                    this.h[x][z] = (float)(Math.sin((double)((x + z) * 3 + simulationTick) * 0.1) * 0.5);
                    ++z;
                }
                ++x;
            }
            if (simulationTick % 10 == 0) {
                boolean[][] ngol = new boolean[this.s][this.s];
                int x2 = 0;
                while (x2 < this.gol.length) {
                    int z = 0;
                    while (z < this.gol[x2].length) {
                        int n = 0;
                        n += this.isOn(x2 - 1, z - 1);
                        n += this.isOn(x2, z - 1);
                        n += this.isOn(x2 + 1, z - 1);
                        n += this.isOn(x2 - 1, z);
                        n += this.isOn(x2 + 1, z);
                        n += this.isOn(x2 - 1, z + 1);
                        n += this.isOn(x2, z + 1);
                        if ((n += this.isOn(x2 + 1, z + 1)) < 2) {
                            ngol[x2][z] = false;
                        }
                        if (n == 3) {
                            ngol[x2][z] = true;
                        }
                        if (n == 2 && this.gol[x2][z]) {
                            ngol[x2][z] = true;
                        }
                        ++z;
                    }
                    ++x2;
                }
                this.gol = ngol;
            }
        }
    }

    private int isOn(int x, int z) {
        if (x < 0 || z < 0 || x >= this.s || z >= this.s) {
            return 0;
        }
        return this.gol[x][z] ? 1 : 0;
    }

    public void render() {
        if (this.state == 0) {
            GL11.glPushMatrix();
            GL11.glTranslatef(-this.cpos.x, -this.cpos.y, -this.cpos.z);
            GL11.glRotatef(this.crot.x, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(this.crot.y, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(this.crot.z, 0.0f, 0.0f, 1.0f);
            int tex = Box.demoSky;
            Box.renderBox(new Vec3(), new Vec3(100.0f), Vec3.RED, new int[]{tex, tex, tex, tex, tex, tex});
            int i = 0;
            while (i < this.cubes.size()) {
                this.cubes.get(i).render();
                ++i;
            }
            GL11.glPopMatrix();
        } else if (this.state == 1) {
            GL11.glPushMatrix();
            GL11.glRotatef(this.crot.x, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(this.crot.y, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(this.crot.z, 0.0f, 0.0f, 1.0f);
            GL11.glTranslatef(-this.cpos.x, -this.cpos.y, -this.cpos.z);
            int tex = Box.demoSky;
            Box.renderBox(new Vec3(), new Vec3(100.0f), Vec3.RED, new int[]{tex, tex, tex, tex, tex, tex});
            GL11.glPushMatrix();
            GL11.glTranslatef(-this.s / 2, 0.0f, -this.s / 2);
            int x = 0;
            while (x < this.s - 1) {
                int z = 0;
                while (z < this.s - 1) {
                    Quad.renderQuad(new Vec3(x, this.h[x][z], z), new Vec3((float)x + 0.9f, this.h[x + 1][z], z), new Vec3((float)x + 0.9f, this.h[x + 1][z + 1], (float)z + 0.9f), new Vec3(x, this.h[x][z + 1], (float)z + 0.9f), this.gol[x][z] ? Vec3.BLACK : Vec3.BLUE);
                    ++z;
                }
                ++x;
            }
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }
}

