/*
 * Decompiled with CFR 0.152.
 */
package game.map;

import game.figureRender.Box;
import game.main.Entity;
import game.main.Game;
import game.main.Main;
import game.map.MapBlock;
import game.map.MapPart;
import game.map.TestPart;
import game.map.events.Datortrash;
import game.map.events.Event;
import game.map.events.JoltEvent;
import game.util.Settings;
import game.util.Vec2;
import game.util.Vec3;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public class GameMap {
    protected ArrayList<MapPart> mapParts = new ArrayList();
    protected ArrayList<Vec2> playerSpawns;
    protected int nextPlayerSpawn = 0;
    protected int ticksForAllEvents = Main.MILLIS_TO_TICKS(120000);
    protected int ticksBetweenEvents;
    protected int ticksBetweenEventsCounter;
    protected int currentEventI = 0;
    protected Event currentEvent;
    protected ArrayList<Event> events = new ArrayList();
    protected Game game;
    protected boolean eventsOn;
    private ArrayList<Vec3> initPlanetPos = new ArrayList();
    private ArrayList<Vec3> initPlanetRotAxis = new ArrayList();
    int c = 0;
    private static Vec3[] COLORS = new Vec3[]{new Vec3(0.0f, 0.0f, 0.18f), new Vec3(0.0f, 0.0f, 0.19f), new Vec3(0.0f, 0.0f, 0.2f), new Vec3(0.0f, 0.0f, 0.21f), new Vec3(0.0f, 0.0f, 0.22f)};

    public GameMap(Game game, boolean eventsOn) {
        this.game = game;
        this.mapParts.add(new TestPart(0, 0, game));
        this.eventsOn = eventsOn;
        this.createSpawns();
        this.createEvents();
        this.initPlanets();
    }

    private void createSpawns() {
        this.playerSpawns = new ArrayList();
        this.playerSpawns.add(new Vec2(-8.0f, 0.0f));
        this.playerSpawns.add(new Vec2(-2.0f, 5.0f));
        this.playerSpawns.add(new Vec2(3.0f, 0.0f));
        this.playerSpawns.add(new Vec2(9.0f, 0.0f));
    }

    private void createEvents() {
        this.events.add(new JoltEvent(this.game));
        this.events.add(new Datortrash(this.game));
        int sum = 0;
        for (Event e : this.events) {
            sum += e.getDuration();
        }
        this.ticksBetweenEventsCounter = this.ticksBetweenEvents = (this.ticksForAllEvents - sum) / this.events.size();
        if (sum > this.ticksForAllEvents) {
            System.err.println("Tiden f\u00f6r alla events \u00e4r st\u00f6rre \u00e4n den \u00f6nskade tiden");
        }
        if (Settings.DEBUG_START_EVENTS_DIRECTLY) {
            this.currentEvent = this.events.get(0);
            this.currentEvent.restart();
            this.currentEventI = 0;
        }
    }

    public void simulate(int simulationTick) {
        for (MapPart mp : this.mapParts) {
            mp.simulate(simulationTick);
        }
        if (this.eventsOn) {
            --this.ticksBetweenEventsCounter;
            if (this.ticksBetweenEventsCounter < 0 && this.currentEvent == null) {
                this.currentEvent = this.events.get(this.currentEventI);
                this.currentEvent.restart();
            }
            if (this.currentEvent != null) {
                this.currentEvent.simulate();
                if (this.currentEvent.isFinished()) {
                    this.currentEvent = null;
                    ++this.currentEventI;
                    this.currentEventI %= this.events.size();
                    this.ticksBetweenEventsCounter = this.ticksBetweenEvents;
                }
            }
        }
    }

    public void initPlanets() {
        int i = 0;
        while (i < 100) {
            double a1 = Math.random() * Math.PI * 2.0;
            double a2 = Math.random() * Math.PI * 2.0;
            Vec3 pos = new Vec3((float)(Math.sin(a1) * Math.sin(a2)), (float)(Math.cos(a1) * Math.sin(a2)), (float)Math.cos(a2));
            pos = pos.multiply((float)(Math.random() * 25.0 + 25.0));
            this.initPlanetPos.add(pos);
            float vz = (float)Math.random() * 2.0f - 1.0f;
            float vy = (float)Math.random() * 2.0f - 1.0f;
            float vx = -(vy * pos.y + vz * pos.z) / pos.x;
            Vec3 vel = new Vec3(vx, vy, vz);
            Vec3 axis = pos.cross(vel);
            this.initPlanetRotAxis.add(axis);
            ++i;
        }
    }

    public void render() {
        ++this.c;
        Box.renderBox(new Vec3(0.0f), new Vec3(2000.0f), new Vec3(0.1f, 0.2f, 0.8f), new int[]{Box.sky, Box.sky, Box.sky, Box.sky, Box.sky, Box.sky});
        int i = 0;
        while (i < this.initPlanetPos.size()) {
            Vec3 pos = this.initPlanetPos.get(i);
            Vec3 axis = this.initPlanetRotAxis.get(i);
            GL11.glPushMatrix();
            GL11.glRotatef((float)this.c / 10.0f, axis.x, axis.y, axis.z);
            GL11.glTranslatef(pos.x, pos.y, pos.z);
            Box.renderBox(new Vec3(0.0f, 0.0f, 0.0f), new Vec3(0.1f), Vec3.WHITE);
            GL11.glPopMatrix();
            ++i;
        }
        for (MapPart mp : this.mapParts) {
            mp.render();
        }
        if (this.currentEvent != null) {
            this.currentEvent.render();
        }
    }

    public MapBlock collides(Entity entity) {
        for (MapPart mp : this.mapParts) {
            MapBlock mb = mp.collides(entity);
            if (mb == null) continue;
            return mb;
        }
        return null;
    }

    public MapBlock intersects(Entity entity) {
        for (MapPart mp : this.mapParts) {
            MapBlock mb = mp.intersects(entity);
            if (mb == null) continue;
            return mb;
        }
        return null;
    }

    public double getBlockMinX() {
        double min = Double.MAX_VALUE;
        for (MapPart mp : this.mapParts) {
            min = Math.min(mp.getBlockMinX(), min);
        }
        return min;
    }

    public double getBlockMaxX() {
        double max = -1.7976931348623157E308;
        for (MapPart mp : this.mapParts) {
            max = Math.max(mp.getBlockMaxX(), max);
        }
        return max;
    }

    public Vec2 playerSpawn() {
        Vec2 ps = this.playerSpawns.get(this.nextPlayerSpawn);
        ++this.nextPlayerSpawn;
        this.nextPlayerSpawn %= this.playerSpawns.size();
        return ps.clone();
    }

    public Event getCurrentEvent() {
        return this.currentEvent;
    }
}

