/*
 * Decompiled with CFR 0.152.
 */
package game.map;

import game.figureRender.Box;
import game.main.Entity;
import game.util.Rect;
import game.util.Vec3;

public class MapBlock {
    protected Rect hitRect;
    protected Rect prevHitRect;
    protected final Rect startHitRect;
    protected float dx;
    protected float dy;
    protected boolean platform;

    public MapBlock(float x, float y, float w, float h, boolean platform) {
        this.hitRect = new Rect(x, y, w, h);
        this.prevHitRect = new Rect(x, y, w, h);
        this.startHitRect = new Rect(x, y, w, h);
        this.platform = platform;
    }

    public void simulate(int simulationTick) {
        this.prevHitRect = this.hitRect.clone();
    }

    public Rect getHitRect() {
        return this.hitRect;
    }

    public void render() {
        Rect r = this.getHitRect();
        Box.renderBoxCorner(new Vec3(r.x, r.y, -2.0f), new Vec3(r.w, r.h, 4.0f), Vec3.BROWN);
    }

    public float getDx() {
        return this.hitRect.x - this.prevHitRect.x;
    }

    public float getDy() {
        return this.hitRect.y - this.prevHitRect.y;
    }

    public boolean collides(Entity entity, int posx, int posy) {
        Rect transRect = new Rect(this.hitRect.x + (float)posx, this.hitRect.y + (float)posy, this.hitRect.w, this.hitRect.h);
        if (!this.platform) {
            return transRect.intersects(entity.getCollisionRect());
        }
        if (entity.getVel().y > 0.0f) {
            return false;
        }
        if (entity.getMapBlockDown() == this) {
            return false;
        }
        Rect er = entity.getCollisionRect();
        return transRect.intersects(entity.getCollisionRect()) && er.y >= transRect.y;
    }

    public boolean intersects(Entity entity, int posx, int posy) {
        Rect transRect = new Rect(this.hitRect.x + (float)posx, this.hitRect.y + (float)posy, this.hitRect.w, this.hitRect.h);
        return transRect.intersects(entity.getCollisionRect());
    }

    public boolean isPlatform() {
        return this.platform;
    }
}

