/*
 * Decompiled with CFR 0.152.
 */
package game.map;

import game.main.Entity;
import game.map.MapBlock;
import java.util.ArrayList;

public abstract class MapPart {
    protected int posx;
    protected int posy;
    protected ArrayList<MapBlock> mapBlocks = new ArrayList();

    public MapPart(int posx, int posy) {
        this.posx = posx;
        this.posy = posy;
    }

    public void render() {
        for (MapBlock mb : this.mapBlocks) {
            mb.render();
        }
    }

    public void simulate(int simulationTick) {
        for (MapBlock mp : this.mapBlocks) {
            mp.simulate(simulationTick);
        }
    }

    public MapBlock collides(Entity entity) {
        for (MapBlock mb : this.mapBlocks) {
            if (!mb.collides(entity, this.posx, this.posy)) continue;
            return mb;
        }
        return null;
    }

    public MapBlock intersects(Entity entity) {
        for (MapBlock mb : this.mapBlocks) {
            if (!mb.intersects(entity, this.posx, this.posy)) continue;
            return mb;
        }
        return null;
    }

    public double getBlockMinX() {
        double min = Double.MAX_VALUE;
        for (MapBlock mb : this.mapBlocks) {
            min = Math.min((double)(mb.getHitRect().x + (float)this.posx), min);
        }
        return min;
    }

    public double getBlockMaxX() {
        double max = -1.7976931348623157E308;
        for (MapBlock mb : this.mapBlocks) {
            max = Math.max((double)(mb.getHitRect().x + mb.getHitRect().w + (float)this.posx), max);
        }
        return max;
    }
}

