/*
 * Decompiled with CFR 0.152.
 */
package game.map;

import game.figureRender.Box;
import game.figureRender.Quad;
import game.main.Game;
import game.main.Main;
import game.map.Demo;
import game.map.MapBlock;
import game.map.MapPart;
import game.map.events.Datortrash;
import game.map.events.Event;
import game.map.events.JoltEvent;
import game.obj.OBJExtractor;
import game.util.Rect;
import game.util.Vec3;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class TestPart
extends MapPart {
    public TestPart(int posx, int posy, final Game game) {
        super(posx, posy);
        this.mapBlocks.add(new MapBlock(-10.0f, -7.0f, 20.0f, 2.0f, false){
            OBJExtractor.OBJ arcade;
            OBJExtractor.OBJ speaker;
            boolean initDone;
            int colorTextureID;
            int framebufferID;
            int depthRenderBufferID;
            Demo demo;
            int tick;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                this.arcade = new OBJExtractor().loadModel("arcade.obj");
                this.speaker = new OBJExtractor().loadModel("speaker.obj");
                this.initDone = false;
                this.demo = new Demo();
                this.tick = 0;
            }

            @Override
            public void simulate(int simulationTick) {
                this.demo.simulate(simulationTick);
                ++this.tick;
            }

            @Override
            public void render() {
                Vec3 botLeft;
                Vec3 col;
                int texture;
                Vec3 botRight;
                Vec3 topRight;
                Vec3 topLeft;
                Vec3 botLeft2;
                Vec3 botRight2;
                Vec3 topRight2;
                Vec3 topLeft2;
                Rect r = this.getHitRect();
                Box.renderBoxCorner(new Vec3(r.x, r.y, -6.0f), new Vec3(r.w, r.h - 0.25f, 8.0f), new Vec3(0.4f, 0.4f, 0.4f), new int[]{-1, -1, -1, -1, -1, -1});
                Box.renderBoxCorner(new Vec3(r.x, r.y + r.h - 0.25f, -1.0f), new Vec3(r.w, 0.25f, 2.0f), new Vec3(0.4f, 0.3f, 0.5f));
                Box.renderBoxCorner(new Vec3(r.x + 5.0f + 2.0f, r.y + r.h - 0.25f, -6.0f), new Vec3(r.w - 10.0f, 1.0f, 2.0f), new Vec3(0.3f));
                if (!GLContext.getCapabilities().GL_EXT_framebuffer_object) {
                    System.out.println("No FBO support! (render to texture)");
                }
                if (!this.initDone) {
                    this.framebufferID = EXTFramebufferObject.glGenFramebuffersEXT();
                    this.colorTextureID = GL11.glGenTextures();
                    this.depthRenderBufferID = EXTFramebufferObject.glGenRenderbuffersEXT();
                    EXTFramebufferObject.glBindFramebufferEXT(36160, this.framebufferID);
                    GL11.glBindTexture(3553, this.colorTextureID);
                    GL11.glTexParameterf(3553, 10241, 9729.0f);
                    GL11.glTexImage2D(3553, 0, 32856, 512, 512, 0, 6408, 5124, null);
                    EXTFramebufferObject.glFramebufferTexture2DEXT(36160, 36064, 3553, this.colorTextureID, 0);
                    EXTFramebufferObject.glBindRenderbufferEXT(36161, this.depthRenderBufferID);
                    EXTFramebufferObject.glRenderbufferStorageEXT(36161, 33190, 512, 512);
                    EXTFramebufferObject.glFramebufferRenderbufferEXT(36160, 36096, 36161, this.depthRenderBufferID);
                    EXTFramebufferObject.glBindFramebufferEXT(36160, 0);
                    this.initDone = true;
                }
                GL11.glPushMatrix();
                float ar = (float)Main.width / (float)Main.height;
                GL11.glViewport((int)(-(ar - 1.0f) * 256.0f), 0, (int)(512.0f * ar), 512);
                GL11.glBindTexture(3553, 0);
                EXTFramebufferObject.glBindFramebufferEXT(36160, this.framebufferID);
                GL11.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                GL11.glClear(16640);
                GL11.glLoadIdentity();
                this.demo.render();
                GL11.glPopMatrix();
                GL11.glEnable(3553);
                EXTFramebufferObject.glBindFramebufferEXT(36160, 0);
                GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                GL11.glEnable(3042);
                GL11.glBlendFunc(770, 771);
                GL11.glViewport(0, 0, Main.width, Main.height);
                GL11.glEnable(3553);
                float z = -6.0f;
                float x = r.x + 6.0f + 2.0f;
                float y = r.y + r.h - 0.25f + 1.0f + 0.5f;
                float w = r.w - 12.0f;
                float h = 5.0f;
                int tex = -1;
                Event e = game.getMap().getCurrentEvent();
                if (e == null) {
                    tex = this.tick < Main.MILLIS_TO_TICKS(10000) ? Box.kontroller : this.colorTextureID;
                } else if (e instanceof JoltEvent) {
                    tex = Box.joltScreen;
                } else if (e instanceof Datortrash) {
                    tex = Box.datortrashScreen;
                }
                Quad.renderQuad(new Vec3(x, y + h, z), new Vec3(x + w, y + h, z), new Vec3(x + w, y, z), new Vec3(x, y, z), tex);
                GL11.glPushMatrix();
                GL11.glTranslatef(r.x + 4.0f + 2.0f, r.y + 1.5f, -5.0f);
                float scaleSpeaker = 80.0f;
                int i = 0;
                while (i < this.speaker.faces.size()) {
                    topLeft2 = this.speaker.vecs.get(this.speaker.faces.get(i).get(0) - 1);
                    topRight2 = this.speaker.vecs.get(this.speaker.faces.get(i).get(1) - 1);
                    botRight2 = this.speaker.vecs.get(this.speaker.faces.get(i).get(2) - 1);
                    topLeft2 = topLeft2.multiply(scaleSpeaker);
                    topRight2 = topRight2.multiply(scaleSpeaker);
                    botRight2 = botRight2.multiply(scaleSpeaker);
                    if (this.speaker.faces.get(i).size() == 4) {
                        botLeft2 = this.speaker.vecs.get(this.speaker.faces.get(i).get(3) - 1);
                        botLeft2 = botLeft2.multiply(scaleSpeaker);
                        if (i == 1 || i == 11) {
                            Quad.renderQuad(topLeft2, topRight2, botRight2, botLeft2, Box.speakerMid);
                        } else {
                            Quad.renderQuad(topLeft2, topRight2, botRight2, botLeft2, Box.speakerMain);
                        }
                    }
                    ++i;
                }
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef(r.x + 16.0f + 2.0f, r.y + 1.5f, -5.0f);
                i = 0;
                while (i < this.speaker.faces.size()) {
                    topLeft2 = this.speaker.vecs.get(this.speaker.faces.get(i).get(0) - 1);
                    topRight2 = this.speaker.vecs.get(this.speaker.faces.get(i).get(1) - 1);
                    botRight2 = this.speaker.vecs.get(this.speaker.faces.get(i).get(2) - 1);
                    topLeft2 = topLeft2.multiply(scaleSpeaker);
                    topRight2 = topRight2.multiply(scaleSpeaker);
                    botRight2 = botRight2.multiply(scaleSpeaker);
                    if (this.speaker.faces.get(i).size() == 4) {
                        botLeft2 = this.speaker.vecs.get(this.speaker.faces.get(i).get(3) - 1);
                        botLeft2 = botLeft2.multiply(scaleSpeaker);
                        if (i == 1 || i == 11) {
                            Quad.renderQuad(topLeft2, topRight2, botRight2, botLeft2, Box.speakerMid);
                        } else {
                            Quad.renderQuad(topLeft2, topRight2, botRight2, botLeft2, Box.speakerMain);
                        }
                    }
                    ++i;
                }
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef(r.x + 3.0f, r.y + 1.5f, -4.0f);
                GL11.glRotatef(30.0f, 0.0f, 1.0f, 0.0f);
                float scaleArcade = 70.0f;
                int i2 = 0;
                while (i2 < this.arcade.faces.size()) {
                    topLeft = this.arcade.vecs.get(this.arcade.faces.get(i2).get(0) - 1);
                    topRight = this.arcade.vecs.get(this.arcade.faces.get(i2).get(1) - 1);
                    botRight = this.arcade.vecs.get(this.arcade.faces.get(i2).get(2) - 1);
                    topLeft = topLeft.multiply(scaleArcade);
                    topRight = topRight.multiply(scaleArcade);
                    botRight = botRight.multiply(scaleArcade);
                    texture = -1;
                    col = new Vec3();
                    texture = i2 == 15 ? Box.arcadeGame : (i2 == 7 ? Box.arcadeTop : (i2 == 2 ? Box.arcadeBot : Box.arcadeMain));
                    if (this.arcade.faces.get(i2).size() == 4) {
                        botLeft = this.arcade.vecs.get(this.arcade.faces.get(i2).get(3) - 1);
                        botLeft = botLeft.multiply(scaleArcade);
                        if (texture == -1) {
                            Quad.renderQuad(topLeft, topRight, botRight, botLeft, col);
                        } else {
                            Quad.renderQuad(botLeft, botRight, topRight, topLeft, texture);
                        }
                    } else if (texture == -1) {
                        Quad.renderQuad(topLeft, topRight, botRight, botRight, col);
                    } else {
                        Quad.renderQuad(topLeft, topRight, botRight, botRight, texture);
                    }
                    ++i2;
                }
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef(r.x + 2.0f, r.y + 1.5f, -2.0f);
                GL11.glRotatef(70.0f, 0.0f, 1.0f, 0.0f);
                i2 = 0;
                while (i2 < this.arcade.faces.size()) {
                    topLeft = this.arcade.vecs.get(this.arcade.faces.get(i2).get(0) - 1);
                    topRight = this.arcade.vecs.get(this.arcade.faces.get(i2).get(1) - 1);
                    botRight = this.arcade.vecs.get(this.arcade.faces.get(i2).get(2) - 1);
                    topLeft = topLeft.multiply(scaleArcade);
                    topRight = topRight.multiply(scaleArcade);
                    botRight = botRight.multiply(scaleArcade);
                    texture = -1;
                    col = new Vec3();
                    texture = i2 == 15 ? Box.arcadeGame2 : (i2 == 7 ? Box.arcadeTop : (i2 == 2 ? Box.arcadeBot : Box.arcadeMain));
                    if (this.arcade.faces.get(i2).size() == 4) {
                        botLeft = this.arcade.vecs.get(this.arcade.faces.get(i2).get(3) - 1);
                        botLeft = botLeft.multiply(scaleArcade);
                        if (texture == -1) {
                            Quad.renderQuad(topLeft, topRight, botRight, botLeft, col);
                        } else {
                            Quad.renderQuad(botLeft, botRight, topRight, topLeft, texture);
                        }
                    } else if (texture == -1) {
                        Quad.renderQuad(topLeft, topRight, botRight, botRight, col);
                    } else {
                        Quad.renderQuad(topLeft, topRight, botRight, botRight, texture);
                    }
                    ++i2;
                }
                GL11.glPopMatrix();
            }
        });
        this.mapBlocks.add(new MapBlock(15.0f, -5.0f, 6.0f, 0.5f, false){

            @Override
            public void render() {
                float w = 4.0f;
                Box.renderBoxCorner(new Vec3(this.hitRect.x, this.hitRect.y, -w / 2.0f), new Vec3(this.hitRect.w, this.hitRect.h, w), new Vec3(0.3f, 0.3f, 0.3f));
            }
        });
        this.mapBlocks.add(new MapBlock(-8.0f, -2.0f, 4.0f, 0.25f, true){
            Vec3[] col;
            int colOff;
            boolean initDone;
            {
                this.col = new Vec3[10];
                this.colOff = 0;
                this.initDone = false;
            }

            @Override
            public void render() {
                if (!this.initDone) {
                    float i = 0.0f;
                    while (i < (float)this.col.length) {
                        this.col[(int)i] = new Vec3((i * 0.05f + 0.5f) % 1.0f, (i * 0.05f + 0.1f) % 1.0f, (i * 0.05f + 0.5f) % 1.0f);
                        this.col[(int)i] = new Vec3(1.0f, 0.5f, 0.0f);
                        i += 1.0f;
                    }
                    this.initDone = true;
                }
                Rect r = this.getHitRect();
                int i = 0;
                while (i < 10) {
                    Box.renderBoxCorner(new Vec3(r.x + (float)i * r.w * 0.1f, r.y, -1.5f), new Vec3(r.w * 0.08f, r.h, 3.0f), this.col[(int)(((double)i + (double)this.colOff * 0.05) % (double)this.col.length)]);
                    ++i;
                }
            }
        });
        this.mapBlocks.add(new MapBlock(-2.0f, 3.0f, 4.0f, 0.25f, true){
            Vec3[] col;
            int colOff;
            boolean initDone;
            {
                this.col = new Vec3[10];
                this.colOff = 0;
                this.initDone = false;
            }

            @Override
            public void render() {
                if (!this.initDone) {
                    float i = 0.0f;
                    while (i < (float)this.col.length) {
                        this.col[(int)i] = new Vec3((i * 0.03f + 0.6f) % 1.0f, (i * 0.05f + 0.5f) % 1.0f, (i * 0.05f + 0.5f) % 1.0f);
                        this.col[(int)i] = new Vec3(1.0f, 0.5f, 0.0f);
                        i += 1.0f;
                    }
                    this.initDone = true;
                }
                Rect r = this.getHitRect();
                int i = 0;
                while (i < 10) {
                    Box.renderBoxCorner(new Vec3(r.x + (float)i * r.w * 0.1f, r.y, -1.5f), new Vec3(r.w * 0.08f, r.h, 3.0f), this.col[(int)(((double)i + (double)this.colOff * 0.05) % (double)this.col.length)]);
                    ++i;
                }
            }
        });
        this.mapBlocks.add(new MapBlock(3.0f, -1.0f, 4.0f, 0.25f, true){
            Vec3[] col;
            int colOff;
            boolean initDone;
            {
                this.col = new Vec3[10];
                this.colOff = 0;
                this.initDone = false;
            }

            @Override
            public void render() {
                if (!this.initDone) {
                    float i = 0.0f;
                    while (i < (float)this.col.length) {
                        this.col[(int)i] = new Vec3(1.0f, 0.5f, 0.0f);
                        i += 1.0f;
                    }
                    this.initDone = true;
                }
                Rect r = this.getHitRect();
                int i = 0;
                while (i < 10) {
                    Box.renderBoxCorner(new Vec3(r.x + (float)i * r.w * 0.1f, r.y, -1.5f), new Vec3(r.w * 0.08f, r.h, 3.0f), this.col[(int)(((double)i + (double)this.colOff * 0.05) % (double)this.col.length)]);
                    ++i;
                }
            }
        });
    }

    @Override
    public void render() {
        super.render();
    }
}

