/*
 * Decompiled with CFR 0.152.
 */
package game.map.events;

import game.figureRender.Box;
import game.main.Game;
import game.main.Main;
import game.main.Player;
import game.map.events.Event;
import game.util.Vec2;
import game.util.Vec3;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;

public class JoltEvent
extends Event {
    private float y;
    private boolean up;

    public JoltEvent(Game game) {
        super(game);
    }

    @Override
    public void render() {
        GL11.glPushMatrix();
        GL11.glRotatef((float)this.tick / 3.0f, 0.0f, 1.0f, 0.0f);
        Box.renderBox(new Vec3(0.0f, this.y, 0.0f), new Vec3(200.0f, 0.1f, 200.0f), Vec3.BLACK, new int[]{Box.joltLava, Box.joltLava, Box.joltLava, Box.joltLava, Box.joltLava, Box.joltLava});
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        Color.white.bind();
        GL11.glRotatef(this.tick, 0.0f, 0.0f, 1.0f);
        GL11.glBindTexture(3553, Box.jolt);
        GL11.glBegin(7);
        Vec3 pos = new Vec3(-20.0f, -20.0f, -10.0f);
        int size = 40;
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(pos.x + (float)size, pos.y, pos.z);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(pos.x, pos.y, pos.z);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(pos.x, pos.y + (float)size, pos.z);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(pos.x + (float)size, pos.y + (float)size, pos.z);
        GL11.glEnd();
        GL11.glBindTexture(3553, 0);
        GL11.glPopMatrix();
    }

    @Override
    public void restart() {
        super.restart();
        this.y = -15.0f;
        this.up = true;
    }

    @Override
    public void simulate() {
        ++this.tick;
        if (this.up) {
            this.y = (float)((double)this.y + 2.0 / (double)Main.MILLIS_TO_TICKS(1000));
            if (this.y >= 3.0f) {
                this.up = false;
            }
        } else {
            this.y = (float)((double)this.y - 2.0 / (double)Main.MILLIS_TO_TICKS(1000));
        }
        Player[] playerArray = this.game.getNonEliminatedPlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            Vec2 ppos = p.getPos().clone();
            if (ppos.y < this.y) {
                ppos.y -= 3.0f;
                p.takeDamage(20.0, ppos);
            }
            ++n2;
        }
    }
}

