/*
 * Decompiled with CFR 0.152.
 */
package game.model;

import game.figureRender.Box;
import game.figureRender.Quad;
import game.items.Item;
import game.model.Model;
import game.obj.OBJExtractor;
import game.util.Vec3;
import org.lwjgl.opengl.GL11;

public class BirdieModel
extends Model {
    private Vec3 orange = new Vec3(241.0f, 142.0f, 66.0f).multiply(0.003921569f);
    private Vec3 bodycol = new Vec3(0.7f);
    private static OBJExtractor.OBJ head;
    private static OBJExtractor.OBJ nose;

    static {
        OBJExtractor obje = new OBJExtractor();
        head = obje.loadModel("birdie_head.obj");
        nose = obje.loadModel("birdie_nose.obj");
    }

    public BirdieModel() {
        this.bodyTopWidth = 0.6f;
        this.bodyBotWidth = 0.5f;
        this.bodyHeight = 1.0f;
        this.armUpperLength = 0.5f;
        this.armLowerLength = 0.3f;
        this.handLength = 0.2f;
        this.headLength = 0.3f;
        this.legUpperLength = 0.3f;
        this.legLowerLength = 0.3f;
        this.feetLength = 0.1f;
    }

    @Override
    protected void renderFootRight(boolean takingDamage) {
        Vec3 siz = new Vec3(this.bodyTopWidth * 0.15f, 0.15f, this.bodyTopWidth * 0.6f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 3.0f), siz, takingDamage ? Vec3.WHITE : this.orange);
    }

    @Override
    protected void renderLegLowerRight(boolean takingDamage) {
        Vec3 siz = new Vec3(this.bodyTopWidth * 0.15f, this.legUpperLength, this.bodyTopWidth * 0.45f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : this.bodycol);
    }

    @Override
    protected void renderLegUpperRight(boolean takingDamage) {
        Vec3 siz = new Vec3(this.bodyTopWidth * 0.15f, this.legUpperLength * 1.2f, this.bodyTopWidth * 0.45f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : this.bodycol);
    }

    @Override
    protected void renderFootLeft(boolean takingDamage) {
        Vec3 siz = new Vec3(this.bodyTopWidth * 0.15f, 0.15f, this.bodyTopWidth * 0.6f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 3.0f), siz, takingDamage ? Vec3.WHITE : this.orange);
    }

    @Override
    protected void renderLegLowerLeft(boolean takingDamage) {
        Vec3 siz = new Vec3(this.bodyTopWidth * 0.15f, this.legUpperLength, this.bodyTopWidth * 0.45f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : this.bodycol);
    }

    @Override
    protected void renderLegUpperLeft(boolean takingDamage) {
        Vec3 siz = new Vec3(this.bodyTopWidth * 0.15f, this.legUpperLength * 1.2f, this.bodyTopWidth * 0.45f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : this.bodycol);
    }

    @Override
    protected void renderArmLowerRight(boolean takingDamage) {
        Vec3 sizArm = new Vec3(0.15f, this.armLowerLength, 0.15f);
        Box.renderBoxCorner(new Vec3(-sizArm.x / 2.0f, -this.armLowerLength, -sizArm.z / 2.0f), sizArm, takingDamage ? Vec3.WHITE : this.bodycol);
    }

    @Override
    protected void renderArmUpperRight(boolean takingDamage) {
        Vec3 sizArm = new Vec3(0.15f, this.armUpperLength, 0.15f);
        Box.renderBoxCorner(new Vec3(-sizArm.x / 2.0f, -this.armUpperLength, -sizArm.z / 2.0f), sizArm, takingDamage ? Vec3.WHITE : this.bodycol);
    }

    @Override
    public void renderHead(Item item, boolean takingDamage) {
        if (item != null) {
            item.renderOnModel();
        } else {
            Vec3 botRight;
            Vec3 topRight;
            Vec3 topLeft;
            GL11.glPushMatrix();
            GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
            float scale = 30.0f;
            int i = 0;
            while (i < BirdieModel.head.faces.size()) {
                topLeft = BirdieModel.head.vecs.get(BirdieModel.head.faces.get(i).get(0) - 1);
                topRight = BirdieModel.head.vecs.get(BirdieModel.head.faces.get(i).get(1) - 1);
                botRight = BirdieModel.head.vecs.get(BirdieModel.head.faces.get(i).get(2) - 1);
                topLeft = topLeft.multiply(scale);
                topRight = topRight.multiply(scale);
                botRight = botRight.multiply(scale);
                Quad.renderQuad(topLeft, topRight, botRight, botRight, takingDamage ? Vec3.WHITE : this.bodycol);
                ++i;
            }
            i = 0;
            while (i < BirdieModel.nose.faces.size()) {
                topLeft = BirdieModel.nose.vecs.get(BirdieModel.nose.faces.get(i).get(0) - 1);
                topRight = BirdieModel.nose.vecs.get(BirdieModel.nose.faces.get(i).get(1) - 1);
                botRight = BirdieModel.nose.vecs.get(BirdieModel.nose.faces.get(i).get(2) - 1);
                topLeft = topLeft.multiply(scale);
                topRight = topRight.multiply(scale);
                botRight = botRight.multiply(scale);
                Quad.renderQuad(topLeft, topRight, botRight, botRight, takingDamage ? Vec3.WHITE : this.orange);
                ++i;
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void renderBody(boolean takingDamage) {
        Vec3 sizShirt = new Vec3(this.bodyTopWidth * 0.8f, this.bodyHeight, this.bodyTopWidth * 0.5f);
        Box.renderBoxCorner(new Vec3(-sizShirt.x / 2.0f, -sizShirt.y * 0.95f, -sizShirt.z / 2.0f), sizShirt, takingDamage ? Vec3.WHITE : this.bodycol);
        Vec3 sizPants = new Vec3(this.bodyTopWidth * 0.75f, this.bodyHeight * 0.15f, this.bodyTopWidth * 0.45f);
        Box.renderBoxCorner(new Vec3(-sizPants.x / 2.0f, -this.bodyHeight * 1.1f, -sizPants.z / 2.0f), sizPants, takingDamage ? Vec3.WHITE : this.bodycol);
    }

    @Override
    protected void renderHandRight(Item item, boolean takingDamage) {
        float r = 0.075f;
        float h = 0.3f;
        Vec3 col = takingDamage ? Vec3.WHITE : this.orange;
        Vec3 mid = new Vec3(0.0f, -h, 0.0f);
        Vec3 a = new Vec3(-r, 0.0f, -r);
        Vec3 b = new Vec3(-r, 0.0f, r);
        Vec3 c = new Vec3(r, 0.0f, r);
        Vec3 d = new Vec3(r, 0.0f, -r);
        Quad.renderQuad(a, b, mid, mid, col);
        Quad.renderQuad(b, c, mid, mid, col);
        Quad.renderQuad(c, d, mid, mid, col);
        Quad.renderQuad(d, a, mid, mid, col);
        if (item != null) {
            item.renderOnModel();
        }
    }

    @Override
    protected void renderArmUpperLeft(boolean takingDamage) {
        Vec3 sizArm = new Vec3(0.15f, this.armUpperLength, 0.15f);
        Box.renderBoxCorner(new Vec3(-sizArm.x / 2.0f, -this.armUpperLength, -sizArm.z / 2.0f), sizArm, takingDamage ? Vec3.WHITE : this.bodycol);
    }

    @Override
    protected void renderArmLowerLeft(boolean takingDamage) {
        Vec3 sizArm = new Vec3(0.15f, this.armLowerLength, 0.15f);
        Box.renderBoxCorner(new Vec3(-sizArm.x / 2.0f, -this.armLowerLength, -sizArm.z / 2.0f), sizArm, takingDamage ? Vec3.WHITE : this.bodycol);
    }

    @Override
    protected void renderHandLeft(boolean takingDamage) {
        float r = 0.075f;
        float h = 0.3f;
        Vec3 col = takingDamage ? Vec3.WHITE : this.orange;
        Vec3 mid = new Vec3(0.0f, -h, 0.0f);
        Vec3 a = new Vec3(-r, 0.0f, -r);
        Vec3 b = new Vec3(-r, 0.0f, r);
        Vec3 c = new Vec3(r, 0.0f, r);
        Vec3 d = new Vec3(r, 0.0f, -r);
        Quad.renderQuad(a, b, mid, mid, col);
        Quad.renderQuad(b, c, mid, mid, col);
        Quad.renderQuad(c, d, mid, mid, col);
        Quad.renderQuad(d, a, mid, mid, col);
    }
}

