/*
 * Decompiled with CFR 0.152.
 */
package game.model;

import game.figureRender.Box;
import game.figureRender.Quad;
import game.items.Item;
import game.model.Model;
import game.obj.OBJExtractor;
import game.util.Vec3;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Sphere;

public class GabenModel
extends Model {
    private Sphere sphere = new Sphere();
    private static OBJExtractor.OBJ glasses;
    private static OBJExtractor.OBJ hair;

    static {
        OBJExtractor obje = new OBJExtractor();
        glasses = obje.loadModel("gaben_face.obj");
        hair = obje.loadModel("gaben_hair.obj");
    }

    public GabenModel() {
        this.bodyTopWidth = 0.8f;
        this.bodyBotWidth = 0.5f;
        this.bodyHeight = 1.2f;
        this.armUpperLength = 0.5f;
        this.armLowerLength = 0.3f;
        this.handLength = 0.2f;
        this.headLength = 0.4f;
        this.legUpperLength = 0.5f;
        this.legLowerLength = 0.4f;
        this.feetLength = 0.1f;
    }

    @Override
    protected void renderFootRight(boolean takingDamage) {
        this.bodyTopWidth = 1.0f;
        Vec3 siz = new Vec3(this.bodyTopWidth * 0.15f, 0.15f, this.bodyTopWidth * 0.6f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 3.0f), siz, takingDamage ? Vec3.WHITE : new Vec3(71.0f, 23.0f, 1.0f).multiply(0.003921569f));
    }

    @Override
    protected void renderLegLowerRight(boolean takingDamage) {
        Vec3 siz = new Vec3(this.bodyTopWidth * 0.15f, this.legUpperLength, this.bodyTopWidth * 0.45f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : new Vec3(110.0f, 110.0f, 110.0f).multiply(0.003921569f));
    }

    @Override
    protected void renderLegUpperRight(boolean takingDamage) {
        Vec3 siz = new Vec3(this.bodyTopWidth * 0.15f, this.legUpperLength * 1.2f, this.bodyTopWidth * 0.45f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : new Vec3(110.0f, 110.0f, 110.0f).multiply(0.003921569f));
    }

    @Override
    protected void renderFootLeft(boolean takingDamage) {
        Vec3 siz = new Vec3(this.bodyTopWidth * 0.15f, 0.15f, this.bodyTopWidth * 0.6f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 3.0f), siz, takingDamage ? Vec3.WHITE : new Vec3(71.0f, 23.0f, 1.0f).multiply(0.003921569f));
    }

    @Override
    protected void renderLegLowerLeft(boolean takingDamage) {
        Vec3 siz = new Vec3(this.bodyTopWidth * 0.15f, this.legUpperLength, this.bodyTopWidth * 0.45f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : new Vec3(110.0f, 110.0f, 110.0f).multiply(0.003921569f));
    }

    @Override
    protected void renderLegUpperLeft(boolean takingDamage) {
        Vec3 siz = new Vec3(this.bodyTopWidth * 0.15f, this.legUpperLength * 1.2f, this.bodyTopWidth * 0.45f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : new Vec3(110.0f, 110.0f, 110.0f).multiply(0.003921569f));
    }

    @Override
    protected void renderArmLowerRight(boolean takingDamage) {
        Vec3 sizArm = new Vec3(0.15f, this.armLowerLength, 0.15f);
        Box.renderBoxCorner(new Vec3(-sizArm.x / 2.0f, -this.armLowerLength, -sizArm.z / 2.0f), sizArm, takingDamage ? Vec3.WHITE : new Vec3(1.0f, 0.9f, 0.8f));
    }

    @Override
    protected void renderArmUpperRight(boolean takingDamage) {
        Vec3 sizShirt = new Vec3(0.2f, this.armUpperLength * 0.8f, 0.2f);
        Box.renderBoxCorner(new Vec3(-sizShirt.x / 2.0f, -sizShirt.y + 0.05f, -sizShirt.z / 2.0f), sizShirt, takingDamage ? Vec3.WHITE : new Vec3(134.0f, 22.0f, 21.0f).multiply(0.003921569f));
        Vec3 sizArm = new Vec3(0.15f, this.armUpperLength * 0.4f, 0.15f);
        Box.renderBoxCorner(new Vec3(-sizArm.x / 2.0f, -this.armUpperLength, -sizArm.z / 2.0f), sizArm, takingDamage ? Vec3.WHITE : new Vec3(1.0f, 0.9f, 0.8f));
    }

    @Override
    public void renderHead(Item item, boolean takingDamage) {
        this.sphere.setDrawStyle(100012);
        this.sphere.setTextureFlag(true);
        this.sphere.setNormals(100000);
        Vec3 sizTop = new Vec3(this.headLength * 0.66f, this.headLength, this.headLength * 0.66f);
        Vec3 sizNeck = new Vec3(this.headLength * 0.4f, this.headLength, this.headLength * 0.4f);
        Box.renderBoxCorner(new Vec3(-sizNeck.x / 2.0f, 0.0f, -sizNeck.z / 2.0f), sizNeck, takingDamage ? Vec3.WHITE : new Vec3(0.90588236f, 0.7607843f, 0.69803923f));
        Vec3 sizHat = new Vec3(this.headLength * 1.2f, this.headLength * 0.2f, this.headLength * 1.1f);
        Box.renderBoxCorner(new Vec3(-sizHat.x / 2.0f, sizTop.y + this.headLength * 0.2f, -sizHat.z / 2.0f - 0.0f), sizHat, takingDamage ? Vec3.WHITE : new Vec3(58.0f, 26.0f, 20.0f).multiply(0.003921569f));
        Vec3 sizHat2 = new Vec3(this.headLength * 1.2f, this.headLength * 0.8f, this.headLength * 0.5f);
        Box.renderBoxCorner(new Vec3(-sizHat2.x / 2.0f, sizNeck.y * 0.6f, -sizHat2.z * 1.2f), sizHat2, takingDamage ? Vec3.WHITE : new Vec3(58.0f, 26.0f, 20.0f).multiply(0.003921569f));
        Vec3 sizHead = new Vec3(this.headLength, this.headLength, this.headLength);
        Box.renderBoxCorner(new Vec3(-sizHead.x / 2.0f, sizNeck.y * 0.3f, -sizHead.z / 2.0f), sizHead, takingDamage ? Vec3.WHITE : new Vec3(1.0f, 0.9f, 0.8f));
        this.renderGlasses(takingDamage);
        if (item != null) {
            item.renderOnModel();
        }
    }

    protected void renderGlasses(boolean takingDamage) {
        GL11.glPushMatrix();
        GL11.glTranslatef(0.0f, this.headLength / 2.0f, this.headLength / 2.0f);
        float scale = 2.5f;
        int i = 0;
        while (i < GabenModel.glasses.faces.size()) {
            Vec3 topLeft = GabenModel.glasses.vecs.get(GabenModel.glasses.faces.get(i).get(0) - 1);
            Vec3 topRight = GabenModel.glasses.vecs.get(GabenModel.glasses.faces.get(i).get(1) - 1);
            Vec3 botLeft = GabenModel.glasses.vecs.get(GabenModel.glasses.faces.get(i).get(2) - 1);
            Vec3 botRight = GabenModel.glasses.faces.get(i).size() > 3 ? GabenModel.glasses.vecs.get(GabenModel.glasses.faces.get(i).get(3) - 1) : botLeft;
            topLeft = topLeft.multiply(scale);
            topRight = topRight.multiply(scale);
            botRight = botRight.multiply(scale);
            botLeft = botLeft.multiply(scale);
            Vec3 color = new Vec3();
            color = i >= 6 && i <= 32 ? new Vec3(216.0f, 183.0f, 150.0f).multiply(0.003921569f) : (i <= 16 ? new Vec3(233.0f, 176.0f, 157.0f).multiply(0.003921569f) : new Vec3(0.3f, 0.3f, 0.3f));
            Quad.renderQuad(topLeft, topRight, botLeft, botRight, takingDamage ? Vec3.WHITE : color);
            ++i;
        }
        GL11.glPopMatrix();
    }

    @Override
    protected void renderBody(boolean takingDamage) {
        Vec3 sizShirt = new Vec3(this.bodyTopWidth * 0.8f, this.bodyHeight, this.bodyTopWidth * 0.9f);
        Box.renderBoxCorner(new Vec3(-sizShirt.x / 2.0f, -sizShirt.y * 0.95f, -sizShirt.z / 2.0f), sizShirt, takingDamage ? Vec3.WHITE : new Vec3(134.0f, 22.0f, 21.0f).multiply(0.003921569f));
        Vec3 sizPants = new Vec3(this.bodyTopWidth * 0.75f, this.bodyHeight * 0.15f, this.bodyTopWidth * 0.45f);
        Box.renderBoxCorner(new Vec3(-sizPants.x / 2.0f, -this.bodyHeight * 1.1f, -sizPants.z / 2.0f), sizPants, takingDamage ? Vec3.WHITE : new Vec3(110.0f, 110.0f, 110.0f).multiply(0.003921569f));
    }

    @Override
    protected void renderHandRight(Item item, boolean takingDamage) {
        Vec3 siz = new Vec3(0.2f, 0.2f, 0.2f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : new Vec3(1.0f, 0.9f, 0.8f));
        if (item != null) {
            item.renderOnModel();
        }
    }

    @Override
    protected void renderArmUpperLeft(boolean takingDamage) {
        Vec3 siz = new Vec3(0.2f, this.armUpperLength * 0.8f, 0.2f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y + 0.05f, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : new Vec3(134.0f, 22.0f, 21.0f).multiply(0.003921569f));
        Vec3 sizArm = new Vec3(0.15f, this.armUpperLength * 0.4f, 0.15f);
        Box.renderBoxCorner(new Vec3(-sizArm.x / 2.0f, -this.armUpperLength, -sizArm.z / 2.0f), sizArm, takingDamage ? Vec3.WHITE : new Vec3(1.0f, 0.9f, 0.8f));
    }

    @Override
    protected void renderArmLowerLeft(boolean takingDamage) {
        Vec3 sizArm = new Vec3(0.15f, this.armLowerLength, 0.15f);
        Box.renderBoxCorner(new Vec3(-sizArm.x / 2.0f, -this.armLowerLength, -sizArm.z / 2.0f), sizArm, takingDamage ? Vec3.WHITE : new Vec3(1.0f, 0.9f, 0.8f));
    }

    @Override
    protected void renderHandLeft(boolean takingDamage) {
        Vec3 siz = new Vec3(0.2f, 0.2f, 0.2f);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : new Vec3(1.0f, 0.9f, 0.8f));
    }
}

