/*
 * Decompiled with CFR 0.152.
 */
package game.model;

import animationEditor.AnimationMain;
import game.figureRender.Box;
import game.items.Item;
import game.main.Main;
import game.main.Player;
import game.util.Vec3;
import org.lwjgl.opengl.GL11;

public abstract class Model {
    protected float bodyTopWidth = 1.0f;
    protected float bodyBotWidth = 1.0f;
    protected float bodyHeight = 1.0f;
    protected float armUpperLength = 1.0f;
    protected float armLowerLength = 1.0f;
    protected float handLength = 1.0f;
    protected float headLength = 1.0f;
    protected float legUpperLength = 1.0f;
    protected float legLowerLength = 1.0f;
    protected float feetLength = 1.0f;
    protected Vec3 headRot = new Vec3();
    protected Vec3 legLeftUpperRot = new Vec3();
    protected Vec3 legLeftLowerRot = new Vec3();
    protected Vec3 footLeftRot = new Vec3();
    protected Vec3 legRightUpperRot = new Vec3();
    protected Vec3 legRightLowerRot = new Vec3();
    protected Vec3 footRightRot = new Vec3();
    protected Vec3 armLeftUpperRot = new Vec3();
    protected Vec3 armLeftLowerRot = new Vec3();
    protected Vec3 handLeftRot = new Vec3();
    protected Vec3 armRightUpperRot = new Vec3();
    protected Vec3 armRightLowerRot = new Vec3();
    protected Vec3 handRightRot = new Vec3();
    protected int animationStartTick = 0;
    protected Vec3 punchingUpper = this.armRightUpperRot;
    protected Vec3 punchingLower = this.armRightLowerRot;
    int i = 0;

    public void update() {
        this.punchAnimation(this.i, null);
        if (!AnimationMain.PAUSE_ANIMATION) {
            ++this.i;
        }
    }

    public void setAnimationStartTick(int i) {
        this.animationStartTick = i;
        if (Math.random() > 0.5) {
            this.punchingUpper = this.armRightUpperRot;
            this.punchingLower = this.armRightLowerRot;
        } else {
            this.punchingUpper = this.armLeftUpperRot;
            this.punchingLower = this.armLeftLowerRot;
        }
    }

    public void rifleAnimation(int i) {
        this.armRightUpperRot = new Vec3();
        this.armRightLowerRot = new Vec3();
        this.armRightUpperRot.x = 0.0f;
        this.armRightLowerRot.x = -90.0f;
    }

    public void shieldAnimation(int i) {
        this.armRightUpperRot.x = -90.0f;
        this.armRightLowerRot.x = -90.0f;
        this.armLeftUpperRot.x = -90.0f;
        this.armLeftLowerRot.x = -90.0f;
    }

    public void fireBallAnimation(int simulationTick) {
        this.armRightUpperRot = new Vec3();
        this.armRightLowerRot = new Vec3();
        this.armRightUpperRot.x = -90.0f;
        this.armRightUpperRot.z = -45.0f;
        this.armRightLowerRot.z = 90.0f;
        this.armLeftUpperRot = new Vec3();
        this.armLeftLowerRot = new Vec3();
        this.armLeftUpperRot.x = -90.0f;
        this.armLeftUpperRot.z = 45.0f;
        this.armLeftLowerRot.z = -90.0f;
    }

    public void walkAnimation(int i) {
        this.armRightUpperRot.x = (float)(20.0 * Math.sin(0.15707963267948966 * (double)i));
        this.legRightUpperRot.x = -((float)(30.0 * Math.sin(0.15707963267948966 * (double)i)));
        this.legRightLowerRot.x = (float)(30.0 * Math.sin(0.15707963267948966 * (double)i)) * (float)(i % 40 <= 20 ? 1 : 0);
        this.armRightLowerRot.x = -40.0f;
        this.armLeftLowerRot.x = -40.0f;
        this.armLeftUpperRot.x = -((float)(20.0 * Math.sin(0.15707963267948966 * (double)i)));
        this.legLeftUpperRot.x = (float)(30.0 * Math.sin(0.15707963267948966 * (double)i));
        this.legLeftLowerRot.x = -((float)(30.0 * Math.sin(0.15707963267948966 * (double)i))) * (float)(i % 40 >= 20 ? 1 : 0);
    }

    public void punchAnimation(int i, Player player) {
        int attackDuration = Main.MILLIS_TO_TICKS(500);
        i -= this.animationStartTick;
        if (player != null && player.item != null && player.item.isSwingable()) {
            this.punchAnimationWithItem(i);
            return;
        }
        int k = attackDuration / 6;
        if (i <= attackDuration / 6) {
            this.punchingUpper.z = (float)(-70.0 * Math.sin(1.5707963267948966 / (double)k * (double)i)) * (float)(this.punchingUpper == this.armRightUpperRot ? 1 : -1);
            this.punchingLower.x = (float)(-90.0 * Math.sin(1.5707963267948966 / (double)k * (double)i));
            this.punchingUpper.y = (float)(-50.0 * Math.sin(1.5707963267948966 / (double)k * (double)i)) * (float)(this.punchingUpper == this.armRightUpperRot ? 1 : -1);
        } else if (i <= attackDuration / 3 + attackDuration / 6) {
            k = attackDuration / 3;
            this.punchingUpper.y = (float)(-50.0 + 100.0 * Math.sin(1.5707963267948966 / (double)k * (double)(i -= attackDuration / 6))) * (float)(this.punchingUpper == this.armRightUpperRot ? 1 : -1);
        } else if ((double)i <= (double)attackDuration * 2.0 / 3.0 + (double)(attackDuration / 6)) {
            k = attackDuration / 3;
            this.punchingUpper.y = (float)(50.0 - 100.0 * Math.sin(1.5707963267948966 / (double)k * (double)(i -= attackDuration / 3 + attackDuration / 6))) * (float)(this.punchingUpper == this.armRightUpperRot ? 1 : -1);
        } else if (i <= attackDuration) {
            k = attackDuration / 6;
            this.punchingUpper.z = (float)(-70.0 + 70.0 * Math.sin(1.5707963267948966 / (double)k * (double)(i -= 2 * attackDuration / 3 + attackDuration / 6))) * (float)(this.punchingUpper == this.armRightUpperRot ? 1 : -1);
            this.punchingLower.x = (float)(-90.0 + 90.0 * Math.sin(1.5707963267948966 / (double)k * (double)i));
            this.punchingUpper.y = (float)(-50.0 + 50.0 * Math.sin(1.5707963267948966 / (double)k * (double)i)) * (float)(this.punchingUpper == this.armRightUpperRot ? 1 : -1);
        } else {
            this.punchingUpper.z = 0.0f;
            this.punchingLower.x = 0.0f;
            this.punchingUpper.y = 0.0f;
        }
    }

    private void punchAnimationWithItem(int i) {
        int attackDuration = Main.MILLIS_TO_TICKS(500);
        this.punchingUpper = this.armRightUpperRot;
        this.punchingLower = this.armRightLowerRot;
        int k = attackDuration / 3;
        if (i <= attackDuration / 3) {
            this.punchingUpper.x = (float)(70.0 * Math.sin(1.5707963267948966 / (double)k * (double)i)) * (float)(this.punchingUpper == this.armRightUpperRot ? 1 : -1);
            this.punchingLower.x = (float)(-90.0 * Math.sin(1.5707963267948966 / (double)k * (double)i));
        } else if ((double)i <= 2.0 * (double)attackDuration / 3.0) {
            k = attackDuration / 3;
            this.punchingUpper.x = (float)(70.0 - 100.0 * Math.sin(1.5707963267948966 / (double)k * (double)(i -= attackDuration / 3))) * (float)(this.punchingUpper == this.armRightUpperRot ? 1 : -1);
            this.punchingLower.x = (float)(-90.0 + 90.0 * Math.sin(1.5707963267948966 / (double)k * (double)i));
        } else if ((double)i <= (double)attackDuration * 3.0 / 3.0) {
            k = attackDuration / 3;
            this.punchingUpper.x = (float)(-30.0 + 30.0 * Math.sin(1.5707963267948966 / (double)k * (double)(i -= 2 * attackDuration / 3))) * (float)(this.punchingUpper == this.armRightUpperRot ? 1 : -1);
        } else {
            this.punchingUpper.z = 0.0f;
            this.punchingLower.x = 0.0f;
            this.punchingUpper.y = 0.0f;
        }
    }

    public void jumpAnimation(int i) {
        i = this.animationStartTick - i;
        this.armRightUpperRot.z = (float)(-50.0 - 15.0 * Math.sin(0.07853981633974483 * (double)i) * (double)(i % 160 <= 80 ? true : true));
        this.armRightLowerRot.x = -60.0f;
        this.armLeftUpperRot.z = (float)(50.0 + 15.0 * Math.sin(0.07853981633974483 * (double)i) * (double)(i % 160 <= 80 ? true : true));
        this.armLeftLowerRot.x = -60.0f;
        this.legLeftUpperRot.x = (float)(-15.0 * Math.sin(0.07853981633974483 * (double)i));
        this.legLeftLowerRot.x = 20.0f;
        this.legRightUpperRot.x = (float)(15.0 * Math.sin(0.07853981633974483 * (double)i));
        this.legRightLowerRot.x = 20.0f;
    }

    public void render(Item item, Limb limb, boolean takingDamage) {
        GL11.glPushMatrix();
        GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        float w = 0.05f;
        if (!AnimationMain.DRAW_MODEL) {
            Box.renderBox(new Vec3(0.0f, -this.bodyHeight / 2.0f, 0.0f), new Vec3(w, this.bodyHeight, w), new Vec3(1.0f, 1.0f, 1.0f));
            Box.renderBox(new Vec3(0.0f, 0.0f, 0.0f), new Vec3(this.bodyTopWidth, w, w), new Vec3(1.0f, 0.0f, 1.0f));
            Box.renderBox(new Vec3(0.0f, -this.bodyHeight, 0.0f), new Vec3(this.bodyBotWidth, w, w), new Vec3(1.0f, 0.0f, 1.0f));
        } else {
            this.renderBody(takingDamage);
        }
        GL11.glPushMatrix();
        GL11.glRotatef(this.headRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.headRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.headRot.z, 0.0f, 0.0f, 1.0f);
        if (AnimationMain.DRAW_MODEL) {
            this.renderHead(limb == Limb.HEAD ? item : null, takingDamage);
        } else {
            Box.renderBox(new Vec3(0.0f, this.headLength / 2.0f, 0.0f), new Vec3(w, this.headLength, w), new Vec3(0.0f, 0.0f, 1.0f));
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armLeftUpperRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armLeftUpperRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.armLeftUpperRot.z, 0.0f, 0.0f, 1.0f);
        if (AnimationMain.DRAW_MODEL) {
            this.renderArmUpperLeft(takingDamage);
            GL11.glTranslatef(-this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        } else {
            GL11.glTranslatef(-this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
            Box.renderBox(new Vec3(this.bodyTopWidth / 2.0f, -this.armUpperLength / 2.0f, 0.0f), new Vec3(w, this.armUpperLength, w), new Vec3(1.0f, 0.0f, 1.0f));
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, -this.armUpperLength, 0.0f);
        GL11.glRotatef(this.armLeftLowerRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armLeftLowerRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.armLeftLowerRot.z, 0.0f, 0.0f, 1.0f);
        if (AnimationMain.DRAW_MODEL) {
            this.renderArmLowerLeft(takingDamage);
            GL11.glTranslatef(-this.bodyTopWidth / 2.0f, this.armUpperLength, 0.0f);
        } else {
            GL11.glTranslatef(-this.bodyTopWidth / 2.0f, this.armUpperLength, 0.0f);
            Box.renderBox(new Vec3(this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength / 2.0f, 0.0f), new Vec3(w, this.armLowerLength, w), new Vec3(1.0f, 0.0f, 0.0f));
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength, 0.0f);
        GL11.glRotatef(this.handLeftRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.handLeftRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.handLeftRot.z, 0.0f, 0.0f, 1.0f);
        if (AnimationMain.DRAW_MODEL) {
            this.renderHandLeft(takingDamage);
            GL11.glTranslatef(-this.bodyTopWidth / 2.0f, this.armUpperLength + this.armLowerLength, 0.0f);
        } else {
            GL11.glTranslatef(-this.bodyTopWidth / 2.0f, this.armUpperLength + this.armLowerLength, 0.0f);
            Box.renderBox(new Vec3(this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength - this.handLength / 2.0f, 0.0f), new Vec3(w, this.handLength, w), new Vec3(1.0f, 1.0f, 0.0f));
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armRightUpperRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armRightUpperRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.armRightUpperRot.z, 0.0f, 0.0f, 1.0f);
        if (AnimationMain.DRAW_MODEL) {
            this.renderArmUpperRight(takingDamage);
            GL11.glTranslatef(this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        } else {
            GL11.glTranslatef(this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
            Box.renderBox(new Vec3(-this.bodyTopWidth / 2.0f, -this.armUpperLength / 2.0f, 0.0f), new Vec3(w, this.armUpperLength, w), new Vec3(1.0f, 0.0f, 1.0f));
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, -this.armUpperLength, 0.0f);
        GL11.glRotatef(this.armRightLowerRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armRightLowerRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.armRightLowerRot.z, 0.0f, 0.0f, 1.0f);
        if (AnimationMain.DRAW_MODEL) {
            this.renderArmLowerRight(takingDamage);
            GL11.glTranslatef(this.bodyTopWidth / 2.0f, this.armUpperLength, 0.0f);
        } else {
            GL11.glTranslatef(this.bodyTopWidth / 2.0f, this.armUpperLength, 0.0f);
            Box.renderBox(new Vec3(-this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength / 2.0f, 0.0f), new Vec3(w, this.armLowerLength, w), new Vec3(1.0f, 0.0f, 0.0f));
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength, 0.0f);
        GL11.glRotatef(this.handRightRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.handRightRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.handRightRot.z, 0.0f, 0.0f, 1.0f);
        if (AnimationMain.DRAW_MODEL) {
            this.renderHandRight(limb == Limb.HAND_RIGHT ? item : null, takingDamage);
            GL11.glTranslatef(this.bodyTopWidth / 2.0f, this.armUpperLength + this.armLowerLength, 0.0f);
        } else {
            GL11.glTranslatef(this.bodyTopWidth / 2.0f, this.armUpperLength + this.armLowerLength, 0.0f);
            Box.renderBox(new Vec3(-this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength - this.handLength / 2.0f, 0.0f), new Vec3(w, this.handLength, w), new Vec3(1.0f, 1.0f, 0.0f));
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, -this.bodyHeight, 0.0f);
        GL11.glRotatef(this.legLeftUpperRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.legLeftUpperRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.legLeftUpperRot.z, 0.0f, 0.0f, 1.0f);
        if (AnimationMain.DRAW_MODEL) {
            this.renderLegUpperLeft(takingDamage);
            GL11.glTranslatef(-this.bodyBotWidth / 2.0f, this.bodyHeight, 0.0f);
        } else {
            GL11.glTranslatef(-this.bodyBotWidth / 2.0f, this.bodyHeight, 0.0f);
            Box.renderBox(new Vec3(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength / 2.0f, 0.0f), new Vec3(w, this.legUpperLength, w), new Vec3(1.0f, 0.0f, 1.0f));
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength, 0.0f);
        GL11.glRotatef(this.legLeftLowerRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.legLeftLowerRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.legLeftLowerRot.z, 0.0f, 0.0f, 1.0f);
        if (AnimationMain.DRAW_MODEL) {
            this.renderLegLowerLeft(takingDamage);
            GL11.glTranslatef(-this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength, 0.0f);
        } else {
            GL11.glTranslatef(-this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength, 0.0f);
            Box.renderBox(new Vec3(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength / 2.0f, 0.0f), new Vec3(w, this.legLowerLength, w), new Vec3(1.0f, 0.0f, 0.0f));
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, 0.0f);
        GL11.glRotatef(this.footLeftRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.footLeftRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.footLeftRot.z, 0.0f, 0.0f, 1.0f);
        if (AnimationMain.DRAW_MODEL) {
            this.renderFootLeft(takingDamage);
            GL11.glTranslatef(-this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength + this.legLowerLength, 0.0f);
        } else {
            GL11.glTranslatef(-this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength + this.legLowerLength, 0.0f);
            Box.renderBox(new Vec3(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, this.feetLength / 2.0f), new Vec3(w, w, this.feetLength), new Vec3(1.0f, 1.0f, 0.0f));
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, -this.bodyHeight, 0.0f);
        GL11.glRotatef(this.legRightUpperRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.legRightUpperRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.legRightUpperRot.z, 0.0f, 0.0f, 1.0f);
        if (AnimationMain.DRAW_MODEL) {
            this.renderLegUpperRight(takingDamage);
            GL11.glTranslatef(this.bodyBotWidth / 2.0f, this.bodyHeight, 0.0f);
        } else {
            GL11.glTranslatef(this.bodyBotWidth / 2.0f, this.bodyHeight, 0.0f);
            Box.renderBox(new Vec3(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength / 2.0f, 0.0f), new Vec3(w, this.legUpperLength, w), new Vec3(1.0f, 0.0f, 1.0f));
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength, 0.0f);
        GL11.glRotatef(this.legRightLowerRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.legRightLowerRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.legRightLowerRot.z, 0.0f, 0.0f, 1.0f);
        if (AnimationMain.DRAW_MODEL) {
            this.renderLegLowerRight(takingDamage);
            GL11.glTranslatef(this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength, 0.0f);
        } else {
            GL11.glTranslatef(this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength, 0.0f);
            Box.renderBox(new Vec3(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength / 2.0f, 0.0f), new Vec3(w, this.legLowerLength, w), new Vec3(1.0f, 0.0f, 0.0f));
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, 0.0f);
        GL11.glRotatef(this.footRightRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.footRightRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.footRightRot.z, 0.0f, 0.0f, 1.0f);
        if (AnimationMain.DRAW_MODEL) {
            this.renderFootRight(takingDamage);
            GL11.glTranslatef(this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength + this.legLowerLength, 0.0f);
        } else {
            GL11.glTranslatef(this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength + this.legLowerLength, 0.0f);
            Box.renderBox(new Vec3(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, this.feetLength / 2.0f), new Vec3(w, w, this.feetLength), new Vec3(1.0f, 1.0f, 0.0f));
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    protected void renderFootRight(boolean takingDamage) {
    }

    protected void renderLegLowerRight(boolean takingDamage) {
    }

    protected void renderLegUpperRight(boolean takingDamage) {
    }

    protected void renderFootLeft(boolean takingDamage) {
    }

    protected void renderLegLowerLeft(boolean takingDamage) {
    }

    protected void renderLegUpperLeft(boolean takingDamage) {
    }

    protected void renderArmLowerRight(boolean takingDamage) {
    }

    protected void renderArmUpperRight(boolean takingDamage) {
    }

    public void renderHead(Item item, boolean takingDamage) {
    }

    protected void renderBody(boolean takingDamage) {
    }

    protected void renderHandRight(Item item, boolean takingDamage) {
    }

    protected void renderArmUpperLeft(boolean takingDamage) {
    }

    protected void renderArmLowerLeft(boolean takingDamage) {
    }

    protected void renderHandLeft(boolean takingDamage) {
    }

    public float getWidth() {
        return Math.max(this.bodyTopWidth, this.bodyBotWidth);
    }

    public float getHeight() {
        return this.headLength + this.bodyHeight + this.legUpperLength + this.legLowerLength;
    }

    public float getTopHalfHeigth() {
        return this.headLength;
    }

    public void reset() {
        this.headRot = new Vec3();
        this.legLeftUpperRot = new Vec3();
        this.legLeftLowerRot = new Vec3();
        this.footLeftRot = new Vec3();
        this.legRightUpperRot = new Vec3();
        this.legRightLowerRot = new Vec3();
        this.footRightRot = new Vec3();
        this.armLeftUpperRot = new Vec3();
        this.armLeftLowerRot = new Vec3();
        this.handLeftRot = new Vec3();
        this.armRightUpperRot = new Vec3();
        this.armRightLowerRot = new Vec3();
        this.handRightRot = new Vec3();
    }

    public static enum Limb {
        HAND_RIGHT,
        HEAD;

    }
}

