/*
 * Decompiled with CFR 0.152.
 */
package game.model;

import game.figureRender.Box;
import game.figureRender.Quad;
import game.items.Helm;
import game.items.Item;
import game.model.Model;
import game.obj.OBJExtractor;
import game.util.Vec3;
import org.lwjgl.opengl.GL11;

public class PacModel
extends Model {
    private static OBJExtractor.OBJ headTop;
    private static OBJExtractor.OBJ headBot;
    private static OBJExtractor.OBJ glove;
    private static OBJExtractor.OBJ boot;
    private int pacRotationCounter = 20;

    static {
        OBJExtractor obje = new OBJExtractor();
        headTop = obje.loadModel("pac_head_top.obj");
        headBot = obje.loadModel("pac_head_bot.obj");
        obje = new OBJExtractor();
        glove = obje.loadModel("pac_glove.obj");
        obje = new OBJExtractor();
        boot = obje.loadModel("pac_boot.obj");
    }

    public PacModel() {
        this.bodyTopWidth = 0.8f;
        this.bodyBotWidth = 0.2f;
        this.bodyHeight = 0.0f;
        this.armUpperLength = 0.4f;
        this.armLowerLength = 0.3f;
        this.handLength = 0.2f;
        this.headLength = 0.3f;
        this.legUpperLength = 0.8f;
        this.legLowerLength = 0.4f;
        this.feetLength = 0.3f;
    }

    @Override
    public void walkAnimation(int i) {
        super.walkAnimation(i);
    }

    @Override
    public void render(Item item, Model.Limb limb, boolean takingDamage) {
        ++this.pacRotationCounter;
        Vec3 col = takingDamage ? Vec3.WHITE : Vec3.YELLOW;
        GL11.glPushMatrix();
        GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        float w = 0.05f;
        GL11.glPushMatrix();
        GL11.glRotatef(this.headRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.headRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.headRot.z, 0.0f, 0.0f, 1.0f);
        this.renderHead(limb == Model.Limb.HEAD ? item : null, takingDamage);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armLeftUpperRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armLeftUpperRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.armLeftUpperRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        Box.renderBox(new Vec3(this.bodyTopWidth / 2.0f, -this.armUpperLength / 2.0f, 0.0f), new Vec3(w, this.armUpperLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, -this.armUpperLength, 0.0f);
        GL11.glRotatef(this.armLeftLowerRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armLeftLowerRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.armLeftLowerRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, this.armUpperLength, 0.0f);
        Box.renderBox(new Vec3(this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength / 2.0f, 0.0f), new Vec3(w, this.armLowerLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength, 0.0f);
        GL11.glRotatef(this.handLeftRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.handLeftRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.handLeftRot.z, 0.0f, 0.0f, 1.0f);
        this.renderGlove();
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, this.armUpperLength + this.armLowerLength, 0.0f);
        Box.renderBox(new Vec3(this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength - this.handLength / 2.0f, 0.0f), new Vec3(w, this.handLength, w), col);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armRightUpperRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armRightUpperRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.armRightUpperRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        Box.renderBox(new Vec3(-this.bodyTopWidth / 2.0f, -this.armUpperLength / 2.0f, 0.0f), new Vec3(w, this.armUpperLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, -this.armUpperLength, 0.0f);
        GL11.glRotatef(this.armRightLowerRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armRightLowerRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.armRightLowerRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, this.armUpperLength, 0.0f);
        Box.renderBox(new Vec3(-this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength / 2.0f, 0.0f), new Vec3(w, this.armLowerLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength, 0.0f);
        GL11.glRotatef(this.handRightRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.handRightRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.handRightRot.z, 0.0f, 0.0f, 1.0f);
        this.renderGlove();
        if (item != null && limb == Model.Limb.HAND_RIGHT) {
            item.renderOnModel();
        }
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, this.armUpperLength + this.armLowerLength, 0.0f);
        Box.renderBox(new Vec3(-this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength - this.handLength / 2.0f, 0.0f), new Vec3(w, this.handLength, w), col);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, -this.bodyHeight, 0.0f);
        GL11.glRotatef(this.legLeftUpperRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.legLeftUpperRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.legLeftUpperRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, this.bodyHeight, 0.0f);
        Box.renderBox(new Vec3(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength / 2.0f, 0.0f), new Vec3(w, this.legUpperLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength, 0.0f);
        GL11.glRotatef(this.legLeftLowerRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.legLeftLowerRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.legLeftLowerRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength, 0.0f);
        Box.renderBox(new Vec3(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength / 2.0f, 0.0f), new Vec3(w, this.legLowerLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, 0.0f);
        GL11.glRotatef(this.footLeftRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.footLeftRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.footLeftRot.z, 0.0f, 0.0f, 1.0f);
        this.renderBoot();
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength + this.legLowerLength, 0.0f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, -this.bodyHeight, 0.0f);
        GL11.glRotatef(this.legRightUpperRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.legRightUpperRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.legRightUpperRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, this.bodyHeight, 0.0f);
        Box.renderBox(new Vec3(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength / 2.0f, 0.0f), new Vec3(w, this.legUpperLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength, 0.0f);
        GL11.glRotatef(this.legRightLowerRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.legRightLowerRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.legRightLowerRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength, 0.0f);
        Box.renderBox(new Vec3(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength / 2.0f, 0.0f), new Vec3(w, this.legLowerLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, 0.0f);
        GL11.glRotatef(this.footRightRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.footRightRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.footRightRot.z, 0.0f, 0.0f, 1.0f);
        this.renderBoot();
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength + this.legLowerLength, 0.0f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private void renderGlove() {
        GL11.glPushMatrix();
        GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(0.0f, -0.2f, 0.0f);
        float scale = 15.0f;
        int i = 0;
        while (i < PacModel.glove.faces.size()) {
            Vec3 topLeft = PacModel.glove.vecs.get(PacModel.glove.faces.get(i).get(0) - 1);
            Vec3 topRight = PacModel.glove.vecs.get(PacModel.glove.faces.get(i).get(1) - 1);
            Vec3 botRight = PacModel.glove.vecs.get(PacModel.glove.faces.get(i).get(2) - 1);
            topLeft = topLeft.multiply(scale);
            topRight = topRight.multiply(scale);
            botRight = botRight.multiply(scale);
            if (PacModel.glove.faces.get(i).size() == 4) {
                Vec3 botLeft = PacModel.glove.vecs.get(PacModel.glove.faces.get(i).get(3) - 1);
                botLeft = botLeft.multiply(scale);
                Quad.renderQuad(topLeft, topRight, botRight, botLeft, Box.pacBoot);
            }
            ++i;
        }
        GL11.glPopMatrix();
    }

    private void renderBoot() {
        GL11.glPushMatrix();
        GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        GL11.glTranslatef(0.0f, -0.2f, 0.0f);
        float scale = 30.0f;
        int i = 0;
        while (i < PacModel.boot.faces.size()) {
            Vec3 topLeft = PacModel.boot.vecs.get(PacModel.boot.faces.get(i).get(0) - 1);
            Vec3 topRight = PacModel.boot.vecs.get(PacModel.boot.faces.get(i).get(1) - 1);
            Vec3 botRight = PacModel.boot.vecs.get(PacModel.boot.faces.get(i).get(2) - 1);
            topLeft = topLeft.multiply(scale);
            topRight = topRight.multiply(scale);
            botRight = botRight.multiply(scale);
            if (PacModel.boot.faces.get(i).size() == 4) {
                Vec3 botLeft = PacModel.boot.vecs.get(PacModel.boot.faces.get(i).get(3) - 1);
                botLeft = botLeft.multiply(scale);
                Quad.renderQuad(topLeft, topRight, botRight, botLeft, Box.pacBoot);
            }
            ++i;
        }
        GL11.glPopMatrix();
    }

    @Override
    public void renderHead(Item item, boolean takingDamage) {
        Vec3 botLeft;
        Vec3 col;
        Vec3 botRight;
        Vec3 topRight;
        Vec3 topLeft;
        this.pacRotationCounter %= 40;
        float a = (float)(45.0 * Math.sin(0.07853981633974483 * (double)this.pacRotationCounter));
        float scale = 50.0f;
        float ztrans = 0.1f;
        GL11.glPushMatrix();
        GL11.glTranslatef(0.0f, 0.0f, ztrans);
        GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(a, 0.0f, 0.0f, 1.0f);
        Box.renderBox(new Vec3(0.25f, 0.3f, 0.25f), new Vec3(0.125f), Vec3.BLACK);
        Box.renderBox(new Vec3(0.25f, 0.3f, -0.25f), new Vec3(0.125f), Vec3.BLACK);
        int i = 0;
        while (i < PacModel.headTop.faces.size()) {
            topLeft = PacModel.headTop.vecs.get(PacModel.headTop.faces.get(i).get(0) - 1);
            topRight = PacModel.headTop.vecs.get(PacModel.headTop.faces.get(i).get(1) - 1);
            botRight = PacModel.headTop.vecs.get(PacModel.headTop.faces.get(i).get(2) - 1);
            topLeft = topLeft.multiply(scale);
            topRight = topRight.multiply(scale);
            botRight = botRight.multiply(scale);
            col = new Vec3();
            col = i == 0 || i == 2 || i == 4 || i == 6 || i == 8 || i == 15 || i == 17 ? Vec3.BLACK : Vec3.YELLOW;
            Vec3 vec3 = col = takingDamage ? Vec3.WHITE : col;
            if (PacModel.headTop.faces.get(i).size() == 4) {
                botLeft = PacModel.headTop.vecs.get(PacModel.headTop.faces.get(i).get(3) - 1);
                botLeft = botLeft.multiply(scale);
                Quad.renderQuad(topLeft, topRight, botRight, botLeft, col);
            } else {
                Quad.renderQuad(topLeft, topRight, botRight, botRight, col);
            }
            ++i;
        }
        GL11.glPushMatrix();
        GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        if (item != null && item instanceof Helm) {
            GL11.glTranslatef(0.0f, 0.3f, 0.0f);
        }
        if (item != null) {
            item.renderOnModel();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(0.0f, 0.0f, ztrans);
        GL11.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(-a, 0.0f, 0.0f, 1.0f);
        i = 0;
        while (i < PacModel.headBot.faces.size()) {
            topLeft = PacModel.headBot.vecs.get(PacModel.headBot.faces.get(i).get(0) - 1);
            topRight = PacModel.headBot.vecs.get(PacModel.headBot.faces.get(i).get(1) - 1);
            botRight = PacModel.headBot.vecs.get(PacModel.headBot.faces.get(i).get(2) - 1);
            topLeft = topLeft.multiply(scale);
            topRight = topRight.multiply(scale);
            botRight = botRight.multiply(scale);
            col = new Vec3();
            col = i == 0 || i == 2 || i == 4 || i == 6 || i == 13 || i == 15 || i == 21 ? Vec3.BLACK : Vec3.YELLOW;
            if (PacModel.headBot.faces.get(i).size() == 4) {
                botLeft = PacModel.headBot.vecs.get(PacModel.headBot.faces.get(i).get(3) - 1);
                botLeft = botLeft.multiply(scale);
                Quad.renderQuad(topLeft, topRight, botRight, botLeft, col);
            } else {
                Quad.renderQuad(topLeft, topRight, botRight, botRight, col);
            }
            ++i;
        }
        GL11.glPopMatrix();
    }
}

