/*
 * Decompiled with CFR 0.152.
 */
package game.model;

import game.figureRender.Box;
import game.items.Item;
import game.model.Model;
import game.util.Vec3;

public class SteveModel
extends Model {
    private float size = 0.2f;
    private final Vec3 shirtCol = Vec3.CYAN;
    private final Vec3 pantsCol = Vec3.BLUE;
    private final Vec3 shoeCol = Vec3.BLACK;
    private final Vec3 skinCol = new Vec3(1.0f, 0.8666667f, 0.61960787f);

    public SteveModel() {
        this.bodyTopWidth = this.size * 3.0f;
        this.bodyBotWidth = this.size;
        this.bodyHeight = 1.0f;
        this.armUpperLength = 0.5f;
        this.armLowerLength = 0.3f;
        this.handLength = 0.2f;
        this.headLength = 0.3f;
        this.legUpperLength = 0.4f;
        this.legLowerLength = 0.4f;
        this.feetLength = 0.1f;
    }

    @Override
    protected void renderFootRight(boolean takingDamage) {
        Vec3 siz = new Vec3(this.size, 0.15f, this.size);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : this.shoeCol);
    }

    @Override
    protected void renderLegLowerRight(boolean takingDamage) {
        Vec3 siz = new Vec3(this.size, this.legUpperLength, this.size);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : this.pantsCol);
    }

    @Override
    protected void renderLegUpperRight(boolean takingDamage) {
        Vec3 siz = new Vec3(this.size, this.legUpperLength * 1.2f, this.size);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : this.pantsCol);
    }

    @Override
    protected void renderFootLeft(boolean takingDamage) {
        Vec3 siz = new Vec3(this.size, 0.15f, this.size);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : this.shoeCol);
    }

    @Override
    protected void renderLegLowerLeft(boolean takingDamage) {
        Vec3 siz = new Vec3(this.size, this.legUpperLength, this.size);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : this.pantsCol);
    }

    @Override
    protected void renderLegUpperLeft(boolean takingDamage) {
        Vec3 siz = new Vec3(this.size, this.legUpperLength * 1.2f, this.size);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : this.pantsCol);
    }

    @Override
    protected void renderArmLowerRight(boolean takingDamage) {
        Vec3 sizArm = new Vec3(this.size, this.armLowerLength, this.size);
        Box.renderBoxCorner(new Vec3(-sizArm.x / 2.0f, -this.armLowerLength, -sizArm.z / 2.0f), sizArm, takingDamage ? Vec3.WHITE : this.skinCol);
    }

    @Override
    protected void renderArmUpperRight(boolean takingDamage) {
        Vec3 sizShirt = new Vec3(this.size, this.armUpperLength * 0.7f, this.size);
        Box.renderBoxCorner(new Vec3(-sizShirt.x / 2.0f, -sizShirt.y, -sizShirt.z / 2.0f), sizShirt, takingDamage ? Vec3.WHITE : this.shirtCol);
        Vec3 sizArm = new Vec3(this.size, this.armUpperLength * 0.3f, this.size);
        Box.renderBoxCorner(new Vec3(-sizArm.x / 2.0f, -this.armUpperLength, -sizArm.z / 2.0f), sizArm, takingDamage ? Vec3.WHITE : this.skinCol);
    }

    @Override
    public void renderHead(Item item, boolean takingDamage) {
        Box.renderBox(new Vec3(0.0f, this.size * 1.0f, 0.0f), new Vec3(this.size * 2.0f), Vec3.GREEN, new int[]{Box.steveHeadHair, Box.steveHeadUnder, Box.steveHeadFront, Box.steveHeadHair, Box.steveHeadSide1, Box.steveHeadSide2});
        if (item != null) {
            item.renderOnModel();
        }
    }

    @Override
    protected void renderBody(boolean takingDamage) {
        Vec3 sizShirt = new Vec3(this.size * 2.0f, this.bodyHeight, this.size);
        Box.renderBoxCorner(new Vec3(-sizShirt.x / 2.0f, -sizShirt.y, -sizShirt.z / 2.0f), sizShirt, takingDamage ? Vec3.WHITE : this.shirtCol);
    }

    @Override
    protected void renderHandRight(Item item, boolean takingDamage) {
        Vec3 siz = new Vec3(this.size, 0.2f, this.size);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : this.skinCol);
        if (item != null) {
            item.renderOnModel();
        }
    }

    @Override
    protected void renderArmUpperLeft(boolean takingDamage) {
        Vec3 siz = new Vec3(this.size, this.armUpperLength * 0.7f, this.size);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : this.shirtCol);
        Vec3 sizArm = new Vec3(this.size, this.armUpperLength * 0.3f, this.size);
        Box.renderBoxCorner(new Vec3(-sizArm.x / 2.0f, -this.armUpperLength, -sizArm.z / 2.0f), sizArm, takingDamage ? Vec3.WHITE : this.skinCol);
    }

    @Override
    protected void renderArmLowerLeft(boolean takingDamage) {
        Vec3 sizArm = new Vec3(this.size, this.armLowerLength, this.size);
        Box.renderBoxCorner(new Vec3(-sizArm.x / 2.0f, -this.armLowerLength, -sizArm.z / 2.0f), sizArm, takingDamage ? Vec3.WHITE : this.skinCol);
    }

    @Override
    protected void renderHandLeft(boolean takingDamage) {
        Vec3 siz = new Vec3(this.size, 0.2f, this.size);
        Box.renderBoxCorner(new Vec3(-siz.x / 2.0f, -siz.y, -siz.z / 2.0f), siz, takingDamage ? Vec3.WHITE : this.skinCol);
    }
}

