/*
 * Decompiled with CFR 0.152.
 */
package game.model;

import game.figureRender.Box;
import game.items.Item;
import game.model.Model;
import game.util.Vec3;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;

public class StickModel
extends Model {
    public StickModel() {
        this.bodyTopWidth = 0.8f;
        this.bodyBotWidth = 0.3f;
        this.bodyHeight = 1.0f;
        this.armUpperLength = 0.5f;
        this.armLowerLength = 0.3f;
        this.handLength = 0.2f;
        this.headLength = 1.0f;
        this.legUpperLength = 0.4f;
        this.legLowerLength = 0.4f;
        this.feetLength = 0.1f;
    }

    @Override
    public void render(Item item, Model.Limb limb, boolean takingDamage) {
        Vec3 col = takingDamage ? Vec3.WHITE : new Vec3(0.0f);
        GL11.glPushMatrix();
        GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        float w = 0.1f;
        Box.renderBox(new Vec3(0.0f, -this.bodyHeight / 2.0f, 0.0f), new Vec3(w, this.bodyHeight, w), col);
        Box.renderBox(new Vec3(0.0f, 0.0f, 0.0f), new Vec3(this.bodyTopWidth, w, w), col);
        Box.renderBox(new Vec3(0.0f, -this.bodyHeight, 0.0f), new Vec3(this.bodyBotWidth, w, w), col);
        GL11.glPushMatrix();
        GL11.glRotatef(this.headRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.headRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.headRot.z, 0.0f, 0.0f, 1.0f);
        this.renderHead(limb != null && limb == Model.Limb.HEAD ? item : null, takingDamage);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armLeftUpperRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armLeftUpperRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.armLeftUpperRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        Box.renderBox(new Vec3(this.bodyTopWidth / 2.0f, -this.armUpperLength / 2.0f, 0.0f), new Vec3(w, this.armUpperLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, -this.armUpperLength, 0.0f);
        GL11.glRotatef(this.armLeftLowerRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armLeftLowerRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.armLeftLowerRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, this.armUpperLength, 0.0f);
        Box.renderBox(new Vec3(this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength / 2.0f, 0.0f), new Vec3(w, this.armLowerLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength, 0.0f);
        GL11.glRotatef(this.handLeftRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.handLeftRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.handLeftRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, this.armUpperLength + this.armLowerLength, 0.0f);
        Box.renderBox(new Vec3(this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength - this.handLength / 2.0f, 0.0f), new Vec3(w, this.handLength, w), col);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armRightUpperRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armRightUpperRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.armRightUpperRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        Box.renderBox(new Vec3(-this.bodyTopWidth / 2.0f, -this.armUpperLength / 2.0f, 0.0f), new Vec3(w, this.armUpperLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, -this.armUpperLength, 0.0f);
        GL11.glRotatef(this.armRightLowerRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.armRightLowerRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.armRightLowerRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, this.armUpperLength, 0.0f);
        Box.renderBox(new Vec3(-this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength / 2.0f, 0.0f), new Vec3(w, this.armLowerLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength, 0.0f);
        GL11.glRotatef(this.handRightRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.handRightRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.handRightRot.z, 0.0f, 0.0f, 1.0f);
        if (item != null && limb == Model.Limb.HAND_RIGHT) {
            item.renderOnModel();
        }
        GL11.glTranslatef(this.bodyTopWidth / 2.0f, this.armUpperLength + this.armLowerLength, 0.0f);
        Box.renderBox(new Vec3(-this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength - this.handLength / 2.0f, 0.0f), new Vec3(w, this.handLength, w), col);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, -this.bodyHeight, 0.0f);
        GL11.glRotatef(this.legLeftUpperRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.legLeftUpperRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.legLeftUpperRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, this.bodyHeight, 0.0f);
        Box.renderBox(new Vec3(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength / 2.0f, 0.0f), new Vec3(w, this.legUpperLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength, 0.0f);
        GL11.glRotatef(this.legLeftLowerRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.legLeftLowerRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.legLeftLowerRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength, 0.0f);
        Box.renderBox(new Vec3(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength / 2.0f, 0.0f), new Vec3(w, this.legLowerLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, 0.0f);
        GL11.glRotatef(this.footLeftRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.footLeftRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.footLeftRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength + this.legLowerLength, 0.0f);
        Box.renderBox(new Vec3(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, this.feetLength / 2.0f), new Vec3(w, w, this.feetLength), col);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, -this.bodyHeight, 0.0f);
        GL11.glRotatef(this.legRightUpperRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.legRightUpperRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.legRightUpperRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, this.bodyHeight, 0.0f);
        Box.renderBox(new Vec3(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength / 2.0f, 0.0f), new Vec3(w, this.legUpperLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength, 0.0f);
        GL11.glRotatef(this.legRightLowerRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.legRightLowerRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.legRightLowerRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength, 0.0f);
        Box.renderBox(new Vec3(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength / 2.0f, 0.0f), new Vec3(w, this.legLowerLength, w), col);
        GL11.glPushMatrix();
        GL11.glTranslatef(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, 0.0f);
        GL11.glRotatef(this.footRightRot.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.footRightRot.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.footRightRot.z, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength + this.legLowerLength, 0.0f);
        Box.renderBox(new Vec3(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, this.feetLength / 2.0f), new Vec3(w, w, this.feetLength), col);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    @Override
    public void renderHead(Item item, boolean takingDamage) {
        if (item != null) {
            item.renderOnModel();
        } else {
            Color.white.bind();
            GL11.glBindTexture(3553, Box.troll);
            GL11.glBegin(7);
            float y = 1.0f;
            float x = 1.0f;
            GL11.glTexCoord2f(x, y);
            GL11.glVertex3f(0.0f, 0.0f, this.headLength / 2.0f);
            GL11.glTexCoord2f(0.0f, y);
            GL11.glVertex3f(0.0f, 0.0f, -this.headLength / 2.0f);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(0.0f, this.headLength, -this.headLength / 2.0f);
            GL11.glTexCoord2f(x, 0.0f);
            GL11.glVertex3f(0.0f, this.headLength, this.headLength / 2.0f);
            GL11.glEnd();
            GL11.glBindTexture(3553, 0);
        }
    }
}

