/*
 * Decompiled with CFR 0.152.
 */
package game.network;

import com.esotericsoftware.kryonet.Client;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Listener;
import game.figureRender.Box;
import game.main.Camera;
import game.main.Game;
import game.main.Keys;
import game.main.Render;
import game.model.BirdieModel;
import game.model.GabenModel;
import game.model.Model;
import game.model.PacModel;
import game.model.SteveModel;
import game.model.StickModel;
import game.network.GameServer;
import game.network.Network;
import game.util.Input;
import game.util.Vec3;
import java.io.IOException;
import org.lwjgl.opengl.GL11;

public class GameClient {
    Client client;
    String name;
    Input input;
    int id;
    volatile boolean simulationDone;
    volatile boolean keysSent;
    boolean isHost = false;
    volatile boolean startSent;
    Game game;
    volatile boolean isInGame;
    Network.ClientInformation keyInformation = new Network.ClientInformation();
    public static final int LOCAL_SIMULATIONS = 5;
    public static int LOCAL_SLEEP_TIME = 16;
    Object networkLock = new Object();
    private final int windowWidth;
    private final int windowHeight;
    private Network.ServerLobbyState currentLobbyState = new Network.ServerLobbyState();
    private Network.LobbyPlayer myLobbyState = new Network.LobbyPlayer();
    private volatile boolean unsentLobbyChanges = false;
    private int selectedChoice = 0;
    private boolean gameInitDone;
    private static String error = "Fel";
    private static volatile boolean accepted = false;
    private static volatile boolean refused = false;
    private Model[] models = new Model[]{new SteveModel(), new StickModel(), new BirdieModel(), new GabenModel(), new PacModel()};
    private String[] names = new String[]{"Steve", "Trollpojken", "F\u00e5geln", "Gaben", "Puck Man"};

    public GameClient(Input i, Game g, int windowWidth, int windowHeight) {
        this.input = i;
        this.game = g;
        this.windowWidth = windowWidth;
        this.windowHeight = windowHeight;
        this.reset(false);
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean serverReset) {
        this.simulationDone = true;
        this.keysSent = false;
        this.startSent = false;
        this.isInGame = false;
        this.gameInitDone = false;
        if (this.client != null && this.isHost && serverReset) {
            this.client.sendTCP(new Network.ClientGoToLobby());
        }
        this.myLobbyState.ready = false;
        this.unsentLobbyChanges = true;
    }

    public void update() {
        if (!this.isInGame) {
            this.updateLobby();
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = GameClient.this.networkLock;
                synchronized (object) {
                    if (GameClient.this.simulationDone && !GameClient.this.keysSent) {
                        GameClient.this.client.sendTCP(GameClient.this.keyInformation);
                        GameClient.this.keyInformation = new Network.ClientInformation();
                        GameClient.this.keysSent = true;
                    }
                }
            }
        }.start();
        this.keyInformation.UP_DOWN |= this.input.isKeyDown(Keys.UP);
        this.keyInformation.DOWN_DOWN |= this.input.isKeyDown(Keys.DOWN);
        this.keyInformation.LEFT_DOWN |= this.input.isKeyDown(Keys.LEFT);
        this.keyInformation.RIGHT_DOWN |= this.input.isKeyDown(Keys.RIGHT);
        this.keyInformation.JUMP_DOWN |= this.input.isKeyDown(Keys.JUMP);
        this.keyInformation.PRIMARY_DOWN |= this.input.isKeyDown(Keys.PRIMARY);
        this.keyInformation.SECONDARY_DOWN |= this.input.isKeyDown(Keys.SECONDARY);
        this.keyInformation.SHIELD_DOWN |= this.input.isKeyDown(Keys.SHIELD);
        this.keyInformation.UP_PRESSED |= this.input.isKeyPressed(Keys.UP);
        this.keyInformation.DOWN_PRESSED |= this.input.isKeyPressed(Keys.DOWN);
        this.keyInformation.LEFT_PRESSED |= this.input.isKeyPressed(Keys.LEFT);
        this.keyInformation.RIGHT_PRESSED |= this.input.isKeyPressed(Keys.RIGHT);
        this.keyInformation.JUMP_PRESSED |= this.input.isKeyPressed(Keys.JUMP);
        this.keyInformation.PRIMARY_PRESSED |= this.input.isKeyPressed(Keys.PRIMARY);
        this.keyInformation.SECONDARY_PRESSED |= this.input.isKeyPressed(Keys.SECONDARY);
        this.keyInformation.SHIELD_PRESSED |= this.input.isKeyPressed(Keys.SHIELD);
    }

    private void updateLobby() {
        boolean enter = this.input.isKeyPressed(28);
        boolean allReady = true;
        if (this.currentLobbyState != null && this.currentLobbyState.currentLobbyPlayers != null) {
            Network.LobbyPlayer[] lobbyPlayerArray = this.currentLobbyState.currentLobbyPlayers;
            int n = this.currentLobbyState.currentLobbyPlayers.length;
            int n2 = 0;
            while (n2 < n) {
                Network.LobbyPlayer lp = lobbyPlayerArray[n2];
                allReady = lp.ready && allReady;
                ++n2;
            }
        } else {
            allReady = false;
        }
        if (this.isHost && !this.startSent && enter && this.selectedChoice == 5 && allReady) {
            this.client.sendTCP(new Network.ClientStartGame());
            this.startSent = true;
        }
        if (this.input.isKeyPressed(19)) {
            this.myLobbyState.ready = !this.myLobbyState.ready;
            this.unsentLobbyChanges = true;
        }
        if (this.input.isKeyPressed(46)) {
            ++this.myLobbyState.character;
            if (this.myLobbyState.character == 5) {
                this.myLobbyState.character = 0;
            }
            this.unsentLobbyChanges = true;
        }
        if (this.isHost) {
            if (this.input.isKeyPressed(205)) {
                if (this.selectedChoice == 0) {
                    boolean bl = this.currentLobbyState.timeON = !this.currentLobbyState.timeON;
                }
                if (this.selectedChoice == 1 && !this.currentLobbyState.timeON) {
                    ++this.currentLobbyState.maxLives;
                }
                if (this.selectedChoice == 2 && this.currentLobbyState.timeON) {
                    ++this.currentLobbyState.maxTime;
                }
                if (this.selectedChoice == 3) {
                    boolean bl = this.currentLobbyState.itemsON = !this.currentLobbyState.itemsON;
                }
                if (this.selectedChoice == 4) {
                    this.currentLobbyState.eventsON = !this.currentLobbyState.eventsON;
                }
                this.unsentLobbyChanges = true;
            }
            if (this.input.isKeyPressed(203)) {
                if (this.selectedChoice == 0) {
                    boolean bl = this.currentLobbyState.timeON = !this.currentLobbyState.timeON;
                }
                if (this.selectedChoice == 1 && this.currentLobbyState.maxLives != 1 && !this.currentLobbyState.timeON) {
                    --this.currentLobbyState.maxLives;
                }
                if (this.selectedChoice == 2 && this.currentLobbyState.maxTime != 1 && this.currentLobbyState.timeON) {
                    --this.currentLobbyState.maxTime;
                }
                if (this.selectedChoice == 3) {
                    boolean bl = this.currentLobbyState.itemsON = !this.currentLobbyState.itemsON;
                }
                if (this.selectedChoice == 4) {
                    this.currentLobbyState.eventsON = !this.currentLobbyState.eventsON;
                }
                this.unsentLobbyChanges = true;
            }
        }
        if (this.unsentLobbyChanges) {
            this.client.sendTCP(this.myLobbyState);
            if (this.isHost) {
                this.client.sendTCP(this.currentLobbyState);
            }
            this.unsentLobbyChanges = false;
        }
    }

    public void join() {
        this.join("127.0.0.1");
    }

    public String join(String ip) {
        accepted = false;
        refused = false;
        error = "Fel";
        this.client = new Client();
        this.client.start();
        Network.register(this.client);
        this.client.addListener(new Listener.ThreadedListener(new Listener(){

            @Override
            public void connected(Connection connection) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void received(Connection connection, Object object) {
                if (object instanceof Network.RefuseConnection) {
                    error = ((Network.RefuseConnection)object).reason;
                    refused = true;
                }
                if (object instanceof Network.ServerID) {
                    accepted = true;
                    GameClient.this.id = ((Network.ServerID)object).ID;
                    GameClient.this.game.setMyPlayerID(GameClient.this.id);
                }
                if (object instanceof Network.ServerKeys) {
                    Object object2 = GameClient.this.networkLock;
                    synchronized (object2) {
                        GameClient.this.isInGame = true;
                        GameClient.this.simulationDone = false;
                        GameClient.this.keysSent = false;
                        Network.ServerKeys skeys = (Network.ServerKeys)object;
                        if (!GameClient.this.gameInitDone) {
                            GameClient.this.game.init(skeys, GameClient.this.currentLobbyState);
                            GameClient.this.gameInitDone = true;
                        }
                        long t0 = System.currentTimeMillis();
                        GameClient.this.game.simulate(skeys);
                        int i = 0;
                        while (i < skeys.keys.length) {
                            GameClient.this.setPressedFalse(skeys.keys[i]);
                            ++i;
                        }
                        i = 0;
                        while (i < 5) {
                            long t = System.currentTimeMillis();
                            long sleep = Math.max(0L, (long)LOCAL_SLEEP_TIME - t + t0);
                            try {
                                Thread.sleep(sleep);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            t0 = System.currentTimeMillis();
                            GameClient.this.game.simulate(skeys);
                            ++i;
                        }
                        GameClient.this.simulationDone = true;
                    }
                }
                if (object instanceof Network.ServerLobbyState) {
                    GameClient.this.currentLobbyState = (Network.ServerLobbyState)object;
                }
            }

            @Override
            public void disconnected(Connection connection) {
                System.err.println("Disconnected");
            }
        }));
        try {
            this.client.connect(5000, ip, Network.TCPport, Network.UDPport);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return "Fel";
        }
        while (!accepted && !refused) {
        }
        if (accepted) {
            return null;
        }
        if (refused) {
            if (error == null) {
                return "Fel";
            }
            return error;
        }
        return null;
    }

    protected void setPressedFalse(Network.ClientInformation ci) {
        ci.UP_PRESSED = false;
        ci.DOWN_PRESSED = false;
        ci.LEFT_PRESSED = false;
        ci.RIGHT_PRESSED = false;
        ci.JUMP_PRESSED = false;
        ci.PRIMARY_PRESSED = false;
        ci.SECONDARY_PRESSED = false;
        ci.SHIELD_PRESSED = false;
    }

    public void host(final int maxPlayers, final String serverName) {
        this.isHost = true;
        new Thread(){

            @Override
            public void run() {
                new GameServer(maxPlayers, serverName);
            }
        }.start();
        this.join("127.0.0.1");
    }

    private void selectChoice(int choises) {
        if (this.input.isKeyPressed(200)) {
            --this.selectedChoice;
            if (this.selectedChoice <= -1) {
                this.selectedChoice = choises - 1;
            }
        }
        if (this.input.isKeyPressed(208)) {
            ++this.selectedChoice;
            if (this.selectedChoice >= choises) {
                this.selectedChoice = 0;
            }
        }
    }

    private String getBlinkingLine(int selectedChoice, int correctChoice) {
        return selectedChoice == correctChoice && System.currentTimeMillis() % 1000L > 500L ? "|" : "";
    }

    public void render(Render render, int width, int height, Camera camera) {
        this.selectChoice(6);
        int xLeft = 100;
        int yLeft = height / 2 - 100;
        int xRight = width - 200;
        int yRight = height / 2 - 100;
        camera.pos = new Vec3();
        camera.rot = new Vec3();
        GL11.glPushMatrix();
        GL11.glRotatef((float)((double)System.currentTimeMillis() * 0.001 % 360.0), 0.0f, 0.0f, 1.0f);
        Box.renderBox(new Vec3(0.0f, 0.0f, 0.0f), new Vec3(25.0f), Box.skyFract);
        GL11.glPopMatrix();
        if (this.currentLobbyState.currentLobbyPlayers != null) {
            int i = 0;
            while (i < this.currentLobbyState.currentLobbyPlayers.length) {
                Network.LobbyPlayer slp = this.currentLobbyState.currentLobbyPlayers[i];
                int x = width / 2 - 225 + i * 150;
                int y = height / 2 - 200;
                render.drawString(x, y, slp.name, Vec3.WHITE, Vec3.BLACK, "LOBBY_FONT");
                render.drawString(x, y + 20, slp.ready ? "REDO" : "EJ REDO", Vec3.WHITE, Vec3.BLACK, "LOBBY_FONT");
                render.drawString(x, y + 40, this.names[slp.character], Vec3.WHITE, Vec3.BLACK, "LOBBY_FONT");
                GL11.glPushMatrix();
                GL11.glTranslatef(-2.25f + (float)i * 1.5f, 0.0f, -10.0f);
                GL11.glRotatef((float)(-90.0 + 45.0 * Math.sin((double)System.currentTimeMillis() * 0.001)), 0.0f, 1.0f, 0.0f);
                this.models[slp.character].render(null, null, false);
                GL11.glPopMatrix();
                ++i;
            }
        }
        render.drawString(width / 2 - 200, 50, "C - Byt karakt\u00e4r", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
        render.drawString(width / 2 - 200, 95, "R - Redo", Vec3.WHITE, Vec3.BLACK, "MENU_FONT");
        String s = this.currentLobbyState.timeON ? "Tid" : "Liv";
        render.drawString(xRight, yRight, "Spell\u00e4ge: " + s, Vec3.WHITE, Vec3.BLACK, "LOBBY_FONT");
        render.drawString(xRight, yRight + 20, "Antal liv: " + this.currentLobbyState.maxLives, this.currentLobbyState.timeON ? Vec3.GRAY : Vec3.WHITE, Vec3.BLACK, "LOBBY_FONT");
        render.drawString(xRight, yRight + 40, "Max tid: " + this.currentLobbyState.maxTime + " minuter", !this.currentLobbyState.timeON ? Vec3.GRAY : Vec3.WHITE, Vec3.BLACK, "LOBBY_FONT");
        render.drawString(xRight, yRight + 60, "Items: " + this.booleanToSwedish(this.currentLobbyState.itemsON), Vec3.WHITE, Vec3.BLACK, "LOBBY_FONT");
        render.drawString(xRight, yRight + 80, "Events: " + this.booleanToSwedish(this.currentLobbyState.eventsON), Vec3.WHITE, Vec3.BLACK, "LOBBY_FONT");
        if (this.isHost) {
            render.drawString(xRight, yRight + 100, "Starta spelet ", Vec3.WHITE, Vec3.BLACK, "LOBBY_FONT");
            render.drawString(xRight - 20, yRight + 20 * (this.selectedChoice % 6), "> ", Vec3.WHITE, Vec3.BLACK, "LOBBY_FONT");
        }
    }

    public String booleanToSwedish(boolean b) {
        return b ? "P\u00e5" : "Av";
    }

    public boolean isInGame() {
        return this.isInGame;
    }

    public void setName(String name) {
        this.myLobbyState.name = name;
        this.unsentLobbyChanges = true;
    }

    public boolean isGameFinished() {
        return this.game.isGameFinished();
    }
}

