/*
 * Decompiled with CFR 0.152.
 */
package game.network;

import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.Server;
import game.network.Network;
import game.util.Settings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class GameServer {
    Server server;
    ArrayList<Player> players = new ArrayList<E>();
    int nextFreePlayerID = 1;
    private Network.ServerLobbyState lobbyState;
    int maxPlayers;
    String serverName;
    private volatile State state = State.LOBBY;
    private ArrayList<Integer> disconnectedPlayerIDs = new ArrayList<E>();

    /*
     * Unable to fully structure code
     */
    public GameServer(int maxPlayers, String serverName) {
        super();
        this.maxPlayers = maxPlayers;
        this.serverName = serverName;
        this.initServer();
        this.lobbyState = new Network.ServerLobbyState();
        block6: while (true) {
            if (this.state == State.LOBBY) {
                this.lobbyState.currentLobbyPlayers = new Network.LobbyPlayer[this.players.size()];
                i = 0;
                while (i < this.players.size()) {
                    this.lobbyState.currentLobbyPlayers[i] = this.players.get((int)i).lobbyPlayer;
                    ++i;
                }
                this.lobbyState.seed = new Random().nextLong();
                this.server.sendToAllTCP(this.lobbyState);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            while (true) {
                if (this.state == State.GAME) ** break;
                continue block6;
                allKeysRecieved = true;
                i = 0;
                while (i < this.players.size()) {
                    if (!this.players.get((int)i).keysRecived) {
                        allKeysRecieved = false;
                    }
                    ++i;
                }
                if (allKeysRecieved) {
                    sk = new Network.ServerKeys();
                    sk.IDs = new int[this.players.size()];
                    sk.keys = new Network.ClientInformation[this.players.size()];
                    i = 0;
                    while (i < sk.IDs.length) {
                        sk.IDs[i] = this.players.get((int)i).ID;
                        sk.keys[i] = this.players.get((int)i).keys;
                        this.players.get((int)i).keysRecived = false;
                        ++i;
                    }
                    sk.disconnectedIDs = new int[this.disconnectedPlayerIDs.size()];
                    i = 0;
                    while (i < sk.disconnectedIDs.length) {
                        sk.disconnectedIDs[i] = this.disconnectedPlayerIDs.get(i);
                        ++i;
                    }
                    this.disconnectedPlayerIDs.clear();
                    this.server.sendToAllTCP(sk);
                }
                if (Settings.DEBUG_SIMULATED_SERVER_DELAY > 0) {
                    try {
                        Thread.sleep(Settings.DEBUG_SIMULATED_SERVER_DELAY);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            break;
        }
    }

    private void initServer() {
        this.server = new Server();
        Network.register(this.server);
        this.server.addListener(new Listener(){

            @Override
            public void received(Connection c, Object object) {
                if (object instanceof Network.ClientMessage) {
                    System.out.println("Server recieved message: " + ((Network.ClientMessage)object).message);
                }
                if (object instanceof Network.ClientInformation) {
                    Player p = GameServer.this.getPlayer(c);
                    p.keys = (Network.ClientInformation)object;
                    p.keysRecived = true;
                }
                if (object instanceof Network.ClientStartGame) {
                    GameServer.this.state = State.GAME;
                }
                if (object instanceof Network.ClientGoToLobby) {
                    GameServer.this.state = State.LOBBY;
                }
                if (object instanceof Network.LobbyPlayer) {
                    GameServer.this.getPlayer((Connection)c).lobbyPlayer = (Network.LobbyPlayer)object;
                }
                if (object instanceof Network.ServerLobbyState) {
                    GameServer.this.lobbyState = (Network.ServerLobbyState)object;
                }
            }

            @Override
            public void connected(Connection c) {
                c.sendTCP(GameServer.this.getServerInfo());
                if (GameServer.this.state == State.GAME) {
                    Network.RefuseConnection rc = new Network.RefuseConnection();
                    rc.reason = "Servern \u00e4r ej i lobby";
                    c.sendTCP(rc);
                } else if (GameServer.this.players.size() >= GameServer.this.maxPlayers) {
                    Network.RefuseConnection rc = new Network.RefuseConnection();
                    rc.reason = "Servern \u00e4r full";
                    c.sendTCP(rc);
                } else if (GameServer.this.state == State.LOBBY) {
                    int ID = GameServer.this.nextFreePlayerID++;
                    Network.ServerID si = new Network.ServerID();
                    si.ID = ID;
                    c.sendTCP(si);
                    GameServer.this.players.add(new Player(ID, c));
                }
            }

            @Override
            public void disconnected(Connection c) {
                int i = 0;
                while (i < GameServer.this.players.size()) {
                    if (GameServer.this.players.get((int)i).c == c) {
                        GameServer.this.disconnectedPlayerIDs.add(GameServer.this.players.get((int)i).ID);
                        GameServer.this.players.remove(i);
                        break;
                    }
                    ++i;
                }
            }
        });
        try {
            this.server.bind(Network.TCPport, Network.UDPport);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.server.start();
    }

    protected Network.ServerInfo getServerInfo() {
        Network.ServerInfo si = new Network.ServerInfo();
        si.serverName = this.serverName;
        si.timeON = this.lobbyState != null && this.lobbyState.timeON;
        si.inLobby = this.state == State.LOBBY;
        si.players = this.players.size();
        si.maxPlayers = this.maxPlayers;
        return si;
    }

    protected Player getPlayer(Connection c) {
        int i = 0;
        while (i < this.players.size()) {
            if (c.equals(this.players.get((int)i).c)) {
                return this.players.get(i);
            }
            ++i;
        }
        return null;
    }

    public class Player {
        int ID;
        Connection c;
        boolean keysRecived;
        Network.ClientInformation keys;
        Network.LobbyPlayer lobbyPlayer = new Network.LobbyPlayer();

        public Player(int ID, Connection c) {
            this.ID = ID;
            this.c = c;
        }
    }

    private static enum State {
        LOBBY,
        GAME;

    }
}

