/*
 * Decompiled with CFR 0.152.
 */
package game.network;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryonet.EndPoint;

public class Network {
    public static int TCPport = 6112;
    public static int UDPport = 54777;

    public static void register(EndPoint endPoint) {
        Kryo kryo = endPoint.getKryo();
        kryo.register(String.class);
        kryo.register(int[].class);
        kryo.register(ClientInformation.class);
        kryo.register(ClientInformation[].class);
        kryo.register(ClientMessage.class);
        kryo.register(ClientStartGame.class);
        kryo.register(ClientGoToLobby.class);
        kryo.register(ServerKeys.class);
        kryo.register(ServerID.class);
        kryo.register(ServerLobbyState.class);
        kryo.register(LobbyPlayer.class);
        kryo.register(LobbyPlayer[].class);
        kryo.register(RefuseConnection.class);
        kryo.register(ServerInfo.class);
    }

    public static class ClientGoToLobby {
    }

    public static class ClientInformation {
        public boolean UP_DOWN;
        public boolean DOWN_DOWN;
        public boolean LEFT_DOWN;
        public boolean RIGHT_DOWN;
        public boolean UP_PRESSED;
        public boolean DOWN_PRESSED;
        public boolean LEFT_PRESSED;
        public boolean RIGHT_PRESSED;
        public boolean JUMP_DOWN;
        public boolean PRIMARY_DOWN;
        public boolean SECONDARY_DOWN;
        public boolean SHIELD_DOWN;
        public boolean JUMP_PRESSED;
        public boolean PRIMARY_PRESSED;
        public boolean SECONDARY_PRESSED;
        public boolean SHIELD_PRESSED;
    }

    public static class ClientMessage {
        public String message;
    }

    public static class ClientStartGame {
    }

    public static class LobbyPlayer {
        public String name = "name not set";
        public int team;
        public int character;
        public boolean ready;

        public LobbyPlayer() {
        }

        public LobbyPlayer(String name, int character, int team, boolean ready) {
            this.name = name;
            this.team = team;
            this.character = character;
            this.ready = ready;
        }
    }

    public static class RefuseConnection {
        public String reason;
    }

    public static class ServerID {
        public int ID;
    }

    public static class ServerInfo {
        public String serverName;
        public int maxPlayers;
        public int players;
        public int time;
        public boolean timeON;
        public int maxLives;
        public boolean inLobby;
        public String password;
        public boolean passwordON;
        public String ip;

        public String toString() {
            return String.valueOf(this.serverName) + " " + (this.timeON ? "TID" : "LIV") + " " + this.players + "/" + this.maxPlayers + " [" + (this.inLobby ? "i lobby" : "spelar") + "]";
        }
    }

    public static class ServerKeys {
        public int[] IDs;
        public ClientInformation[] keys;
        public int[] disconnectedIDs;
    }

    public static class ServerLobbyState {
        public LobbyPlayer[] currentLobbyPlayers;
        public long seed;
        public boolean itemsON = true;
        public boolean eventsON = true;
        public boolean timeON = false;
        public int maxLives = 3;
        public int maxTime = 5;
    }
}

