/*
 * Decompiled with CFR 0.152.
 */
package game.projectiles;

import game.figureRender.Quad;
import game.main.Game;
import game.main.Main;
import game.main.Player;
import game.projectiles.Projectile;
import game.sound.Sound;
import game.util.Rect;
import game.util.Vec2;
import game.util.Vec3;

public class Bullet
extends Projectile {
    private float damage = 5.0f;
    private boolean soundPlayed = false;
    private Vec2 speed;
    private int ticks = 0;
    private int duration = Main.MILLIS_TO_TICKS(1000);

    public Bullet(Player player, Game game, float headingDeg) {
        super(player, game);
        this.size = 0.1f;
        Vec2 pos = player.getPos().clone();
        pos.y += 1.5f;
        this.hitBox = new Rect(pos.x, pos.y, this.size, this.size);
        float s = 0.3f;
        this.speed = new Vec2((float)Math.cos(Math.toRadians(headingDeg)), (float)Math.sin(Math.toRadians(headingDeg)));
        this.speed = this.speed.multiply(s);
        Main.SOUND.play(Sound.PUNCH_MISS);
    }

    @Override
    public void simulate() {
        Player[] players;
        ++this.ticks;
        this.hitBox.x += this.speed.x;
        this.hitBox.y += this.speed.y;
        if (this.game.getMap().collides(this) != null) {
            this.shallBeRemoved = true;
        }
        if (this.ticks > this.duration) {
            this.shallBeRemoved = true;
        }
        Player[] playerArray = players = this.game.getAllPlayers();
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (p.isEnemyTo(this.player) && p.getCollisionRect().intersects(this.hitBox)) {
                this.shallBeRemoved = true;
                p.takeDamage((double)this.damage, this.player);
                if (this.soundPlayed) break;
                this.soundPlayed = true;
                Main.SOUND.play(Sound.PUNCH);
                break;
            }
            ++n2;
        }
    }

    @Override
    public void render() {
        float s = 3.0f;
        Vec3 p1 = new Vec3(this.hitBox.x, this.hitBox.y, 0.0f);
        Vec3 p2 = new Vec3(this.hitBox.x + this.speed.x * s, this.hitBox.y + this.speed.y * s, 0.0f);
        Quad.renderQuad(p1, p1.add(new Vec3(0.0f, 0.05f, 0.0f)), p2.add(new Vec3(0.0f, 0.05f, 0.0f)), p2, Vec3.RED);
    }
}

