/*
 * Decompiled with CFR 0.152.
 */
package game.projectiles;

import game.figureRender.Quad;
import game.main.Game;
import game.main.Main;
import game.main.Player;
import game.projectiles.Projectile;
import game.sound.Sound;
import game.util.Rect;
import game.util.Vec2;
import game.util.Vec3;

public class Fireball
extends Projectile {
    private float damage = 5.0f;
    private boolean soundPlayed = false;
    private Vec2 speed;
    private int ticks = 0;
    private int duration = Main.MILLIS_TO_TICKS(500);

    public Fireball(Player player, Game game, float headingDeg) {
        super(player, game);
        this.size = 0.5f;
        Vec2 pos = player.getPos().clone();
        pos.y += 1.5f;
        this.hitBox = new Rect(pos.x, pos.y, this.size, this.size);
        float s = 0.15f;
        this.speed = new Vec2((float)Math.cos(Math.toRadians(headingDeg)), (float)Math.sin(Math.toRadians(headingDeg)));
        this.speed = this.speed.multiply(s);
        Main.SOUND.play(Sound.FIRE);
    }

    @Override
    public void simulate() {
        Player[] players;
        ++this.ticks;
        this.hitBox.x += this.speed.x;
        this.hitBox.y += this.speed.y;
        if (this.game.getMap().collides(this) != null) {
            this.shallBeRemoved = true;
        }
        if (this.ticks > this.duration) {
            this.shallBeRemoved = true;
        }
        Player[] playerArray = players = this.game.getAllPlayers();
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (p.isEnemyTo(this.player) && p.getCollisionRect().intersects(this.hitBox)) {
                this.shallBeRemoved = true;
                p.takeDamage((double)this.damage, this);
                if (this.soundPlayed) break;
                this.soundPlayed = true;
                Main.SOUND.play(Sound.PUNCH);
                break;
            }
            ++n2;
        }
    }

    @Override
    public void render() {
        Vec3 center = new Vec3((float)((double)this.hitBox.x + (double)this.size / 2.0), (float)((double)this.hitBox.y + (double)this.size / 2.0), 0.0f);
        int i = 0;
        while (i < 20) {
            double a1 = Math.random() * Math.PI * 2.0;
            double a2 = Math.random() * Math.PI * 2.0;
            double r = Math.random() * (double)this.size / 2.0;
            Vec3 col = new Vec3(1.0f, 0.003921569f * (float)((int)(Math.random() * 63.0 * (4.0 - Math.random() * 4.0))), 0.0f);
            Vec3 out = new Vec3((float)(Math.sin(a1) * Math.sin(a2)), (float)(Math.cos(a1) * Math.sin(a2)), (float)Math.cos(a2));
            out = out.multiply(this.size);
            out = center.add(out);
            Quad.renderQuad(center, center.add(new Vec3((float)(Math.random() * r), (float)(Math.random() * r * 0.1), (float)(Math.random() * r * 0.1))), out, out, col);
            ++i;
        }
    }
}

