/*
 * Decompiled with CFR 0.152.
 */
package game.sound;

import game.sound.SoundFile;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.swing.JOptionPane;

public class Sound {
    public static final SoundFile FUS_RO_DAH = new SoundFile("thunder.wav");
    public static final SoundFile DRINK = new SoundFile("drink.wav");
    public static final SoundFile EATING = new SoundFile("eating.wav");
    public static final SoundFile PUNCH = new SoundFile("punch.wav");
    public static final SoundFile PUNCH_MISS = new SoundFile("punch_miss.wav");
    public static final SoundFile OUCH = new SoundFile("ouch.wav");
    public static final SoundFile GAME_MUSIC = new SoundFile("game_music2.wav");
    public static final SoundFile CRT_BREAK = new SoundFile("crt_break.wav");
    public static final SoundFile LASER = new SoundFile("laser.wav");
    public static final SoundFile FIREWORKS = new SoundFile("fireworks.wav");
    public static final SoundFile RESPAWN = new SoundFile("respawn.wav");
    public static final SoundFile DRILL = new SoundFile("drill.wav");
    public static final SoundFile MENU_MUSIC = new SoundFile("menu_music.wav");
    public static final SoundFile EL = new SoundFile("el.wav");
    public static final SoundFile FIRE = new SoundFile("fire.wav");
    public static final SoundFile CLICK = new SoundFile("click.wav");
    private SoundFile currentMusic;
    private double soundVolume;
    private double musicVolume;
    private Clip musicClip;

    public Sound(double soundVolume, double musicVolume) {
        this.soundVolume = soundVolume;
        this.musicVolume = musicVolume;
    }

    public void play(SoundFile sound) {
        try {
            Clip clip = (Clip)AudioSystem.getLine(sound.info);
            clip.open(sound.af, sound.audio, 0, sound.size);
            FloatControl volume = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            volume.setValue((float)(20.0 * Math.log10(this.soundVolume)));
            clip.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "play sound " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setMusic(SoundFile music) {
        if (this.currentMusic == music) {
            return;
        }
        if (this.musicClip != null) {
            this.musicClip.stop();
        }
        this.currentMusic = music;
        try {
            this.musicClip = (Clip)AudioSystem.getLine(music.info);
            this.musicClip.open(music.af, music.audio, 0, music.size);
            this.musicClip.loop(-1);
            FloatControl volume = (FloatControl)this.musicClip.getControl(FloatControl.Type.MASTER_GAIN);
            volume.setValue((float)(20.0 * Math.log10(this.musicVolume)));
            this.musicClip.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "set music " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void stopMusic() {
        this.currentMusic = null;
        this.musicClip.stop();
    }
}

