/*
 * Decompiled with CFR 0.152.
 */
package game.util;

public class Rect {
    public float x;
    public float y;
    public float w;
    public float h;

    public Rect(float x, float y, float w, float h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public boolean intersects(Rect r) {
        Rect r1 = this;
        Rect r2 = r;
        float xmin = Math.max(r1.x, r2.x);
        float xmax1 = r1.x + r1.w;
        float xmax2 = r2.x + r2.w;
        float xmax = Math.min(xmax1, xmax2);
        if (xmax > xmin) {
            float ymin = Math.max(r1.y, r2.y);
            float ymax1 = r1.y + r1.h;
            float ymax2 = r2.y + r2.h;
            float ymax = Math.min(ymax1, ymax2);
            if (ymax > ymin) {
                return true;
            }
        }
        return false;
    }

    public Rect clone() {
        return new Rect(this.x, this.y, this.w, this.h);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ",  " + this.w + ",  " + this.h + ")";
    }
}

