/*
 * Decompiled with CFR 0.152.
 */
package game.util;

public class Vec3 {
    public float x;
    public float y;
    public float z;
    public static final Vec3 GRAY = new Vec3(0.5f, 0.5f, 0.5f);
    public static final Vec3 RED = new Vec3(1.0f, 0.0f, 0.0f);
    public static final Vec3 GREEN = new Vec3(0.0f, 1.0f, 0.0f);
    public static final Vec3 BLUE = new Vec3(0.0f, 0.0f, 1.0f);
    public static final Vec3 CYAN = new Vec3(0.0f, 1.0f, 1.0f);
    public static final Vec3 WHITE = new Vec3(1.0f, 1.0f, 1.0f);
    public static final Vec3 BLACK = new Vec3(0.0f, 0.0f, 0.0f);
    public static final Vec3 YELLOW = new Vec3(1.0f, 1.0f, 0.0f);
    public static final Vec3 BROWN = new Vec3(160.0f, 82.0f, 45.0f).multiply(0.003921569f);

    public Vec3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setToZero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vec3(float v) {
        this.x = v;
        this.y = v;
        this.z = v;
    }

    public Vec3 add(Vec3 v) {
        return new Vec3(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vec3 add(float x, float y, float z) {
        return new Vec3(this.x + x, this.y + y, this.z + z);
    }

    public Vec3 subtract(Vec3 v) {
        return new Vec3(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public Vec3 multiply(float f) {
        return new Vec3(this.x * f, this.y * f, this.z * f);
    }

    public Vec3() {
    }

    public Vec3 cross(Vec3 b) {
        return new Vec3(this.y * b.z - this.z * b.y, this.z * b.x - this.x * b.z, this.x * b.y - this.y * b.x);
    }

    public Vec3 clone() {
        return new Vec3(this.x, this.y, this.z);
    }

    public float norm() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

