if (typeof Btn === 'undefined') {
	var Btn = function(parent) {
		var identifier = null,
			mouseDown = false,
			mouseOver = false,
			dom = document.createElement("DIV"),
			onchange = function(pressed) {
				
			},
			onmousedown = function(e) {
				mouseDown = true;
				mouseOver = true;
				dom.setAttribute("active", "true");
				parent.onchange(true);
			},
			onmouseover = function(e) {
				if (mouseDown) {
					mouseOver = true;
					dom.setAttribute("active", "true");
				}
			},
			onmouseout = function(e) {
				if (mouseDown) {
					mouseOver = false;
					dom.setAttribute("active", "false");
				}
			},
			onmouseup = function(e) {
				mouseDown = false;
				if (mouseOver) {
					mouseOver = false;
					parent.onchange(false);
					dom.setAttribute("active", "false");
				}
			},
			touchstart = function(e) {
				var touchObject = e.changedTouches[0];
				identifier = touchObject.identifier;
				onmousedown();
				e.preventDefault();
			},
			touchenter = function(e) {
				var touchObject,
					i;
				if (identifier != null) {
					for (i = 0; i < e.changedTouches.length; i++) {
						touchObject = e.changedTouches[i];
						if (touchObject.identifier == identifier) {
							onmouseover();
						}
					}
				}
				e.preventDefault();
			},
			touchleave = function(e) {
				body.log("Touch leave");
				var touchObject,
					i;
				if (identifier != null) {
					for (i = 0; i < e.changedTouches.length; i++) {
						touchObject = e.changedTouches[i];
						if (touchObject.identifier == identifier) {
							onmouseout();
						}
					}
				}
				e.preventDefault();
			},
			touchend = function(e) {
				var touchObject,
					i;
				if (identifier != null) {
					for (i = 0; i < e.changedTouches.length; i++) {
						touchObject = e.changedTouches[i];
						if (touchObject.identifier == identifier) {
							onmouseup();
						}
					}
				}
				e.preventDefault();
			},
			resize = function() {
				var p = parent.parentNode,
					children = 0,
					height,
					size,
					i;
				for (i = 0; i < p.childNodes.length; i++) {
					if (typeof p.childNodes[i] !== 'undefined') {
						children++;
					}
				}
				height = Math.min(
					parent.parentNode.offsetHeight,
					parent.parentNode.offsetWidth
				);
				size = Math.min(
					parent.parentNode.offsetHeight,
					Math.floor(parent.parentNode.offsetWidth / children)
				);
				parent.style.height = height + 'px';
				parent.style.top = (parent.parentNode.offsetHeight - parent.offsetHeight) + 'px';
				if (parent.parentNode.firstChild === parent) {
					parent.style.width 		 =  size + 'px';
					parent.style.marginLeft  =  0    + 'px';
				} else {
					parent.style.width 		 =  size + 'px';
				}
				size = Math.min(
					size,
					parent.offsetHeight,
					parent.offsetWidth
				);
				dom.style.width = (0.8 * size) + 'px';
				dom.style.height = (0.8 * size) + 'px';
			};
		parent.appendChild(dom);
		resize()
		dom.pressed = false;
		if (isTouch) {
			dom.addListener('touchstart', touchstart, false);
			parent.addListener('touchenter', touchenter, false);
			parent.addListener('touchleave', function() { alert("touchleave"); }, false);
			window.addListener('touchend', touchend, false);
		} else {
			dom.addListener('onmousedown', onmousedown, false);
			parent.addListener('onmouseover', onmouseover, false);
			parent.addListener('onmouseout', onmouseout, false);
			window.addListener('onmouseup', onmouseup, false);
		}

		dom.parentNode.addListener('resize', resize, false);
		window.addListener('resize', resize, false);
		parent.onchange = onchange;
		return dom;
	}
}
