#ifndef _COMMON_HLSL_
#define _COMMON_HLSL_

#define ESCHER_DEBUG 1
static const float deformationScale = 3000.0;

float2 escherDeformation(in float2 uv)
{	
// http://www.ams.org/notices/200304/fea-escher.pdf
	
	float lnr = log(length(uv));
	float th = atan2( uv.y, uv.x )+(0.4/256.)*deformationScale;
	float sn = -log(deformationScale)*(1./(2.*3.1415926));
	float l = exp( lnr - th*sn ); 
	
	float2 ret = float2(l, l);
	
	ret.x *= cos( sn*lnr+th );
	ret.y *= sin( sn*lnr+th );
		
	return ret;
}

#define drostescale 256.


float2 greaterThan(float2 value, float2 comparison)  
{  
   return float2(value.x > comparison.x, value.y > comparison.y);
}  
 
float2 lessThan(float2 value, float2 comparison)  
{  
   return float2(value.x < comparison.x, value.y < comparison.y); 
} 
//
//bool greaterThanEqual(float3 value, float3 comparison)  
//{  
//   return (value.x >= comparison.x && value.y >= comparison.y && value.z >= comparison.z);  
//}  
// 
//bool lessThanEqual(float3 value, float3 comparison)  
//{  
//   return (value.x <= comparison.x && value.y <= comparison.y && value.z <= comparison.z);  
//} 

float2 drosteTransformation( in float2 uv ) {
	for( int i=0; i<2; i++ ) {
		if(any(greaterThan(abs(uv),float2(1, 1)))) {
			uv *= (1./drostescale);
		}		
		if(all(lessThan(abs(uv),float2(1./drostescale, 1./drostescale)))) {
			uv *= drostescale;
		}
	}
	return uv;
}

// 1D random numbers
float rand(float n)
{
    return frac(sin(n) * 43758.5453123);
}

// 2D random numbers
float2 rand2(in float2 p)
{
	return frac(float2(sin(p.x * 591.32 + p.y * 154.077), cos(p.x * 391.32 + p.y * 49.077)));
}

// 1D noise
float noise1(float p)
{
	float fl = floor(p);
	float fc = frac(p);
	return lerp(rand(fl), rand(fl + 1.0), fc);
}

// voronoi distance noise, based on iq's articles
float2 voronoi(in float2 x)
{
	float2 p = floor(x);
	float2 f = frac(x);
	
	float2 res = float2(8.0, 8.0);
	for (int j = -1; j <= 1; ++j)
	{
		for (int i = -1; i <= 1; ++i)
		{
			float2 b = float2(i, j);
			float2 r = float2(b) - f + rand2(p + b);
			
			// chebyshev distance - one of many ways to do this
			float d = max(abs(r.x), abs(r.y));
			
			if (d < res.x)
			{
				res.y = res.x;
				res.x = d;
			}
			else if (d < res.y)
			{
				res.y = d;
			}
		}
	}
	return res;
}

float hash1( float n ) { return frac(sin(n)*43758.5453); }
float2  hash2( float2  p ) { p = float2( dot(p,float2(127.1,311.7)), dot(p,float2(269.5,183.3)) ); return frac(sin(p)*43758.5453); }



float4 voronoi( in float2 x, float mode )
{
  float2 n = floor( x );
    float2 f = frac( x );

    float3 m = float3( 8.0, 8.0, 8.0 );
    float m2 = 8.0;
  for( int j=-2; j<=2; j++ )
    for( int i=-2; i<=2; i++ )
    {
      float2 g = float2( float(i),float(j) );
        float2 o = hash2( n + g );

        // animate
        o = 0.5 + 0.5*sin( iGlobalTime + 6.2831*o );

      float2 r = g - f + o;

        // euclidean		
        float2 d0 = float2( sqrt(dot(r,r)), 1.0 );
        // manhattam		
        float2 d1 = float2( 0.71*(abs(r.x) + abs(r.y)), 1.0 );
        // triangular		
        float2 d2 = float2( max(abs(r.x)*0.866025+r.y*0.5,-r.y), 
        step(0.0,0.5*abs(r.x)+0.866025*r.y)*(1.0+step(0.0,r.x)) );

      float2 d = d0; 
        if( mode<3.0 ) d=lerp( d2, d0, frac(mode) );
      if( mode<2.0 ) d=lerp( d1, d2, frac(mode) );
      if( mode<1.0 ) d=lerp( d0, d1, frac(mode) );

      if( d.x<m.x )
      {
        m2 = m.x;
        m.x = d.x;
        m.y = hash1( dot(n+g,float2(7.0,113.0) ) );
        m.z = d.y;
      }
      else if( d.x<m2 )
      {
        m2 = d.x;
      }

    }
    return float4( m, m2-m.x );
}


#endif